; strchr
;   AAA=str
;   BBB=006
;   F=
;   O=
; str006.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strchr:FN_CALL PTR
p_fn_strchr P_FN_CALL strchr
EXTERNDEF C p_fn_fc_strchr:FN_CALL PTR
p_fn_fc_strchr P_FN_CALL @strchr
EXTERNDEF C p_fn_strchr_sss:FN_CALL PTR
p_fn_strchr_sss P_FN_CALL strchr_sss
EXTERNDEF C p_fn_fc_strchr_sss:FN_CALL PTR
p_fn_fc_strchr_sss P_FN_CALL @strchr_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strchr() -- Search string for char
;char __near *	fn_call strchr(const char __near * const,const int);
; GIVEN:
;   p_str	near pointer, offset from ds
;   chr 	the character to search for
; RETURNS: (char *)
;   pointer	near pointer, offset from ds
;		to the ending '\0' if char not found
;		to the character if found
; NOTES:
;   may search for '\0', then will return pointing to '\0'
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strchr PROC FN_CALL C USES si, p_str:NEAR16 PTR BYTE, chr:WORD
	    mov si, [p_str]	    ;ds:si = string pointer
	    mov ah, BYTE PTR [chr]  ;AH = char

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:
	    dec si
	    mov ax, si
	    ret
strchr	ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strchr() -- Search string for char
;char __near *	__fastcall fn_call strchr(const char __near * const,const int);
; __fastcall
; GIVEN:
;   BX	    p_str, offset from ds
;   AX	    chr
; RETURNS:
;   AX	    near pointer, offset from ds
;		to the ending '\0' if char not found
;		to the character if found
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strchr PROC FN_CALL USES si
	    mov si, bx	    ;ds:si = p_str
	    xchg ah, al	    ;ah = chr

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:     dec si
	    mov ax, si
	    ret
@strchr ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strchr_sss() -- Search string for char
;char __near *	fn_call strchr_sss(const char __near * const,const int);
; GIVEN:
;   p_str	near pointer, offset from ss
;   chr 	the character to search for
; RETURNS: (char *)
;   pointer	near pointer, offset from ss
;		to the ending '\0' if char not found
;		to the character if found
; NOTES:
;   may search for '\0', then will return pointing to '\0'
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
strchr_sss PROC FN_CALL C USES ds si, p_str:NEAR16 PTR BYTE, chr:WORD
	    mov ax, ss
	    mov ds, ax

	    mov si, [p_str]	    ;ds:si = string pointer
	    mov ah, BYTE PTR [chr]  ;AH = char

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:     dec si
	    mov ax, si
	    ret
strchr_sss	ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;strchr_sss() -- Search string for char
;char __near *	__fastcall fn_call strchr_sss(const char __near * const,const int);
; __fastcall
; GIVEN:
;   BX	    p_str, offset from ss
;   AX	    chr
; RETURNS:
;   AX	    near pointer, offset from ss
;		to the ending '\0' if char not found
;		to the character if found
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@strchr_sss PROC FN_CALL USES ds si bx
	    mov si, bx	    ;ds:si = p_str
	    xchg ah, al	    ;ah = chr
	    mov bx, ss
	    mov ds, bx

@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    test al,al		    ;Null, not found
	    jz @@done
            cmp al,ah               ;Loop while not equal
	    jne @@loop

@@done:     dec si
	    mov ax, si
	    ret
@strchr_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
