; @memcmp_sss
;   AAA=str
;   BBB=018
;   F=
;   O=
; str01811.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_memcmp_sss:FN_CALL PTR
p_fn_fc_memcmp_sss P_FN_CALL @memcmp_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;memcmp_sss() -- Compare memory blocks
;int __fastcall fn_call memcmp_sss(const void __near * const, const void __near * const, const int);
; __fastcall
; GIVEN:
;   BX	    p_m1, (dest) offset from ds
;   AX	    p_m2, (source) offset from ss
;   DX	    cnt
;RETURNS:
;   AX
;   <0		m1 < m2
;   0		m1 = m2
;   >0		m1 > m2
BEGIN_CODE_SEGMENT <STRING>
@memcmp_sss PROC FN_CALL USES ds es si di bx cx

	    mov di, bx	    ;es:di = p_m1
	    mov si, ax	    ;ds:si = p_m2
			    ;dx = cnt
	    mov bx, ds
	    mov es, bx
	    mov cx, ss
	    mov ds, cx

	    xor ax, ax
	    cmp bx, cx
	    jne @@cont
	    cmp si,di		    ;Equal?
	    je @@cont
	    jmp @@done		    ; Equal
@@cont:
	    mov cx, dx	   ;CX = count
	    jcxz @@done
	    repe cmps BYTE PTR ds:[si], es:[di]	    ;Compare memory
	    ; if ZF, then success
	    je @@done
	    ja @@above
	    ; below (p_m2<p_m1, or p_m1<p_m2)
	    inc ax
	    jmp @@done
@@above:
	    ; above (p_m2>p_m1, or p_m1<p_m2)
	    dec ax
@@done:
	    ret
@memcmp_sss ENDP
END_CODE_SEGMENT <STRING>
END
