; strupr
;   AAA=str
;   BBB=013
;   F=0
;   O=0
; str01300.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strupr:FN_CALL PTR
p_fn_strupr P_FN_CALL strupr
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strupr() -- Convert string to uppercase
;char __near * fn_call strupr(char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ds
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ds (p_str)
BEGIN_CODE_SEGMENT <STRING>
strupr PROC FN_CALL C uses es si di, p_str:NEAR16 PTR BYTE

	    mov ax, ds
	    mov es, ax

	    mov si, [p_str]	    ;ds:si = p_str
	    mov di, [p_str]	    ;es:di = p_str

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    cmp al,'a'		    ;Check for lowercase
	    jb @F
            cmp al,'z'
	    ja @F
		sub al,20h	    ;Convert to uppercase
@@:
	    stos BYTE PTR es:[di]   ; Store char
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, [p_str]	; return p_str
	    ret

strupr ENDP
END_CODE_SEGMENT <STRING>
END
