; skiptosr
;   AAA=str
;   BBB=011
;   F=0
;   O=0
; str01100.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_skiptosr:FN_CALL PTR
p_fn_skiptosr P_FN_CALL skiptosr
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

; skiptosr - skip to white space reverse
; char __near * fn_call skiptosr(const char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ds
; RETURNS: (char __far *)
;   pointer	near pointer, offset from ds
;		to the last white space character in the string
;		to the terminating '\0' if no white space chars in string
BEGIN_CODE_SEGMENT <STRING>
skiptosr PROC FN_CALL C USES si, p_str:NEAR16 PTR BYTE
    mov si, [p_str] ; ds:[si] = p_str
    xor dx, dx	; dx = 0
    dec dx	; dx = -1

@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 20h
    je @@space
    cmp al, 09h
    jb @@luup
    cmp al, 0Dh
    ja @@luup
@@space:
    mov dx, si
    jmp @@luup
@@done:
    cmp dx, -1
    je @F
      mov si, dx
@@:
    dec si
    mov ax, si
    ret
skiptosr ENDP
END_CODE_SEGMENT <STRING>
END
