; @stricmp
;   AAA=str
;   BBB=009
;   F=0
;   O=1
; str00910.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_stricmp:FN_CALL PTR
p_fn_fc_stricmp P_FN_CALL @stricmp
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

; stricmp() -- Compare strings, case insensitive (lowercase)
;int __farcall fn_call stricmp(const char __near * const, const char __near * const);
; __farcall
; GIVEN:
;   BX	    p_str1, (dest) offset from ds
;   AX	    p_str2, (source) offset from ds
; RETURNS:
;   AX
;   <0		str1 < str2
;   0		str1 = str2
;   >0		str1 > str2
BEGIN_CODE_SEGMENT <STRING>
@stricmp PROC FN_CALL USES es si di cx dx

	    mov di, bx	    ;es/ss:di = p_str1
	    mov si, ax	    ;ds:si = p_str2

	    mov ax, ds
	    mov es, ax


	    mov cx, ds
	    cmp ax, cx
	    jne @@cont
	    cmp si, di
	    jne @@cont
	    xor ax, ax
	    jmp @@exit
@@cont:

@@loop:     lodsb ds:[si]	    ;load al char str2
	    mov ah, es:[di]	    ;load ah char str1
            inc di

	    cmp al,'A'		    ;Convert AL to lowercase
	    jb @@noALchange
	    cmp al,'Z'
	    ja @@noALchange
	    or al, 00100000b

@@noALchange:
	    cmp ah,'A'		   ;Convert AH to lowercase
	    jb @@noAHchange
	    cmp ah,'Z'
	    ja @@noAHchange
	    or ah, 00100000b

@@noAHchange:
	    cmp ah,al		   ; al == ah ?
	    jne @@notequal
	    test al,al		   ;Loop while not zero
	    jnz @@loop		   ; if '\0', then done, and equal
	    xor ax, ax
	    jmp @@exit
@@notequal:
	    jb @@less
	    xor ax, ax
	    inc ax
	    jmp @@exit
@@less:
	    xor ax, ax
	    dec ax
@@exit:
	    ret
@stricmp ENDP
END_CODE_SEGMENT <STRING>
END
