; skiptosp_sss
;   AAA=str
;   BBB=003
;   F=0
;   O=1
; str00301.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_skiptosp_sss:FN_CALL PTR
p_fn_skiptosp_sss P_FN_CALL skiptosp_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

; skiptosp_sss - skip to next white space
; char __near * fn_call skiptosp_sss(const char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss
;		pointer to the first white space character in the string
;		if no more white space characters in the string,
;		  then points to terminating '\0'
; NOTES:
;   see isspace for definition of white space character
BEGIN_CODE_SEGMENT <STRING>
skiptosp_sss PROC FN_CALL C USES ds si, p_str:NEAR16 PTR BYTE
    mov ax, ss
    mov ds, ax
    mov si, [p_str]
@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 09h
    jl @@luup
    cmp al, 0Dh
    jbe @@done
    cmp al, 20h
    jne @@luup
@@done:
    dec si
    mov ax, si
    ret
skiptosp_sss ENDP
END_CODE_SEGMENT <STRING>
END
