; strlen
;   AAA=str
;   BBB=001
;   F=0
;   O=0
; str00100.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strlen:FN_CALL PTR
p_fn_strlen P_FN_CALL strlen
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

; strlen() -- Get length of string
; size_t fn_call strlen(const char __near * const);
; GIVEN:
;   p_str	near pointer (source) offset from ds
; RETURNS: (int)
;   #		length of p_strg, excluding terminating null
BEGIN_CODE_SEGMENT <STRING>
strlen PROC FN_CALL C PUBLIC USES di es, p_str:NEAR16 PTR BYTE
	    mov ax, ds
	    mov es, ax

	    mov di, [p_str]	    ; es:di = string pointer
	    xor ax, ax
	    mov cx, ax
	    dec cx

	    repne scas BYTE PTR es:[di]
	    not cx
	    dec cx

	    mov ax, cx

	    ret
strlen ENDP
END_CODE_SEGMENT <STRING>
END
