#include <ctype.h>
#include <bios.h>

#include "fe.h"

boxes :: boxes ( size_t sz ) : size( sz ), point( 0 ) {

	comd = new fg_pbox_t [sz] ;
	comdscripts = new eventscript_t [sz] ;
	for ( size_t i = 0 ; i < sz ; i++ ) {
		comd[i] = new fg_box_t ;
		fg_make_box( comd[i], 0, 0, 0, 0 ) ;
		comdscripts[i] = NULL ;
	}
}

void boxes :: add_script ( fg_pbox_t c, eventscript_t s ) {

	if ( point < size ) {
		fg_box_cpy( comd[point], c ) ;
		comdscripts[point] = s ;
		point++ ;
	}
}

void boxes :: translate_script ( win *w, fg_coord_t x, fg_coord_t y ) {

	for ( size_t i = 0 ; i < point ; i++ )
		if ( fg_pt_inbox( comd[i], x, y ) )
			if ( comdscripts[i] )
				( w->*comdscripts[i] )() ;
}

keyboard :: keyboard ( size_t sz ) : size( sz ), point( 0 ) {

	comd = new char [sz] ;
	comdscripts = new eventscript_t [sz] ;
	for ( size_t i = 0 ; i < sz ; i++ ) {
		comd[i] = NULL ;
		comdscripts[i] = NULL ;
	}
}

void keyboard :: add_script ( char c, eventscript_t s ) {

	if ( point < size ) {
		comd[point] = c ;
		comdscripts[point] = s ;
		point++ ;
	}
}

void keyboard :: translate_script ( win *w, char c ) {

	for ( size_t i = 0 ; i < point ; i++ )
		if ( toupper( comd[i] ) == toupper( c ) )
			if ( comdscripts[i] )
				( w->*comdscripts[i] )() ;
}

void win :: focus_loop ( win *w ) {

	int status, last_status ;
	unsigned x, y ;

	while ( !quit ) {
		if ( bioskey( 1 ) ) {
			activate_key = ( char )( bioskey( 0 ) & 0xff ) ;
			kbd->translate_script( w, activate_key ) ;
		} else if ( ( status = msm_getstatus( &x, &y ) )
			!= last_status && status )
			box->translate_script(
				w, x, fg.displaybox[FG_Y2] + 1 - y
			) ;
			
		last_status = status ;
	}
	msm_hidecursor() ;
	clear() ;
	msm_showcursor() ;
	expose_parent() ;
}

menu :: menu (
	fg_coord_t x, fg_coord_t y, size_t w, size_t sz, win *p
) : win( x, y, fg.charbox[FG_X2] * ( w + 2 ),
	fg.charbox[FG_Y2] * sz, FG_LIGHT_WHITE, FG_CYAN, p, sz, sz ),
	size( sz ), point( 0 )
{
	i_names = new char * [sz] ;
}

void menu :: add_item ( char c, char *name, eventscript_t s ) {

	fg_box_t b ;

	if ( point < size ) {
		i_names[point] = name ;
		kbd->add_script( c, s ) ;
		fg_box_cpy( b, winbox ) ;
		b[FG_Y1] = y + fg.charbox[FG_Y2] * ( size - point - 1 ) ;
		b[FG_Y2] = b[FG_Y1] + fg.charbox[FG_Y2] ;
		box->add_script( b, s ) ;
		point++ ;
	}
}

void menu :: expose () {

	msm_hidecursor() ;
	cls() ;
	for ( size_t i = 0 ; i < point ; i++ )
		fg_puts( fgc, FG_MODE_SET, ~0, FG_ROT0,
			x + fg.charbox[FG_X2],
			y + ( size - i - 1 ) * fg.charbox[FG_Y2],
			i_names[i], winbox ) ;
	msm_showcursor() ;
}

void menu :: focus () { focus_loop( parent ) ; }

void menu :: destroy () { quit = 1 ; }

