
/* initexit.c  EOUE Project, 1997 by Michael Mangelsdorf */
/* THIS FILE IS PUBLIC DOMAIN.
   LEAVE THIS MESSAGE IN PLACE AS COURTESY TO THE AUTHOR */

#include <dos.h>

typedef unsigned char  byte;

unsigned eoue_dosmemseg; /* segment handle for internal font-memory */
extern byte *joyo_font, *kana_font; /* pointer to first character bitmap */

extern byte *scrollbuf; /* base of region holding 20 pixel high, 320 wide
			   lines temporarily when they are scrolled off
			   the screen. Up to five such lines.
			*/

extern unsigned scroll_ptr; /* points to one of the 5 lines in scrollbuf */


extern byte loadfnt (void);
extern byte dosalloc (unsigned paragraphs, unsigned *dosmemseg);
extern byte dosdealloc (unsigned dosmemseg);


/* input: flag indicating whether memory should be allocated
	  for the scroll-buffer.
*/
byte eoue_init (byte uses_scrolling) {
   if (uses_scrolling) {
      if (dosalloc(0x2000,&eoue_dosmemseg)) return 1;
      scrollbuf=MK_FP (eoue_dosmemseg+0x1000,0x1500+16);
      scroll_ptr=0;             /*the +16 is space for the DOS MCB header*/
   }
   else if (dosalloc(0x1150,&eoue_dosmemseg)) return 1;
   joyo_font=MK_FP (eoue_dosmemseg+0x0000,16);
   kana_font=MK_FP (eoue_dosmemseg+0x1000,16);
   if (!loadfnt()) return 2;    /*increasing segment value by 0x1000*/
   return 0;                    /*increments effective address by 64k*/
}


byte eoue_exit (void) {
   loadpal();  /* restore original palette from global pal[] */
   return dosdealloc(eoue_dosmemseg);
}


