

1        Introduction and warnings                                         1
1.1      Why use an extractor                                              1
1.1.1    Delivery of a library with invalid prototypes                     1
1.1.2    Implicit validation of prototypes in header file                  1
1.1.3    Patching calls right after a function revision                    1
1.2      Some compilers support prototype extraction                       2
1.2.1    A compiler may forgot prototypes                                  2
2        Limits of the shareware version                                   2
2.1      Automatic summary                                                 2
2.2      Permuted index                                                    3
2.3      Historic of system's functions                                    3
3        Specification and operation                                       3
3.1      General principal                                                 3
3.1.1    System, users and suppliers: A programmer's view                  3
3.1.2    function declaration (prototypes) vs function definition          4
3.1.2.1  Purpose of function prototypes                                    4
3.1.2.2  How to use prototypes                                             5
3.1.2.3  Which prototypes must be supplied in a header file                5
3.2      ANSI C and C++ supported                                          5
3.3      Added keyword to automate operation of the extractor              5
3.3.1    Added keyword definition                                          6
3.4      Command line options                                              6
3.4.1    @file : file holding command line options                         6
3.4.1.1  Example of command file search                                    6
3.4.1.2  @ without file argument                                           7
3.4.2    -a : Default access control for member function (C++)             7
3.4.3    -b : Update C++ header file from a .pm file                       8
3.4.3.1  Example of option -b use                                          8
3.4.3.2  Distribution control of class member prototypes in a file         8
3.4.4    -c : Output selection                                             9
3.4.4.1  Export : An extension to C                                        9
         How to add export to C language                                   9
         Why using export                                                  9
         _export verb                                                     10
3.4.4.2  Options -c and -f specified more than once                       10
3.4.4.3  Selection i of the -c option                                     10
3.4.4.4  Selection d of the -c option                                     10
3.4.4.5  Corrections to prototype before generation                       11
         Function without explicit return type                            11
         Typeless parameters                                              11
         Function without parameter                                       11
3.4.5    -C : Disallow nested comments                                    11
3.4.6    -D : Symbol definition                                           11
3.4.7    -e : Close an output file                                        12
3.4.7.1  protection against processing twice the same file                12
         Source files spread in two directories                           12
3.4.8    -f/+f : Specification of an output file                          12
3.4.8.1  Options -c and -f specified more than once                       13
3.4.9    -h : Prototype file to split into class related header           13
3.4.10   -i : Incremental mode                                            13
3.4.11   -I : Search path for include files                               13
3.4.12   -k : Renaming of keyword use by the extractor                    14
3.4.13   -l : Alternate name for -h option                                14
3.4.14   -m : Prepackaged options combinations                            14
3.4.14.1 Option -m1 : Optional output directory                           15
3.4.15   -o : Alternative name for option -m                              15
3.4.16   -p : Activate processing for following files                     15



                                                              1


3.4.16.1 Example of -p and -x uses                                        15
3.4.16.2 protection against processing twice the same file                15
3.4.17   -P : Preprocessor on                                             15
3.4.17.1 Processing of #define while full preprocessor is NOT active      16
3.4.17.2 Processing of #if and #ifdef without -P option                   16
3.4.18   Silent operation                                                 16
3.4.19   -t : source is read from the console (stdin)                     16
3.4.20   -v : List of source files processed                              16
3.4.21   -x : Do not process following source files                       16
3.4.21.1 Example of -p and -x uses                                        16
3.4.21.2 protection against processing twice the same file                17
3.4.22   Macros and special character                                     17
3.4.22.1 $ : current directory name                                       17
3.5      Invalid options combinations                                     17
3.6      Suggested uses of the extractor                                  17
3.6.1    warning about this section                                       18
3.6.2    The directory is the basic organizationnal unit                  18
3.6.3    Names for header file                                            18
3.6.4    File locally generated                                           18
3.6.5    Files exported to users                                          18
3.6.5.1  Export : An extension to C                                       19
3.6.6    One header file, different views for users and members           19


1        Introduction and warnings                                   

    The prototype extractor automates part of an ANSI C and C++ 
    2.0 programmer's work. It also supports K&R functions 
    declaration syntax.

    This utility is available for both MSDOS(PCDOS) (3.0 and 
    up), SCO XENIX version 2.3 (UNIX systme V.3.2) et SUN SPARC 
    (Sunos).

    This manual applies to all three systems. However, the / 
    field separator has been used for file specification. The 
    MSDOS version used the \ character instead.

1.1      Why use an extractor                                        

    Use of an automatic tool to generate prototypes is 
    optionnal. Prototypes may be written manually into header 
    files. Program without proper prototypes will compile under 
    ANSI C mostly for compatibility with K&R convention. Under 
    C++, prototypes are not an option.

    In this section, we will not show the importance of 
    prototypes. Instead, we will focus on the importance of an 
    automatic extraction tool.

1.1.1    Delivery of a library with invalid prototypes               

    During the maintenance of a software sub-system, functions 
    are added, deleted and modified. Reliability of prototypes 
    is essential at delivery time. Often, prototype related 
    problems will be detected by a different team. The updated 
    package will be the last suspect. Programmer will really 
    wonder: the project compiles ok but crashes abruptly.

    In C this kind of problem may take days to locate. In C++, 
    the problem will be catch at link time. In all case, it 
    means waste of time, and disatisfaction.

1.1.2    Implicit validation of prototypes in header file            

    There is simple way of checking the correctness of 
    prototypes in a header. You simply include the header in 
    each source that declare those function. Recompiling those 
    sources will test that the prototypes correspond to the 
    declaration.

    This method does not detect missing prototypes (some 
    functions are simply never called from the package itself) 
    nor prototypes of obsolete functions. Using C++, this method 
    is simply useless. Several C++ functions may share the same 
    name: The compiler sees an invalid prototype as an overload 
    function.

1.1.3    Patching calls right after a function revision              





                                                              1


    One way of avoiding problems when we modified the 
    declaration of a function is to correct all the calls to 
    this function as soon as possible. Most programmers will 
    locate the calls before changing the function just to 
    evaluate the cost of the modification. They will GREP around 
    using the function name as a key.

    Doing so is ok, but not totally safe. Client function may be 
    located on another computer, or simply in a project unknown 
    to the programmer.

    Locating calls to a class member C++ function is almost 
    impossible using GREP. The programmers must use cross 
    reference and other gadgets.

    The only proof will occur when client project will be 
    recompiled. This may append several days or several months 
    after the revision. Accurate prototypes are the key to safe 
    rebuilds.

1.2      Some compilers support prototype extraction                 

    Some compilers have an option to extract prototypes while 
    compiling. Such an option suffers high performance drawback 
    and is used only when nothing else is available.

    Prototypes must be extracted prior to compilation; valid 
    prototypes are necessary for the compilation to succeed. If 
    a compiler is used to extract prototypes, two compilation 
    passes will be necessary, one to get the prototypes, and one 
    to do compilation.

1.2.1    A compiler may forgot prototypes                            

    If one uses a compiler to extract prototypes, problems may 
    arise. The compiler may very well stop the compilation 
    process because too many errors where met. Functions not 
    compiled won't get a prototype. Several errors might be 
    caused by the absence of those prototypes.

2        Limits of the shareware version                             

    This manual presents every options of the extractor.

    Some options are not available for the shareware version. 
    The license explains how to get a complete version.

    The user who registers will receive an up to date version 
    with all features and few companion utilities. These are 
    documented here. The list may change without notice.

2.1      Automatic summary                                           

    One utility builds a summary: For each function, one comment 
    line is extracted from the source. The line is chosen using 
    a simple convention.




                                                              2


    The output file has the following layout:

      function_a : short description of function_a
      ...
      function_z : short description of function_z

    The first comment line of the comment block preceding the 
    function definition is selected.

2.2      Permuted index                                              

    Using the summary, one utility creats a permuted index based 
    on meaningful words of the short description. From the 
    following example summary:

      button_creation: creation and initialization of a button
      button_erase: erases and frees a button from memory

    Each useful words from the description will be used as a 
    key. This allows location of a function using any keywords 
    (creation, initialization, button, erases, frees, memory).

2.3      Historic of system's functions                              

    One file is maintained from the prototype & documentation 
    file produced by the extractor.

    It is a text file. It holds a complete prototype of each 
    function, its surrounding comments and a creation or 
    revision date. Each time the system is revised, this file is 
    updated. Information is appended to it, telling which 
    function has changed (ASCII comparison of the commented 
    declaration) , which one is new, and which one has been 
    removed.

    A programmer may easily follow the evolution of a system 
    (what's new, what's changed, ...).

3        Specification and operation                                 

    Description of the extractor's features. This manual is an 
    operation guide, but suggest ways to apply the product.

3.1      General principal                                           

    The extractor may be used for small projects made of few 
    files up too huge project: Several hundredth files split 
    into several directories.

3.1.1    System, users and suppliers: A programmer's view            

    Within this manual, the words 'system', 'user', and 
    'supplier' will be used.





                                                              3


    A system (often called package or library) is a collection 
    of related functions providing a mean to perform some 
    specific tasks. An example of such system are the str____() 
    functions delivered with most C compiler (strcmp, strlen, 
    strcpy, strchr, ...). The system is a supplier and the 
    sources from which it is builted are members.

    One who is calling those functions from his programs or 
    functions is a user. These functions are users of the 
    system. Within this manual, a user is a function that makes 
    use of a system.

3.1.2    function declaration (prototypes) vs function definition    

    The major difference between ANSI C compiler an non ANSI 
    compiler is the function prototyping. This provides a way to 
    write the formal interface of a function without supplying 
    the complete source.

    Given the definition of function max():

      int max(int a, int b)
      {
          if (a<b) return (b);
          return (a);
      }

    Here is the declaration or prototype:

      int max (int a, int b);

3.1.2.1  Purpose of function prototypes                              

    Function prototypes supply needed information to compilers 
    allowing complete type checking of the uses of the function 
    (call). It is then possible to implement a function in one 
    source file and to use it in an other file with full 
    confidence.

    The compiler, having access to the prototype of a function, 
    can validate each calls to the function. It checks the 
    argument's count and type of each one, providing conversion 
    when needed and possible. In the following example, each 
    call to the max function will be flag by an ANSI compiler. 
    However, for this to happen, the prototype of max must be 
    supply before the calls.

      int max(int a, int b);

          ...
          char *pt = max ("xyz","zzz");   /* Invalid arguments */
          int m = max (1,2,3);            /* Argument count */




                                                              4


3.1.2.2  How to use prototypes                                       

    Generally, we put function prototypes in a header file 
    (*.h). For each system, we provided a header file supplying 
    data definitions, macros, and function prototypes. Several 
    header files are supplied with the compiler you are using. 
    Most header files hold function prototypes.

    User functions must then include those headers in order to 
    compile safely.

    example:

      #include <string.h>

      ...
      char *pt = strlen("....."); /* prototype of strlen() is provided */
                                  /* in string.h */

3.1.2.3  Which prototypes must be supplied in a header file          

    The header file supplied with a system does not held the 
    prototypes of every functions in that system.

    "Static" functions are not provided, since they can't be 
    called from outside the source where they appear. Some non 
    "static" functions are not provided because their use is not 
    recommended for user functions. These functions are internal 
    to a system.

    Header files are built for specific audiences. They only 
    provide useful prototypes. From that perspective, one may 
    choose to provide two header files for a given system, one 
    used by member functions and one used by user functions.

    The extractor provides a mean to create headers selectively.

3.2      ANSI C and C++ supported                                    

    The extractor processes C and C++ syntax. No special switche 
    must be supplied. Some switches allow extraction of special 
    prototypes such as member functions.

3.3      Added keyword to automate operation of the extractor        

    C++ and C do not allow fully automatic prototype extraction. 
    They are missing keywords for access control. The extractor 
    need specific information to distribute properly prototypes 
    in header files.

    The extractor supports seven special keywords.







                                                              5


      export      C et C++
      _export     C et C++
      PRIVATE     C++
      PUBLIC      C++
      PROTECTED   C++
      STATIC      C++
      VIRTUAL     C++

3.3.1    Added keyword definition                                    

    Most C and C++ compilers do not support keyword export, 
    _export, PRIVATE, PROTECTED, PUBLIC and VIRTUAL. A null 
    definition must be provided to the preprocessor. This can be 
    done using either a preprocessor or compiler command line 
    option (generally -d) or simply putting these six lines in a 
    header file.

      #define export
      #define _export
      #define PUBLIC
      #define PRIVATE
      #define PROTECTED
      #define VIRTUAL

3.4      Command line options                                        

    This section describes the options that may be specified on 
    the command line. An option is specified by a '-' followed 
    by a letter, optionally followed by a character string.

      -x
      -ceoi
      -ffile.nar

3.4.1    @file : file holding command line options                   

    If a command line parameter begins with @, it will be taken 
    as a file name. This file holds other parameters.

    The file name may specify a directory or not. If the file 
    name holds a directory path, this path will be used and its 
    ancestors to locate the file.

    If the file name holds no directory path, the current 
    directory will be searched and its ancestors. If the file is 
    not located this way, the search path (environment variable 
    PATH) is used.

    This way of locating the file allows the programmer to write 
    one command file which will be usable for a set of projects. 
    It is then easy to provide a command file (with same name) 
    locally for a project which needs special options.

3.4.1.1  Example of command file search                              



                                                              6


    Given the directories:

      /usr/prj1/liba
      /usr/prj1/libb
      /usr/prj1/libb/libb0
      /usr/prj1/libb/libb1
      /usr/prj1/libc
      /usr/prj2/liba
      /usr/prj2/libb
      /usr/prj2/libc

    If we create these command files:

      /usr/proto.cfg
      /usr/prj1/libb/proto.cfg
      /usr/prj2/libc/proto.cfg

    The following list tells which file will be read if the 
    command "proto @proto.cfg" is applied to each directory.

      /usr/prj1/liba          /usr/proto.cfg
      /usr/prj1/libb/libb0    /usr/prj1/libb/proto.cfg
      /usr/prj1/libb/libb1    /usr/prj1/libb/proto.cfg
      /usr/prj1/libc          /usr/proto.cfg
      /usr/prj2/liba          /usr/proto.cfg
      /usr/prj2/libb          /usr/proto.cfg
      /usr/prj2/libc          /usr/prj2/libc/proto.cfg
      /lib/prjx               The environment variable PATH
                              will be searched to locate proto.cfg
                              the same way executable files are located.

3.4.1.2  @ without file argument                                     

    If @ appears alone, the file 'proto.cfg' is implied. It will 
    be looked for in the current directory. If not found, the .. 
    directory will be searched, up to the root of the disk. If 
    still not found, the PATH environment variable will be used.

    When proper proto.cfg files are created and dispatched to 
    strategic locations within a file system, the command "proto 
    @" is enough to extract prototypes of any project.

3.4.2    -a : Default access control for member function (C++)       

    Member functions without access control specifier are 
    normally set "private". Option -a records a different 
    default.

      -a0 : private
      -a1 : protected
      -a2 : public





                                                              7


    Added keywords PRIVATE, PROTECTED, and PUBLIC specify access 
    control.

3.4.3    -b : Update C++ header file from a .pm file                 

    Normally, proto output all class member function prototypes 
    in a single file (see option -m0+, -m1+ and -c+). This file 
    generally has the extension ".pm". From this file, proto 
    distributes prototypes of class member functions in the 
    header files that hold class definition. Option -b triggers 
    this distribution.

    The syntax goes like this:

      -bheader_file+pm_file=destination_file
      -bheader_file+pm_file
      -bheader_file
      -b

    If destination_file is omitted, header_file is used. If 
    pm_file is omitted X.pm is used (where X is the name of the 
    current directory). Option -b without argument is equivalent 
    to -bX.hpp+X.pm or -bX.h+X.pm where X is the name of the 
    current directory. X.h is used when X.hpp does not exist.

    Option -b may be used several times (to update different 
    headers) on the same command line. Its action will be 
    triggered only after the last prototype has been extracted.

3.4.3.1  Example of option -b use                                    

    Given the command,

      proto -c+ -fx.pm *.c -bfile1.h+x.pm -bfile2.h+x.pm

    First, file x.h will be produced. It will contain all 
    prototypes of class member functions. Then file file1.h and 
    file2.h will be update. Prototypes will be distributed in 
    the proper class declarations.

3.4.3.2  Distribution control of class member prototypes in a file   

    Prototypes of class member functions must be distributed 
    within the class definition. The extractor uses a simple way 
    to locate the place those prototypes must be written.

    It simply locates paires of comments of this form:

      /*~PROTOBEG~ CLASS_NAME */
      /*~PROTOEND~ */







                                                              8


    Each comments must be alone in a source line. Everything 
    that lies between those two comments has been placed by the 
    extractor. Programmers should avoid writing between those 
    comments, since proto replaces everything between, each time 
    the file is update.

3.4.4    -c : Output selection                                       

    PROTO can extract several things from C source files. Here 
    is the list of what can be selected with the key letter used 
    to specify it.

      e : Selection of export functions (extension to C).
      o : Selection of ordinary functions.
      p : Selection of "private" class member functions (C++).
      p : Selection of "protected" class member functions (C++).
      s : Selection of static functions.
      u : Selection of "public" class member functions (C++).

      + : Selection of class member functions (C++).
      d : Documentation (comments) surrounding the function definition.
      i : Cross reference function vs source.

    The command "proto -cod *.c" will extract the prototypes and 
    comments of every C source files of the current directory.

3.4.4.1  Export : An extension to C                                  

    The export verb is an extension to C language. We have never 
    seen a compiler implementing such verb. This verb is 
    currently applied to function definitions, but may very well 
    be applied to type definitions, constant definitions, 
    variables, etc...

    This verb is a modifier like the static verb. This one 
    limits the scope of an object to the source where it 
    appears. Export specifies that the scope of the object 
    crosses the system boundaries. An export function is an 
    official service provided to users. An ordinary function is 
    local to the system and must not be used by user's 
    functions.

3.4.4.1.1How to add export to C language                             

    Using the preprocessor, it is possible to add a dummy 
    definition of the export verb. Just put the directive 
    "#define export" in a header file, and include it in sources 
    that use the verb.

    It is also possible to define the verb on the command line 
    using the -d option supported by most compilers.

3.4.4.1.2Why using export                                            





                                                              9


    Export allows easy classification of the functions in a 
    system. This helps users trying to locate a service. 
    Generally the list of export functions is less than half the 
    list of all system's functions. This helps as much for 
    maintenance.

3.4.4.1.3_export verb                                                

    The keyword _export is becoming popular while not standard, 
    in several C compilers. Its use is similar to the export 
    keyword already supported by the extractor. The two keywords 
    are equivalent.

3.4.4.2  Options -c and -f specified more than once                  

    Options -c and -f may be used more than once in a single 
    command.

    Option -c sets an output selection which will be used by 
    each following -f options, until a new -c option is met.

    The command "proto -co -fordin.h -cs -fstatic.h -cod 
    -finfo.h *.c" produces three output files, each with a 
    different content. This feature generally saves time in 
    processing.

3.4.4.3  Selection i of the -c option                                

    The selection 'i' allows the output of a cross reference 
    function vs source. The following -f option will produce an 
    index allowing a quick location of a function definition 
    within a multiple sources project.

    The output file is an ASCII text file with a simple format:

      line_length!function_name!source_file_name

    The character '!' acts as delimiter. The line_length field 
    gives the length of the line in bytes. This length is 
    encoded in one single byte. Since the file is an ASCII text, 
    the value 32 is added to the length yielding a printable 
    character.

    This format has been chosen in order to allow processing of 
    that file by simple programming language often found in 
    programmer's editor.

3.4.4.4  Selection d of the -c option                                

    The d selection orders the extraction of the function 
    declaration and all surrounding comments.

    All contiguous comments immediatly preceding the function 
    declaration and each comments met before the first brace '{' 
    of the function body are grabbed and output along with the 
    prototype.



                                                             10


    The output file is an ASCII text file easily readable. It 
    can be used as a preview of a system.

3.4.4.5  Corrections to prototype before generation                  

    Some information may be omitted from a function declaration. 
    The extractor automaticly adds what is missing.

3.4.4.5.1Function without explicit return type                       

    If a function is declared without type, the extractor adds 
    'int' to the prototype. The following declaration:

      max(int a, int b){ ... }

    produces the following prototype:

      int max(int a, int b);

3.4.4.5.2Typeless parameters                                         

    If a parameter appears without typing, the keyword 'int' is 
    inserted.

    Given the following function:

      int max (a,b){ ... }

    The following prototype will be produced:

      int max (int a, int b);

3.4.4.5.3Function without parameter                                  

    The keyword 'void' will be automaticly inserted in the 
    prototype of a function without parameter. The following 
    declaration:

      int fct (){ ... }

    produces:

      int fct (void);

3.4.5    -C : Disallow nested comments                               

    Proto allows nested comments. Option -C kills this feature.

3.4.6    -D : Symbol definition                                      





                                                             11


    The option -D allows the definition of preprocessor symbols 
    on the command line.

    The option "-Dsymxxx" is equivalent to "#define symxxx" 
    within a source.

    The option "-Dsymxxx=yyy" is equivalent to "#define symxxx 
    yyy".

3.4.7    -e : Close an output file                                   

    Option -e is used after option -f (+f) and terminates output 
    to the file. This allows distribution of prototypes in 
    different files, in a single processing.

    Example: proto -ffile1 a*.c -efile1 -ffile2 *.c

    File1 will hold only the prototypes of functions from 
    sources "a*.c". File2 will contain all the other. Without 
    option -e, file2 would have been a subset of file1.

3.4.7.1  protection against processing twice the same file           

    The extractor won't process a file twice in a single work 
    session. This allows processing a list of files with one set 
    of options and the remaining files with an other set.

    The following command process the file xyz.c with a 
    different set of options than the other files in the 
    directory.

    proto -option ... -option xyz.c -option ... -option *.c

    Even if the list *.c includes xyz.c, this one won't be 
    processed twice.

3.4.7.1.1Source files spread in two directories                      

    Some large projects use so much disk space that a special 
    handling is needed. One way is to put sources in one 
    reference directory and let programmers import only the 
    sources they modify into a personal directory. Some text 
    editors handle this transparently by reading from the 
    reference directory and saving to the personal directory.

    Given the /usr/src/x directory holding sources for project 
    X. Given the programmer 'prog' who imports sources gradually 
    as they are revised to directory /usr/prog/x.

    The command "proto *.c /usr/src/x/*.c" applied in 
    /usr/prog/x directory will extract the prototypes of project 
    X. The protection against double processing of a source is 
    applied on the file's name, not on the file's path.

3.4.8    -f/+f : Specification of an output file                     





                                                             12


    The option -f may appear several times on the command line. 
    Proto can produce several files in a single session.

    The option must be followed by an output file name. The 
    option -f creats the file. The option +f appends to it.

    The format of the output depends on the last occurrence of 
    the -c option.

    ex : "proto -cos -ffichier.p *.c" produces "fichier.p" with 
    the prototypes of ordinary and static functions of the 
    current directory.

3.4.8.1  Options -c and -f specified more than once                  

    Options -c and -f may be used more than once in a single 
    command.

    Option -c sets an output selection which will be used by 
    each following -f options, until a new -c option is met.

    The command "proto -co -fordin.h -cs -fstatic.h -cod 
    -finfo.h *.c" produces three output files, each with a 
    different content. This feature generally saves time in 
    processing.

3.4.9    -h : Prototype file to split into class related header      

    Option -h reads a header file holding prototypes of member 
    function (class member) and produces one header per classes. 
    Proto builds the name of each header with the name of the 
    class (truncated) and the extension ".pp".

    Those headers may be sub-included in the header that holds 
    class definitions.

    -h must be followed without space by the name of the header 
    to split. -h without argument specifies to split the file 
    with the current directory name and the extension ".pm".

    The process will start after the last prototypes has been 
    extracted.

    Option -h may be used several times on the command line.

3.4.10   -i : Incremental mode                                       

    When -i is specified, proto reads the output files if they 
    exist. If read is successful, only the source files that 
    have changed are processed. All output files produced by 
    proto hold the revision date of the original sources.

    This cuts the processing time quite a bit.

3.4.11   -I : Search path for include files                          





                                                             13


    The option -I specifies the list of directories to search in 
    order to locate a header file (#include directive).

    This option may appear several times on the command line. 
    Several directories may be specified in a single shot, each 
    separated by a ':'.

    ex: -I/usr/include:/include <==> -I/usr/include -I/include

3.4.12   -k : Renaming of keyword use by the extractor               

    Some keywords known to the extractor are not processed by 
    all C and C++ compiler. The programmer must supplied null 
    definition to the preprocessor for the compiler to "pass 
    over it".

    These new keywords might generate conflict with existing 
    programms. Some variable or type may share the same name. It 
    is possible to rename those keywords or to disable them.

    Option -kxxx=yyy redefine keyword xxx as yyy. Option -kxxx 
    just disable the keyword. Option -k may be used several 
    times on the command line.

    Here an example where the keyword export conflict with a 
    typedef. Since the typedef is used all around the project, 
    the keyword export has to be rename to something else, say 
    EXPORT. Option -lexport=EXPORT will disable export as a 
    keyword, and EXPORT will inherit the meaning normally 
    associated to export. So a declaration like this will work.

    EXPORT export *fct (void);

3.4.13   -l : Alternate name for -h option                           

    Option -h may produce several header files. These files are 
    named after the class name they belong to. Limitation of the 
    file system forces option -h to truncated class name. This 
    yields to conflicting names. Option -l specifies a file name 
    to be used instead of the class name.

    Ex: proto -m0+ -lCLASS_SPEC1=class1.pp 
    -lCLASS_SPEC2=class2.pp *.c -h

    Prototypes of member functions of class CLASS_SPEC1 will be 
    output to file class1.pp and those of CLASS_SPEC2, to file 
    class2.pp.

3.4.14   -m : Prepackaged options combinations                       

    -m0 : Setup for single directory projects

      "proto -m0 *.c" applied to directory X is equivalent to
      "proto -ceo -fX.p -ceod -fX.nap -ceoi -fX.nar *.c"

    -m1 : Setup for multiple directories projects



                                                             14


      "proto -m1 *.c" applied to directory X is equivalent to
      "proto -ceo -fX.p -ce  -f../include/X.p
          -ceod -fX.nap -ced -f../doc/X.nap
          -ceoi -fX.nar -cei -f../doc/X.nar *.c"

3.4.14.1 Option -m1 : Optional output directory                      

    Directories ../include and ../doc are used as default by 
    option -m1.

    If ../include does not exist, directory ../h is used instead 
    One of these two directories must exist for -m1 to succeed.

3.4.15   -o : Alternative name for option -m                         

    Option -m builds its output files from the current directory 
    name. Option -o let you specify another base name.

3.4.16   -p : Activate processing for following files                

    This option is used after option -x. It reactivates 
    processing for each following source files on the command 
    line.

    This is the default.

3.4.16.1 Example of -p and -x uses                                   

    Some C files hold no useful prototypes. Some C files are 
    produced by screen generators, grammar parsers, etc. These 
    files are made up of large array declarations. It is 
    sometime useful to skip these files while extracting the 
    prototypes. This saves time.

    Given the two files screen1.c and screen2.c. The command 
    "proto -x screen1.c screen2.c -p *.c" processes each source 
    files in the current directory except these two.

3.4.16.2 protection against processing twice the same file           

    The extractor won't process a file twice in a single work 
    session. This allows processing a list of files with one set 
    of options and the remaining files with an other set.

    The following command process the file xyz.c with a 
    different set of options than the other files in the 
    directory.

    proto -option ... -option xyz.c -option ... -option *.c

    Even if the list *.c includes xyz.c, this one won't be 
    processed twice.

3.4.17   -P : Preprocessor on                                        





                                                             15


    As a default, proto does not do macro replacement, nor 
    process #include directives. This allows quick extraction of 
    prototypes.

    Generally, ignoring macro replacement does not interfere and 
    proto produces correct results. There are few exceptions 
    where full preprocessing is essential for correct analysis 
    of function definitions.

    Option -P triggers a full ANSI C preprocessor (built-in). 
    However, options -I and -d must be specified properly.

3.4.17.1 Processing of #define while full preprocessor is NOT active 

    #define directive are processed. This allows correct 
    evaluation of #ifdef directives.

    #undef directives are also processed.

3.4.17.2 Processing of #if and #ifdef without -P option              

    When full preprocessing is off, processing of #if et #ifdef 
    may yield to incorrect results. Since header files are not 
    processed, replacement text of macros is unknown. The option 
    -d allows definition of macros on the command line, 
    partially solving the problem.

3.4.18   Silent operation                                            

    Normally proto outputs on screen the list of every output 
    files. Option -s kills that feature.

3.4.19   -t : source is read from the console (stdin)                

    Option -t tells proto to read one input file from the 
    keyboard (stdin). This allows pipes and easy testing.

3.4.20   -v : List of source files processed                         

    Option -v displays every files processed.

3.4.21   -x : Do not process following source files                  

    Each files specified after option -x on command line won't 
    be processed. Option -p puts proto back in normal state.

    The command "proto -x xxxx.c -p *.c" extracts prototypes of 
    all C source files except xxxx.c.

3.4.21.1 Example of -p and -x uses                                   

    Some C files hold no useful prototypes. Some C files are 
    produced by screen generators, grammar parsers, etc. These 
    files are made up of large array declarations. It is 
    sometime useful to skip these files while extracting the 
    prototypes. This saves time.




                                                             16


    Given the two files screen1.c and screen2.c. The command 
    "proto -x screen1.c screen2.c -p *.c" processes each source 
    files in the current directory except these two.

3.4.21.2 protection against processing twice the same file           

    The extractor won't process a file twice in a single work 
    session. This allows processing a list of files with one set 
    of options and the remaining files with an other set.

    The following command process the file xyz.c with a 
    different set of options than the other files in the 
    directory.

    proto -option ... -option xyz.c -option ... -option *.c

    Even if the list *.c includes xyz.c, this one won't be 
    processed twice.

3.4.22   Macros and special character                                

    Some character strings have special meaning on command line. 
    This allows building commands generally usable.

3.4.22.1 $ : current directory name                                  

    The current directory name is often used as the base name of 
    output files

    If one wishes to build a general script (batch file) to 
    extract prototypes, there must be a way to specify the 
    current directory name.

    The $ has been provided with a special meaning. It is 
    replaced by the name of the current directory.

    "proto -co -f$.p -cod -f$.nap -coi -f$.nar *.c" is 
    equivalent to "proto -m0 *.c".

3.5      Invalid options combinations                                

    Several options are available. Several combinations are 
    meaningless.

    Some combinations are invalid and detected. An error is 
    written to the console. However some valid commands may 
    generate useless results.

3.6      Suggested uses of the extractor                             

    Using the extractor is fairly simple. Just apply proto on 
    few sources and it creats header files.

    We have tried to provide the extractor with enough 
    flexibility to adjust for most methodologies.





                                                             17


    Here we will suggest a functional approach usable for small 
    projects (a single directory with few source files) and 
    larger ones.

3.6.1    warning about this section                                  

    The following suggestions are not absolute solutions. We 
    have found these acceptable and useful. These come from 
    experience on different kind of projects.

    Other suggestions are welcome.

3.6.2    The directory is the basic organizationnal unit             

    Systems are built from several source files (generally 10 to 
    30). Complex systems may be built from several directories. 
    Such systems are made of sub systems.

    From a user standpoint, complex or simple systems originate 
    from single directories. Complexity must be hidden to users. 
    Directories may hold sub-directories, but that does not 
    matter to users.

    The directory is then the basis of a naming convention: For 
    each system of a given name, there is a directory, a header 
    file and optionally an object library with the same name.

3.6.3    Names for header file                                       

    For the sake of simplicity, header files available to users 
    have the name of the directory holding the project.

    So for a project X located in a directory X, every 'public' 
    header files will be named X.*.

3.6.4    File locally generated                                      

    Option -m0 creates three files in the project directory. For 
    a directory X, files X.p, X.nap et X.nar are produced. 
    Option -m1 also creates these files and three others.

    X.p holds the prototypes. This file is sub-included by X.h, 
    the main header file of project X. The command '#include 
    "X.p"' is located at the end of X.h. Generally, prototypes 
    are placed directly into the main header file. This file 
    holds definitions and declarations. Since the extractor 
    can't write X.h without losing its content, an other file 
    must be created: X.p.

3.6.5    Files exported to users                                     

    Option -m1 exports three files as well as three local files. 
    For a project X, a file X.p will written in the ../include 
    directory (or ../h) and files X.nap and X.nar will be 
    written in the ../doc directory. These files use the same 
    names as the local ones. These are restricted version of the 
    local files. They hold less functions.



                                                             18


    The export verb (extension to C) placed before a function 
    definition allows proto to classify functions available to 
    users.

3.6.5.1  Export : An extension to C                                  

    The export verb is an extension to C language. We have never 
    seen a compiler implementing such verb. This verb is 
    currently applied to function definitions, but may very well 
    be applied to type definitions, constant definitions, 
    variables, etc...

    This verb is a modifier like the static verb. This one 
    limits the scope of an object to the source where it 
    appears. Export specifies that the scope of the object 
    crosses the system boundaries. An export function is an 
    official service provided to users. An ordinary function is 
    local to the system and must not be used by user's 
    functions.

3.6.6    One header file, different views for users and members      

    For X directory, it exists one X.h header. Every sources of 
    the directory include that file. X.h includes X.p. Every 
    source has access to all prototypes of the system X.

    If X is a sub-system, X.h or a portion of it is exported to 
    the ../include. It becomes available to users. When a user 
    includes that file, this one includes ../include/X.p.

    Thus, users have access to prototypes of every export 
    functions of system X. Also the file ../doc/X.nap and 
    ../doc/X.nai may be read to get more information on 
    available functions.

    X.h conceptually unique, offers a different view to users 
    and members of the system X.
