/*  PROG8OUT.C -- Produces the same result as PROGRAM6.C, by reading data from
    a data file created with the program PROG8IN.C.  */

#include <stdio.h>
#include <stdlib.h>

#define MAX_ROWS 99
#define MAX_NAME 100

/*  Define the heading information for the output file.  */

#define HEAD1 "John Smith"
#define HEAD2 "CIS 176, Section 02A"
#define HEAD3 "Program 8"

/*  Create a structure template for the structure with the tag "record".  */

struct record {
		char name[30];
		int cover,
		    code;
	      };

FILE *fptr;
FILE *out;

main()
{
	struct record inputt;
	char names[MAX_ROWS][MAX_NAME];   /*  Employee Names.  */
	char coverage[MAX_ROWS][20];      /*  Coverage types.  */
	char plan[MAX_ROWS][20];          /*  Health Plan names.  */
	float costs[MAX_ROWS][2];         /*  Employee and Employer costs.  */
	int count, cx;                        /*  Counter variable.  */
	float empe_total, empr_total;     /*  Variables to hold total costs.  */

	/*  Array of costs for the different Health Plans and types of
	    coverage.  */

	float hp_costs[3][4] = {{25.00,30.00,40.00,45.00},
				{30.00,40.00,55.00,60.00},
				{20.00,25.00,40.00,70.00}};

	count = 0;
	empe_total = 0;
	empr_total = 0;

	/*  Open data file.  */

	if((fptr=fopen("indata","rb")) == NULL)
	{
		printf("\nCannot open file for storing data.");
		exit(1);
	}

	/*  Read in employee information from data file.  */

	while(fread(&inputt,sizeof(inputt),1,fptr)==1)
	{
		printf("\nName:  %s", inputt.name);
		strcpy(names[count],inputt.name);

		printf("\nCoverage Code:  %d", inputt.cover);
		get_cover(inputt.cover, coverage, count);

		printf("\nHealth Plan Code:  %d\n", inputt.code);
		get_plan(inputt.code, plan, count);

		calc_costs(inputt.cover, inputt.code, costs, hp_costs);

		count++;
	}

	/*  Close data file.  */

	fclose(fptr);

	/*  Calculate the total cost, for the employer and employees, of
	    the health plans.  */

	total_costs(costs, &empe_total, &empr_total, count);

	/*  Write data to output file.  */

	print_data(names, coverage, plan, costs, empe_total, empr_total,
	     count, out);

}

/*  Get the type of health care coverage corresponding to the employee's
    health care code.  */

get_cover(cover, array, count)
int cover, count;
char array[][20];
{
	/*  Initialize/declare an array containing the names of each type
	    of coverage.  */

	int counter = count;
	char typcvr[4][18] = {{"Employee only"},
			      {"Family coverage"},
			      {"Reduced benefits"},
			      {"** Error **"}};
	int temp;

	if(cover >2)
	{
		/*  If the code for the type of coverage is greater
		than 2, assign "** Error **" to that code.  */

		temp = 3;
		strcy(array[counter],typcvr[temp]);
	}
	else
		strcy(array[counter],typcvr[cover]);

}

/*  Get the name of the Health plan, given the Health Plan Code.  */

get_plan(code, array, count)
int code, count;
char array[][20];
{
	/*  Using a switch statement, determine the health plan name
	    for the code just entered.  If the code entered is not
	    a valid code, assign "** Error **" to that code.  */

	switch(code)
	{
		case 0:
			strcy(array[count],"Standard");
			break;
		case 1:
			strcy(array[count],"HMO");
			break;
		case 2:
			strcy(array[count],"Premium");
			break;
		case 3:
			strcy(array[count],"ACME");
			break;
		default:
			strcy(array[count],"** Error **");
			break;
	}
}

/*  Calculate the health care costs for the employee and the employer.  */

calc_costs(cover, code, array3, array4)
int cover, code;
float array3[][2], array4[][4];
{
	float tempcost[MAX_ROWS];
	int count;

	/*  If either the coverage code or health plan code is invalid,
	    set the health care cost to 0; otherwise, determine the cost
	    from the table in main().  */

	if(cover > 2 || code > 3)
		tempcost[count] = 0.00;
	else
		tempcost[count] = array4[cover][code];

	/*  For the cost of the health plan, determine the amount paid by the
	    employer and the employee.  (The employer pays 95% of the total
	    cost and the employee pays the remaining 5% of the total cost.)  */

	array3[count][1] = ((tempcost[count]) * (0.05));

	array3[count][2] = ((tempcost[count]) * (0.95));

}

/*  Calculate the total costs paid by the employees and the employer.  */

total_costs(array, total1, total2, size)
float array[][2], *total1, *total2;
int size;
{
	int counter;

	for(counter = 0; counter < size; counter++)
		*total1 += array[counter][1];

	for(counter = 0; counter < size; counter++)
		*total2 += array[counter][2];
}

/*  Print the health plan data to a file.  Each entry will consist of the
    employee's name, the type of health insurance coverage, the name of the
    health plan, the amount paid by the employee, and the amount paid by the
    employer.  At the end of the file, there will be totals given for the
    amounts paid by the employees and the employer.  */

print_data(array1, array2, array3, array4, total1, total2, size, out)
char array1[][MAX_NAME+1], array2[][20], array3[][20];
float array4[][2], total1, total2;
int size;
FILE *out;
{
	int counter;

	/*  Open the file to contain the results.  */

	out = fopen("d:output8", "w");

	/*  Print the header and column headings to the output file.  */

	header(out);
	heading(out);

	for(counter = 0; counter < size; counter++)
	{
		printf("\n%s", array1[counter]);
		fprintf(out, "\n %-15s   %-19s   %-12s  $%6.2f     $%6.2f",
		     array1[counter],array2[counter], array3[counter],array4[counter][1],array4[counter][2]);
	}
	/*  Print the totals, seperated by a line of hyphens, for the employer
	    and the employees.  */

	fprintf(out, "\n%54c----------  ----------", ' ');
	fprintf(out, "\n Totals:%46c$%7.2f    $%7.2f\n\n", ' ', total1, total2);

	/*  Close the output file.  */

	fclose(out);
}

/*  Print the headings for the columns in the output file.  */

heading(out)
FILE *out;
{
	fprintf(out, "\n%3cEmployee%30cHealth%9cEmployee%3cEmployer", ' ',
	      ' ', ' ', ' ');
	fprintf(out, "\n%4cName%11cType of Coverage%7cPlan%12cCost%6cCost\n",
	      ' ', ' ', ' ', ' ', ' ');

}

/*  Copy the contents of one string (original) over the contents of another
    string (copy).  */

strcy(copy, original)
char *copy, *original;
{
	while(*copy++ = *original++);
}

/*  Print the header information to the output file.  */

header(out)
FILE *out;
{
     fprintf(out,"%30c%s\n",' ', HEAD1);
     fprintf(out,"%29c%s\n",' ', HEAD2);
     fprintf(out,"%34c%s\n",' ', HEAD3);
}



