/*
  MAIN.H - by Bill Mayne, Silver Spring, MD

      This header file generates the main() function declaration
      and any of the standard arguments argc, argv, and envp.

      Dummy functions _setargv() and _setenvp() are generated to
      save space in the .EXE file if these functions are not
      needed by the program.

      The default is to generate only argc and argv.
      You must generate envp if your program uses spawn() or exec().
      To generate envp, specify "/DENVP" on the MSC command line.
      To suppress generation of argc and argv, specify "/DNOARGS"
      If options "/DENVP /DNOARGS" are both specified, the formal
      arguments argc and argv are declared as place holders, but should
      not be referenced as _setargv will be suppressed.
*/

#if !defined(ENVP)
/* saves space if _setenvp() from the library is not needed */
_setenvp() { }
#endif

#if defined(NOARGS)
/* saves space if _setargv() from the library is not needed */
_setargv() { }
#endif

main(
#if defined(ENVP)
argc,argv,envp) int argc; char *argv[]; char *envp[];
#elif !defined(NOARGS)
argc,argv) int argc; char *argv[];
#else
)
#endif
