/* FCB_DATE:                                                          */
/* Date/time fields of FCB (also DTA_STRUCT, defined below)           */

struct FCB_DATE
  {
  struct
    {
    unsigned seconds:5;
    unsigned minutes:6;
    unsigned hours:5;
    } time;
  struct
    {
    unsigned day:5;
    unsigned month:4;
    unsigned year:7; /* 1980=0 */
    } date;
  };

/* DTA.STRUCT:                                                        */
/* Data block returned by DOS functions 0x4E and 0x4F, which find     */
/* files and directories matching a pathname, with wildcards.         */

#define ARCHIVE 0x20
#define DIRECTORY 0x10
#define SYSTEM 0x04
#define HIDDEN 0x02
#define READONLY 0x01

struct DTA_STRUCT
  {
  char reserved[21];
  char attr;
  union
    {
    struct FCB_DATE field;
    unsigned long date_time; /* For comparing the combination */
    } timestamp;
  unsigned long size;
  char name[13];
  };
