/*  time.h                               

    Struct and function declarations for dealing with time.

*/

#ifndef __TIME_H
#define __TIME_H

#ifndef __DEFS_H__
#include <defs.h>
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

#ifndef  _TIME_T
#define  _TIME_T
typedef long time_t;
#endif

#ifndef  _CLOCK_T
#define  _CLOCK_T
typedef long clock_t;
#endif

#define CLOCKS_PER_SEC 18.2
#define CLK_TCK        18.2

#define TZNAME "Eastern Standard Time"
#define GMT_OFFS 7

struct tm
{
  int   tm_sec;
  int   tm_min;
  int   tm_hour;
  int   tm_mday;
  int   tm_mon;
  int   tm_year;
  int   tm_wday;
  int   tm_yday;
  int   tm_isdst;
};

#ifdef __cplusplus
extern "C" {
#endif
char *       _RTL_NORM asctime(const struct tm *__tblock);
char *       _RTL_NORM ctime(const time_t *__time);
double       _RTL_NORM difftime(time_t __time2, time_t __time1);
struct tm *  _RTL_NORM gmtime(const time_t *__timer);
struct tm *  _RTL_NORM localtime(const time_t *__timer);
time_t       _RTL_NORM time(time_t *__timer);
time_t       _RTL_NORM mktime(struct tm *__timeptr);
clock_t      _RTL_NORM clock(void);
size_t       _RTL_NORM strftime(char *__s, size_t __maxsize,
                        const char *__fmt, const struct tm *__t);
size_t       _RTL_NORM _lstrftime(char *__s, size_t __maxsize,
                        const char *__fmt, const struct tm *__t);

int  *       _RTL_NORM __getDaylight(void);
long *       _RTL_NORM __getTimezone(void);
char * *     _RTL_NORM  __getTzname(void);
int          _RTL_NORM stime(time_t *__tp);
void         _RTL_NORM tzset(void);
char *       _RTL_NORM _strdate(char *datestr);
char *       _RTL_NORM _strtime(char *timestr);
#ifdef __cplusplus
};
#endif

#define _daylight (*__getDaylight())
#define _tzname   ( __getTzname())
#define _timezone (*__getTimezone())



#endif  /* __TIME_H */
