/*
** The Window BOSS's Data Clerk
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
** wn_gtext - get text from window 
**
** Copyright (c) 1988 - Philip A. Mongelluzzo
** All rights reserved.
**
*/

#include "windows.h"                    /* standard stuff */

static char maskchar = 'T';             /* default mask character */
static int  funcode  = GTEXT;           /* default function code */

/*
*************
* wns_gtext *
*************
*/

/*
** wns_gtext(fun,frm,fld,wn,row,col,prmpt,atrib,fill,fwidth,ubuff,hlpmsg,errmsg)
**
**    int        fun - fucntion code (SET || XEQ)
**    (WIFORM)   frm - form pointer  (actual || NFRM)
**    int        fld - field # in form (actual || NFLD)
**    (WINDOWPTR) wn - window pointer
**    int        row - row in window where data input begins
**    int        col - col in window where data input begins
**    (char *) prmpt - field promt (call with NSTR for none)
**    unsigned atrib - field (not prompt) atributes 
**    char      fill - field fill character
**    int     fwidth - width of mask (maximum # of digits is MAXSTR)
**    (char *) ubuff - pointer to char array of fwidth+2 bytes for editing 
**    (char *)hlpmsg - pointer to help message (call with NSTR for none)
**    (char *)errmsg - pointer to err message (call with NSTR) for none)
**
** RETURNS:
**
**    UBUFF with text data via pointer.
**
**    NULL if error, else the non zero value returned from wn_input.
**
** NOTES:
**
**  FUN -   fun can only be SET for form setup, or XEQ for immediate
**          execution.  When called with SET, valid arguements for both
**          "frm" and "fld" must be specfied.  frm is the field pointer
**          returned from frmopn(), and fld is the field sequence number
**          in the form for this field.  When called with XEQ frm must
**          be NFRM and fld must NFLD.
**
**  UBUFF - Editing buffer.  Must be of sufficent size to hold the
**          data as it is entered.  Typical value is the length
**          of the mask + 2 bytes (strlen(mask)+2).
**
**          On entry, the first byte of ubuff should be 
**          a null, otherwise wn_input assumes there is valid
**          data there and will enter edit mode.  This can be 
**          handy if there is a need for prefilled but editable
**          fields.  In actual pratice, wn_input uses this
**          buffer for both initial character data entry and
**          subsequent editing.
**
**          On return, ubuff contains the actual data entered in
**          character format with fill and mask characters as
**          spaces (e.g. "This is a line of text ").
**
**  Calls wn_input to perform data entry.
**
**  No validation is performed.
*/

wns_gtext(fun,frm,fld,wn,row,col,prmpt,atrib,fill,fwidth,ubuff,hlpmsg,errmsg)
int fun;                                /* SET or XEQ */
WIFORM frm;                             /* form pointer or NFRM */
int fld;                                /* field number or NFLD */
WINDOWPTR wn;                           /* window to use */
int row, col;                           /* position of input field */
char *prmpt;                            /* prompt string */
unsigned atrib;                         /* data entry atribute */
char fill;                              /* fill char */
int fwidth;                             /* field width */
char *ubuff;                            /* returns "text" */
char *hlpmsg, *errmsg;                  /* help & error messages */
{
char *mask;                             /* mask buffer */
char *p;                                /* scratch */
int i;                                  /* scratch */
int rv;                                 /* return value */

  if(fun != SET && fun != XEQ)          /* saftey check */
    return(NULL);

  if(fun == SET) {                      /* set up */
    if(frm[fld]->pself != (char *)frm[fld])
      wns_ierr("wn_gtext");             /* die if memory is mangled */
    frm[fld]->wn = wn;                  /* set window */
    frm[fld]->row = row;                /* set row */
    frm[fld]->col = col;                /* set col */
    frm[fld]->prmpt = prmpt;            /* set prompt */
    frm[fld]->atrib = atrib;            /* set attribute */
    frm[fld]->fill = fill;              /* set fill character */
    frm[fld]->fcode = funcode;          /* function code */
    frm[fld]->v1.vi = fwidth;           /* fwidth */
    frm[fld]->v2.vcp = ubuff;           /* &ubuff */
    frm[fld]->v3.vcp = hlpmsg;          /* &hlpmsg */
    frm[fld]->v4.vcp = errmsg;          /* &errmsg */
    return(TRUE);
  }

  if(fwidth >= MAXSTR) {                /* dont allow foolishness */
    *ubuff = NUL;                       /* indicate error */
    return(NULL);                       /* and return */
  }
  mask = malloc(fwidth+2);              /* fetch some memory */
  if(!mask) {                           /* allocation fail ?? */
    *ubuff = NUL;                       /* terminate string */
    return(NULL);                       /* say things went bad */
  }
  p = mask;                             /* temp pointer */
  for(i=0; i<fwidth; i++) {             /* set up mask */
    *p = maskchar;                      /* TEXT (any, upper, lower) */
    p++;                                /* bump pointer */
    *p = NUL;                           /* terminate string */
  }
  if(!(rv=wn_input(wn,row,col,prmpt,mask,fill,atrib,ubuff,hlpmsg))) {
    *ubuff= NUL;                        /* indicate error */
    free(mask);                         /* free memory */
    return(NULL);                       /* indicate error */
  }
  free(mask);                           /* free memory */
  if(wni_frmflg) return(TRUE);          /* wn_frmget in progress */
  return(rv);                           /* all done */
}

#ifdef COMMENTS
/*
************
* wn_gtext *                            /* Plain Text */
************
*/
#endif

wn_gtext(fun,frm,fld,wn,row,col,prmpt,atrib,fill,fwidth,ubuff,hlpmsg,errmsg)
int fun;                                /* SET or XEQ */
WIFORM frm;                             /* form pointer or NFRM */
int fld;                                /* field number or NFLD */
WINDOWPTR wn;                           /* window to use */
int row, col;                           /* position of input field */
char *prmpt;                            /* prompt string */
unsigned atrib;                         /* data entry atribute */
char fill;                              /* fill char */
int fwidth;                             /* field width */
char *ubuff;                            /* returns "text" */
char *hlpmsg, *errmsg;                  /* help & error messages */
{
  maskchar = 'T';
  funcode = GTEXT;                      
  return(wns_gtext(fun,frm,fld,wn,row,col,prmpt,atrib,fill,fwidth,
            ubuff,hlpmsg,errmsg));
}

#ifdef COMMENTS
/*
*************
* wn_gutext *                           /* Upper Case Only Text */
*************
*/
#endif

wn_gutext(fun,frm,fld,wn,row,col,prmpt,atrib,fill,fwidth,ubuff,hlpmsg,errmsg)
int fun;                                /* SET or XEQ */
WIFORM frm;                             /* form pointer or NFRM */
int fld;                                /* field number or NFLD */
WINDOWPTR wn;                           /* window to use */
int row, col;                           /* position of input field */
char *prmpt;                            /* prompt string */
unsigned atrib;                         /* data entry atribute */
char fill;                              /* fill char */
int fwidth;                             /* field width */
char *ubuff;                            /* returns "text" */
char *hlpmsg, *errmsg;                  /* help & error messages */
{
  funcode = GUTEXT;
  maskchar = 'U';
  return(wns_gtext(fun,frm,fld,wn,row,col,prmpt,atrib,fill,fwidth,
            ubuff,hlpmsg,errmsg));
}

#ifdef COMMENTS
/*
*************
* wn_gltext *                           /* Lower Case Only Comments */
*************
*/
#endif

wn_gltext(fun,frm,fld,wn,row,col,prmpt,atrib,fill,fwidth,ubuff,hlpmsg,errmsg)
int fun;                                /* SET or XEQ */
WIFORM frm;                             /* form pointer or NFRM */
int fld;                                /* field number or NFLD */
WINDOWPTR wn;                           /* window to use */
int row, col;                           /* position of input field */
char *prmpt;                            /* prompt string */
unsigned atrib;                         /* data entry atribute */
char fill;                              /* fill char */
int fwidth;                             /* field width */
char *ubuff;                            /* returns "text" */
char *hlpmsg, *errmsg;                  /* help & error messages */
{
  funcode = GLTEXT;
  maskchar = 'L';
  return(wns_gtext(fun,frm,fld,wn,row,col,prmpt,atrib,fill,fwidth,
            ubuff,hlpmsg,errmsg));

}

#ifdef COMMENTS
/*
*************
* wn_gatext *                           /* Get Ascii (ANY ASCII) */
*************
*/
#endif

wn_gatext(fun,frm,fld,wn,row,col,prmpt,atrib,fill,fwidth,ubuff,hlpmsg,errmsg)
int fun;                                /* SET or XEQ */
WIFORM frm;                             /* form pointer or NFRM */
int fld;                                /* field number or NFLD */
WINDOWPTR wn;                           /* window to use */
int row, col;                           /* position of input field */
char *prmpt;                            /* prompt string */
unsigned atrib;                         /* data entry atribute */
char fill;                              /* fill char */
int fwidth;                             /* field width */
char *ubuff;                            /* returns "text" */
char *hlpmsg, *errmsg;                  /* help & error messages */
{
  funcode = GATEXT;
  maskchar = 'A';
  return(wns_gtext(fun,frm,fld,wn,row,col,prmpt,atrib,fill,fwidth,
            ubuff,hlpmsg,errmsg));

}

/* End */
