# Exported from MS Access to MySQL
# (C) 1997-98 CYNERGI - www.cynergi.net, info@cynergi.net


CREATE TABLE abandonedorders
     (
     orderid                                                           INT NOT NULL DEFAULT 0,
     storeid                                                           CHAR(50) NOT NULL,
     orderdate                                                         DATETIME NOT NULL,
     KEY (orderid),
     PRIMARY KEY (orderid),
     KEY (storeid)
     )\g

# This table has no data

CREATE TABLE affiliate
     (
     id                                                                INT NOT NULL,
     enabled                                                           TINYINT UNSIGNED NOT NULL,
     login                                                             CHAR(50),
     pwd                                                               CHAR(50),
     discount                                                          REAL,
     commission                                                        REAL,
     affidentity                                                       CHAR(50),
     company                                                           CHAR(50),
     name                                                              CHAR(50),
     phone                                                             CHAR(50),
     fax                                                               CHAR(50),
     address                                                           CHAR(255),
     email                                                             CHAR(50),
     mid                                                               CHAR(50),
     KEY (affidentity),
     PRIMARY KEY (id),
     KEY (mid)
     )\g

# This table has no data

CREATE TABLE bonus_range
     (
     timeid                                                            INT,
     storeid                                                           CHAR(50) NOT NULL,
     timename                                                          CHAR(100),
     fromt                                                             DATETIME,
     tot                                                               DATETIME
     )\g

# This table has no data

CREATE TABLE categories
     (
     id                                                                INT,
     category                                                          CHAR(100),
     storeid                                                           CHAR(50)
     )\g

# This table has no data

CREATE TABLE country
     (
     countryid                                                         CHAR(2) NOT NULL,
     name                                                              CHAR(50) NOT NULL,
     KEY (countryid),
     PRIMARY KEY (countryid)
     )\g

INSERT INTO country VALUES ('AC', 'Ascension Island')\g
INSERT INTO country VALUES ('AD', 'Andorra')\g
INSERT INTO country VALUES ('AE', 'United Arab Emirates')\g
INSERT INTO country VALUES ('AF', 'Afghanistan')\g
INSERT INTO country VALUES ('AG', 'Antigua and Barbuda')\g
INSERT INTO country VALUES ('AI', 'Anguilla')\g
INSERT INTO country VALUES ('AL', 'Albania')\g
INSERT INTO country VALUES ('AM', 'Armenia')\g
INSERT INTO country VALUES ('AN', 'Netherlands Antilles')\g
INSERT INTO country VALUES ('AO', 'Angola')\g
INSERT INTO country VALUES ('AQ', 'Antartica')\g
INSERT INTO country VALUES ('AR', 'Argentina')\g
INSERT INTO country VALUES ('AS', 'American Samoa')\g
INSERT INTO country VALUES ('AT', 'Austria')\g
INSERT INTO country VALUES ('AU', 'Australia')\g
INSERT INTO country VALUES ('AW', 'Aruba')\g
INSERT INTO country VALUES ('AZ', 'Azerbaijan')\g
INSERT INTO country VALUES ('BA', 'Bosnia and Herzegovina')\g
INSERT INTO country VALUES ('BB', 'Barbados')\g
INSERT INTO country VALUES ('BD', 'Bangladesh')\g
INSERT INTO country VALUES ('BE', 'Belgium')\g
INSERT INTO country VALUES ('BF', 'Burkina Faso')\g
INSERT INTO country VALUES ('BG', 'Bulgaria')\g
INSERT INTO country VALUES ('BH', 'Bahrain')\g
INSERT INTO country VALUES ('BI', 'Burundi')\g
INSERT INTO country VALUES ('BJ', 'Benin')\g
INSERT INTO country VALUES ('BM', 'Bermuda')\g
INSERT INTO country VALUES ('BN', 'Brunei Darussalam')\g
INSERT INTO country VALUES ('BO', 'Bolivia')\g
INSERT INTO country VALUES ('BR', 'Brazil')\g
INSERT INTO country VALUES ('BS', 'Bahamas')\g
INSERT INTO country VALUES ('BT', 'Bhutan')\g
INSERT INTO country VALUES ('BV', 'Bouvet Island')\g
INSERT INTO country VALUES ('BW', 'Botswana')\g
INSERT INTO country VALUES ('BY', 'Belarus')\g
INSERT INTO country VALUES ('BZ', 'Belize')\g
INSERT INTO country VALUES ('CA', 'Canada')\g
INSERT INTO country VALUES ('CC', 'Cocos (Keeling) Islands')\g
INSERT INTO country VALUES ('CD', 'Congo, Democratic People\'s Republic')\g
INSERT INTO country VALUES ('CF', 'Central African Republic')\g
INSERT INTO country VALUES ('CG', 'Congo, Republic of')\g
INSERT INTO country VALUES ('CH', 'Switzerland')\g
INSERT INTO country VALUES ('CI', 'Cote d\'Ivoire')\g
INSERT INTO country VALUES ('CK', 'Cook Islands')\g
INSERT INTO country VALUES ('CL', 'Chile')\g
INSERT INTO country VALUES ('CM', 'Cameroon')\g
INSERT INTO country VALUES ('CN', 'China')\g
INSERT INTO country VALUES ('CO', 'Colombia')\g
INSERT INTO country VALUES ('CR', 'Costa Rica')\g
INSERT INTO country VALUES ('CU', 'Cuba')\g
INSERT INTO country VALUES ('CV', 'Cap Verde')\g
INSERT INTO country VALUES ('CX', 'Christmas Island')\g
INSERT INTO country VALUES ('CY', 'Cyprus')\g
INSERT INTO country VALUES ('CZ', 'Czeck Republic')\g
INSERT INTO country VALUES ('DE', 'Germany')\g
INSERT INTO country VALUES ('DJ', 'Djibouti')\g
INSERT INTO country VALUES ('DK', 'Denmark')\g
INSERT INTO country VALUES ('DM', 'Dominica')\g
INSERT INTO country VALUES ('DO', 'Dominican Republic')\g
INSERT INTO country VALUES ('DZ', 'Algeria')\g
INSERT INTO country VALUES ('EC', 'Ecuador')\g
INSERT INTO country VALUES ('EE', 'Estonia')\g
INSERT INTO country VALUES ('EG', 'Egypt')\g
INSERT INTO country VALUES ('EH', 'Western Sahara')\g
INSERT INTO country VALUES ('ER', 'Eritrea')\g
INSERT INTO country VALUES ('ES', 'Spain')\g
INSERT INTO country VALUES ('ET', 'Ethiopia')\g
INSERT INTO country VALUES ('FI', 'Finland')\g
INSERT INTO country VALUES ('FJ', 'Fiji')\g
INSERT INTO country VALUES ('FK', 'Falkland Islands (Malvina)')\g
INSERT INTO country VALUES ('FM', 'Micronesia, Federal State of')\g
INSERT INTO country VALUES ('FO', 'Faroe Islands')\g
INSERT INTO country VALUES ('FR', 'France')\g
INSERT INTO country VALUES ('GA', 'Gabon')\g
INSERT INTO country VALUES ('GD', 'Grenada')\g
INSERT INTO country VALUES ('GE', 'Georgia')\g
INSERT INTO country VALUES ('GF', 'French Guiana')\g
INSERT INTO country VALUES ('GG', 'Guernsey')\g
INSERT INTO country VALUES ('GH', 'Ghana')\g
INSERT INTO country VALUES ('GI', 'Gibraltar')\g
INSERT INTO country VALUES ('GL', 'Greenland')\g
INSERT INTO country VALUES ('GM', 'Gambia')\g
INSERT INTO country VALUES ('GN', 'Guinea')\g
INSERT INTO country VALUES ('GP', 'Guadeloupe')\g
INSERT INTO country VALUES ('GQ', 'Equatorial Guinea')\g
INSERT INTO country VALUES ('GR', 'Greece')\g
INSERT INTO country VALUES ('GS', 'South Georgia and the South Sandwich Islands')\g
INSERT INTO country VALUES ('GT', 'Guatemala')\g
INSERT INTO country VALUES ('GU', 'Guam')\g
INSERT INTO country VALUES ('GW', 'Guinea-Bissau')\g
INSERT INTO country VALUES ('GY', 'Guyana')\g
INSERT INTO country VALUES ('HK', 'Hong Kong')\g
INSERT INTO country VALUES ('HM', 'Heard and McDonald Islands')\g
INSERT INTO country VALUES ('HN', 'Honduras')\g
INSERT INTO country VALUES ('HR', 'Croatia/Hrvatska')\g
INSERT INTO country VALUES ('HT', 'Haiti')\g
INSERT INTO country VALUES ('HU', 'Hungary')\g
INSERT INTO country VALUES ('ID', 'Indonesia')\g
INSERT INTO country VALUES ('IE', 'Ireland')\g
INSERT INTO country VALUES ('IL', 'Israel')\g
INSERT INTO country VALUES ('IM', 'Isle of Man')\g
INSERT INTO country VALUES ('IN', 'India')\g
INSERT INTO country VALUES ('IO', 'British Indian Ocean Territory')\g
INSERT INTO country VALUES ('IQ', 'Iraq')\g
INSERT INTO country VALUES ('IR', 'Iran (Islamic Republic of)')\g
INSERT INTO country VALUES ('IS', 'Iceland')\g
INSERT INTO country VALUES ('IT', 'Italy')\g
INSERT INTO country VALUES ('JE', 'Jersey')\g
INSERT INTO country VALUES ('JM', 'Jamaica')\g
INSERT INTO country VALUES ('JO', 'Jordan')\g
INSERT INTO country VALUES ('JP', 'Japan')\g
INSERT INTO country VALUES ('KE', 'Kenya')\g
INSERT INTO country VALUES ('KG', 'Kyrgyzstan')\g
INSERT INTO country VALUES ('KH', 'Cambodia')\g
INSERT INTO country VALUES ('KI', 'Kiribati')\g
INSERT INTO country VALUES ('KM', 'Comoros')\g
INSERT INTO country VALUES ('KN', 'Saint Kitts and Nevis')\g
INSERT INTO country VALUES ('KP', 'Korea, Democratic People\'s Republic')\g
INSERT INTO country VALUES ('KR', 'Korea, Republic of')\g
INSERT INTO country VALUES ('KW', 'Kuwait')\g
INSERT INTO country VALUES ('KY', 'Cayman Islands')\g
INSERT INTO country VALUES ('KZ', 'Kazakhstan')\g
INSERT INTO country VALUES ('LA', 'Lao, People\'s Democratic Republic')\g
INSERT INTO country VALUES ('LB', 'Lebanon')\g
INSERT INTO country VALUES ('LC', 'Saint Lucia')\g
INSERT INTO country VALUES ('LI', 'Liechtenstein')\g
INSERT INTO country VALUES ('LK', 'Sri Lanka')\g
INSERT INTO country VALUES ('LR', 'Liberia')\g
INSERT INTO country VALUES ('LS', 'Lesotho')\g
INSERT INTO country VALUES ('LT', 'Lithuania')\g
INSERT INTO country VALUES ('LU', 'Luxembourg')\g
INSERT INTO country VALUES ('LV', 'Latvia')\g
INSERT INTO country VALUES ('LY', 'Libyan Arab Jamahiriya')\g
INSERT INTO country VALUES ('MA', 'Morocco')\g
INSERT INTO country VALUES ('MC', 'Monaco')\g
INSERT INTO country VALUES ('MD', 'Moldova, Republic of')\g
INSERT INTO country VALUES ('MG', 'Madagascar')\g
INSERT INTO country VALUES ('MH', 'Marshall Islands')\g
INSERT INTO country VALUES ('MK', 'Macedonia, Former Yugoslav Republic')\g
INSERT INTO country VALUES ('ML', 'Mali')\g
INSERT INTO country VALUES ('MM', 'Myanmar')\g
INSERT INTO country VALUES ('MN', 'Mongolia')\g
INSERT INTO country VALUES ('MO', 'Macau')\g
INSERT INTO country VALUES ('MP', 'Northern Mariana Islands')\g
INSERT INTO country VALUES ('MQ', 'Martinique')\g
INSERT INTO country VALUES ('MR', 'Mauritania')\g
INSERT INTO country VALUES ('MS', 'Montserrat')\g
INSERT INTO country VALUES ('MT', 'Malta')\g
INSERT INTO country VALUES ('MU', 'Mauritius')\g
INSERT INTO country VALUES ('MV', 'Maldives')\g
INSERT INTO country VALUES ('MW', 'Malawi')\g
INSERT INTO country VALUES ('MX', 'Mexico')\g
INSERT INTO country VALUES ('MY', 'Malaysia')\g
INSERT INTO country VALUES ('MZ', 'Mozambique')\g
INSERT INTO country VALUES ('NA', 'Namibia')\g
INSERT INTO country VALUES ('NC', 'New Caledonia')\g
INSERT INTO country VALUES ('NE', 'Niger')\g
INSERT INTO country VALUES ('NF', 'Norfolk Island')\g
INSERT INTO country VALUES ('NG', 'Nigeria')\g
INSERT INTO country VALUES ('NI', 'Nicaragua')\g
INSERT INTO country VALUES ('NL', 'Netherlands')\g
INSERT INTO country VALUES ('NO', 'Norway')\g
INSERT INTO country VALUES ('NP', 'Nepal')\g
INSERT INTO country VALUES ('NR', 'Nauru')\g
INSERT INTO country VALUES ('NU', 'Niue')\g
INSERT INTO country VALUES ('NZ', 'New Zealand')\g
INSERT INTO country VALUES ('OM', 'Oman')\g
INSERT INTO country VALUES ('PA', 'Panama')\g
INSERT INTO country VALUES ('PE', 'Peru')\g
INSERT INTO country VALUES ('PF', 'French Polynesia')\g
INSERT INTO country VALUES ('PG', 'Papua New Guinea')\g
INSERT INTO country VALUES ('PH', 'Philippines')\g
INSERT INTO country VALUES ('PK', 'Pakistan')\g
INSERT INTO country VALUES ('PL', 'Poland')\g
INSERT INTO country VALUES ('PM', 'St. Pierre and Miquelon')\g
INSERT INTO country VALUES ('PN', 'Pitcairn Island')\g
INSERT INTO country VALUES ('PR', 'Puerto Rico')\g
INSERT INTO country VALUES ('PT', 'Portugal')\g
INSERT INTO country VALUES ('PW', 'Palau')\g
INSERT INTO country VALUES ('PY', 'Paraguay')\g
INSERT INTO country VALUES ('QA', 'Qatar')\g
INSERT INTO country VALUES ('RE', 'Reunion Island')\g
INSERT INTO country VALUES ('RO', 'Romania')\g
INSERT INTO country VALUES ('RU', 'Russian Federation')\g
INSERT INTO country VALUES ('RW', 'Rwanda')\g
INSERT INTO country VALUES ('SA', 'Saudi Arabia')\g
INSERT INTO country VALUES ('SB', 'Solomon Islands')\g
INSERT INTO country VALUES ('SC', 'Seychelles')\g
INSERT INTO country VALUES ('SD', 'Sudan')\g
INSERT INTO country VALUES ('SE', 'Sweden')\g
INSERT INTO country VALUES ('SG', 'Singapore')\g
INSERT INTO country VALUES ('SH', 'St. Helena')\g
INSERT INTO country VALUES ('SI', 'Slovenia')\g
INSERT INTO country VALUES ('SJ', 'Svalbard and Jan Mayen Islands')\g
INSERT INTO country VALUES ('SK', 'Slovak Republic')\g
INSERT INTO country VALUES ('SL', 'Sierra Leone')\g
INSERT INTO country VALUES ('SM', 'San Marino')\g
INSERT INTO country VALUES ('SN', 'Senegal')\g
INSERT INTO country VALUES ('SO', 'Somalia')\g
INSERT INTO country VALUES ('SR', 'Suriname')\g
INSERT INTO country VALUES ('ST', 'Sao Tome and Principe')\g
INSERT INTO country VALUES ('SV', 'El Salvador')\g
INSERT INTO country VALUES ('SY', 'Syrian Arab Republic')\g
INSERT INTO country VALUES ('SZ', 'Swaziland')\g
INSERT INTO country VALUES ('TC', 'Turks and Ciacos Islands')\g
INSERT INTO country VALUES ('TD', 'Chad')\g
INSERT INTO country VALUES ('TF', 'French Southern Territories')\g
INSERT INTO country VALUES ('TG', 'Togo')\g
INSERT INTO country VALUES ('TH', 'Thailand')\g
INSERT INTO country VALUES ('TJ', 'Tajikistan')\g
INSERT INTO country VALUES ('TK', 'Tokelau')\g
INSERT INTO country VALUES ('TM', 'Turkmenistan')\g
INSERT INTO country VALUES ('TN', 'Tunisia')\g
INSERT INTO country VALUES ('TO', 'Tonga')\g
INSERT INTO country VALUES ('TP', 'East Timor')\g
INSERT INTO country VALUES ('TR', 'Turkey')\g
INSERT INTO country VALUES ('TT', 'Trinidad and Tobago')\g
INSERT INTO country VALUES ('TV', 'Tuvalu')\g
INSERT INTO country VALUES ('TW', 'Taiwan')\g
INSERT INTO country VALUES ('TZ', 'Tanzania')\g
INSERT INTO country VALUES ('UA', 'Ukraine')\g
INSERT INTO country VALUES ('UG', 'Uganda')\g
INSERT INTO country VALUES ('UK', 'United Kingdom')\g
INSERT INTO country VALUES ('UM', 'US Minor Outlying Islands')\g
INSERT INTO country VALUES ('US', 'United States')\g
INSERT INTO country VALUES ('UY', 'Uruguay')\g
INSERT INTO country VALUES ('UZ', 'Uzbekistan')\g
INSERT INTO country VALUES ('VA', 'Holy See (City Vatican State)')\g
INSERT INTO country VALUES ('VC', 'Saint Vincent and the Grenadines')\g
INSERT INTO country VALUES ('VE', 'Venezuela')\g
INSERT INTO country VALUES ('VG', 'Virgin Islands (British)')\g
INSERT INTO country VALUES ('VI', 'Virgin Islands (USA)')\g
INSERT INTO country VALUES ('VN', 'Vietnam')\g
INSERT INTO country VALUES ('VU', 'Vanuatu')\g
INSERT INTO country VALUES ('WF', 'Wallis and Futuna Islands')\g
INSERT INTO country VALUES ('WS', 'Western Samoa')\g
INSERT INTO country VALUES ('YE', 'Yemen')\g
INSERT INTO country VALUES ('YT', 'Mayotte')\g
INSERT INTO country VALUES ('YU', 'Yugoslavia')\g
INSERT INTO country VALUES ('ZA', 'South Africa')\g
INSERT INTO country VALUES ('ZM', 'Zambia')\g
INSERT INTO country VALUES ('ZR', 'Zaire')\g
INSERT INTO country VALUES ('ZW', 'Zimbabwe')\g

CREATE TABLE currentid
     (
     tablename                                                         CHAR(30) NOT NULL,
     maxid                                                             INT NOT NULL DEFAULT 0,
     PRIMARY KEY (tablename),
     KEY (tablename)
     )\g

INSERT INTO currentid VALUES ('departments', 0)\g
INSERT INTO currentid VALUES ('discount', 0)\g
INSERT INTO currentid VALUES ('groups', 0)\g
INSERT INTO currentid VALUES ('options', 0)\g
INSERT INTO currentid VALUES ('orders', 1)\g
INSERT INTO currentid VALUES ('paymentmethods', 9)\g
INSERT INTO currentid VALUES ('store_shipmethod', 0)\g
INSERT INTO currentid VALUES ('store_shiprate', 1)\g
INSERT INTO currentid VALUES ('store_shiptiers', 0)\g
INSERT INTO currentid VALUES ('stores', 1)\g
INSERT INTO currentid VALUES ('users', 2)\g

CREATE TABLE customer_discount
     (
     discountid                                                        INT,
     description                                                       CHAR(100)
     )\g

INSERT INTO customer_discount VALUES (0, 'No Discount')\g
INSERT INTO customer_discount VALUES (1, 'VIP Discount Special')\g
INSERT INTO customer_discount VALUES (2, 'Bonus Point Special')\g
INSERT INTO customer_discount VALUES (3, 'Affiliate Program Special')\g

CREATE TABLE departments
     (
     storeid                                                           CHAR(50) NOT NULL,
     deptid                                                            CHAR(50) NOT NULL,
     deptname                                                          CHAR(30),
     datecreated                                                       DATETIME,
     active                                                            SMALLINT,
     KEY (storeid),
     KEY (deptid),
     PRIMARY KEY (storeid, deptid),
     KEY (storeid)
     )\g

# This table has no data

CREATE TABLE discount
     (
     discid                                                            SMALLINT NOT NULL DEFAULT 0,
     storeid                                                           CHAR(40) NOT NULL,
     discname                                                          CHAR(30),
     disctype                                                          SMALLINT,
     rate                                                              FLOAT,
     active                                                            SMALLINT,
     createdate                                                        DATETIME,
     min_range                                                         INT NOT NULL,
     max_range                                                         INT,
     KEY (storeid),
     KEY (discid),
     PRIMARY KEY (discid, storeid, min_range)
     )\g

# This table has no data

CREATE TABLE groups
     (
     storeid                                                           CHAR(50) NOT NULL,
     deptid                                                            CHAR(50) NOT NULL,
     groupid                                                           CHAR(50) NOT NULL,
     groupname                                                         CHAR(30),
     datecreated                                                       DATETIME,
     active                                                            SMALLINT,
     KEY (storeid, deptid),
     KEY (deptid),
     KEY (groupid),
     PRIMARY KEY (storeid, deptid, groupid),
     KEY (storeid)
     )\g

# This table has no data

CREATE TABLE merchant
     (
     id                                                                CHAR(50) NOT NULL,
     name                                                              CHAR(50),
     login                                                             CHAR(50),
     pwd                                                               CHAR(50),
     site                                                              CHAR(225),
     bannerpath                                                        CHAR(225),
     discount1                                                         REAL,
     discount2                                                         REAL,
     commission1                                                       REAL,
     commission2                                                       REAL,
     PRIMARY KEY (id)
     )\g

INSERT INTO merchant
VALUES (
     '1', 
     'My Store', 
     'storeadmin', 
     'password', 
     'localhost', 
     'http://localhost/webpshop/store_1/images/headerimg.gif', 
     0, 
     0, 
     0, 
     0 )\g


CREATE TABLE online_pay
     (
     storeid                                                           CHAR(50) NOT NULL,
     host                                                              CHAR(20),
     storename                                                         CHAR(20),
     port                                                              INT,
     clerk                                                             CHAR(20),
     configfile                                                        CHAR(60),
     uselinkpointtax                                                   TINYINT,
     uselinkpointshipping                                              TINYINT,
     x_login                                                           CHAR(50),
     x_password                                                        CHAR(50),
     KEY (storeid),
     PRIMARY KEY (storeid),
     KEY (storeid)
     )\g

# This table has no data

CREATE TABLE online_pay_orders
     (
     orderid                                                           INT NOT NULL DEFAULT 0,
     paymethod_id                                                      SMALLINT NOT NULL DEFAULT 0,
     status                                                            CHAR(30),
     avs_code                                                          CHAR(5),
     auth_code                                                         CHAR(50),
     txn_id                                                            CHAR(15),
     error_code                                                        CHAR(30),
     error_message                                                     TEXT,
     auth_message                                                      CHAR(50),
     processor_order_id                                                CHAR(50),
     storeid                                                           CHAR(50) NOT NULL,
     referencenum                                                      CHAR(50),
     KEY (orderid),
     KEY (paymethod_id),
     PRIMARY KEY (orderid),
     KEY (storeid)
     )\g

# This table has no data

CREATE TABLE options
     (
     optid                                                             INT NOT NULL,
     optpartnbr                                                        INT NOT NULL,
     opttitle                                                          CHAR(50),
     opprice                                                           FLOAT,
     storeid                                                           CHAR(50) NOT NULL,
     KEY (optid),
     PRIMARY KEY (optid, optpartnbr),
     KEY (storeid)
     )\g

# This table has no data

CREATE TABLE order_basket
     (
     storeid                                                           CHAR(50) NOT NULL,
     deptid                                                            CHAR(50) NOT NULL,
     groupid                                                           CHAR(50) NOT NULL,
     prodid                                                            CHAR(50) NOT NULL,
     orderid                                                           INT NOT NULL,
     qty                                                               INT,
     price                                                             FLOAT,
     prodtitle                                                         CHAR(120),
     weight                                                            REAL,
     opt_ids                                                           CHAR(50) NOT NULL,
     taxable                                                           SMALLINT,
     extprice                                                          FLOAT NOT NULL DEFAULT 0,
     KEY (orderid),
     KEY (deptid),
     KEY (groupid),
     KEY (orderid),
     PRIMARY KEY (storeid, deptid, groupid, prodid, orderid, opt_ids),
     KEY (prodid),
     KEY (storeid)
     )\g

# This table has no data

CREATE TABLE order_content
     (
     storeid                                                           CHAR(50) NOT NULL,
     deptid                                                            CHAR(50) NOT NULL,
     groupid                                                           CHAR(50) NOT NULL,
     prodid                                                            CHAR(50) NOT NULL,
     orderid                                                           INT NOT NULL,
     qty                                                               INT,
     price                                                             FLOAT,
     prodtitle                                                         CHAR(120),
     weight                                                            REAL,
     opt_ids                                                           CHAR(50) NOT NULL,
     taxable                                                           SMALLINT,
     extprice                                                          REAL,
     KEY (orderid),
     KEY (deptid),
     KEY (groupid),
     KEY (orderid),
     PRIMARY KEY (storeid, deptid, groupid, prodid, orderid, opt_ids),
     KEY (prodid),
     KEY (storeid)
     )\g

# This table has no data

CREATE TABLE order_payment_detail
     (
     orderid                                                           INT NOT NULL,
     paymethod_id                                                      SMALLINT NOT NULL,
     contact_number                                                    CHAR(50),
     check_number                                                      CHAR(50),
     bank_name                                                         CHAR(50),
     date_received                                                     DATETIME,
     ccnumber                                                          CHAR(50),
     ccidcode                                                          CHAR(5),
     ccholdername                                                      CHAR(50),
     ccexpdate                                                         CHAR(50),
     po_number                                                         CHAR(50),
     storeid                                                           CHAR(50) NOT NULL,
     routingnum                                                        CHAR(25),
     acctnum                                                           CHAR(25),
     KEY (paymethod_id),
     KEY (orderid),
     KEY (paymethod_id),
     PRIMARY KEY (orderid, paymethod_id),
     KEY (storeid)
     )\g

# This table has no data

CREATE TABLE order_ship_detail
     (
     orderid                                                           INT NOT NULL,
     userid                                                            INT,
     shipmethod                                                        CHAR(50),
     service_type                                                      CHAR(50),
     packaging                                                         CHAR(50),
     basis_value                                                       REAL,
     certified_value                                                   REAL,
     merchandise_value                                                 REAL,
     delivery_type                                                     CHAR(50),
     collect_on_delivery                                               CHAR(50),
     cod_value                                                         REAL,
     cod_cost                                                          REAL,
     insurance_cost                                                    REAL,
     insurance_value                                                   REAL,
     drop_off_pickup                                                   CHAR(50),
     drop_off_value                                                    REAL,
     return_receipt                                                    REAL,
     restricted_delivery                                               REAL,
     usps_service                                                      CHAR(50),
     usps_service_value                                                REAL,
     total_value                                                       REAL,
     KEY (orderid),
     PRIMARY KEY (orderid),
     KEY (userid)
     )\g

# This table has no data

CREATE TABLE order_ship_fdx_expr
     (
     orderid                                                           INT NOT NULL,
     insurance_value                                                   REAL,
     insurance_cost                                                    REAL,
     cod_value                                                         FLOAT,
     saturday_delivery_value                                           FLOAT,
     accessible_dangerous_value                                        FLOAT,
     inaccessible_dangerous_value                                      FLOAT,
     courier_pickup                                                    FLOAT,
     shiptoresidence                                                   FLOAT,
     surcharge                                                         FLOAT,
     KEY (orderid),
     PRIMARY KEY (orderid)
     )\g

# This table has no data

CREATE TABLE order_ship_fdx_grnd
     (
     orderid                                                           INT NOT NULL DEFAULT 0,
     insurance_value                                                   REAL,
     insurance_cost                                                    REAL,
     ground_cod                                                        FLOAT,
     ground_aod                                                        FLOAT,
     ground_apod                                                       FLOAT,
     ground_ecod                                                       FLOAT,
     ground_hamater                                                    FLOAT,
     shiptoresidence                                                   FLOAT,
     surcharge                                                         FLOAT,
     KEY (orderid),
     PRIMARY KEY (orderid)
     )\g

# This table has no data

CREATE TABLE orders
     (
     orderid                                                           INT NOT NULL,
     userid                                                            INT,
     orderdate                                                         DATETIME,
     status                                                            CHAR(15),
     payment_method                                                    CHAR(50),
     payment_date                                                      DATETIME,
     shipping_date                                                     DATETIME,
     tracking_number                                                   CHAR(50),
     process_notes                                                     TEXT,
     notes                                                             TEXT,
     subtotal                                                          REAL,
     tax                                                               REAL,
     sh                                                                REAL,
     total                                                             REAL,
     miscdiscount                                                      REAL,
     creditAmt                                                         REAL,
     billname                                                          CHAR(50),
     namelast                                                          CHAR(25),
     namefirst                                                         CHAR(25),
     billaddr1                                                         CHAR(50),
     billaddr2                                                         CHAR(50),
     billcity                                                          CHAR(50),
     billprovince                                                      CHAR(50),
     billpostalcode                                                    CHAR(50),
     billcountryid                                                     CHAR(2),
     billphone                                                         CHAR(20),
     billfax                                                           CHAR(20),
     billemail                                                         CHAR(100),
     shipname                                                          CHAR(50),
     shipaddr1                                                         CHAR(50),
     shipaddr2                                                         CHAR(50),
     shipcity                                                          CHAR(50),
     shipprovince                                                      CHAR(50),
     shippostalcode                                                    CHAR(50),
     shipcountryid                                                     CHAR(2),
     shipphone                                                         CHAR(20),
     shipfax                                                           CHAR(20),
     shipemail                                                         CHAR(100),
     storeid                                                           CHAR(50) NOT NULL,
     discount_method                                                   INT,
     cust_discount                                                     REAL,
     bonus                                                             INT,
     category                                                          CHAR(100),
     KEY (orderid),
     PRIMARY KEY (orderid),
     KEY (storeid)
     )\g

INSERT INTO orders
VALUES (
     1, 
     NULL, 
     '2003-07-17 09:18:33', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     '1', 
     NULL, 
     NULL, 
     NULL, 
     NULL )\g


CREATE TABLE paymentmethods
     (
     paymethod_id                                                      SMALLINT NOT NULL,
     name                                                              CHAR(50),
     description                                                       TEXT,
     image_name                                                        CHAR(50),
     image_w                                                           INT,
     image_h                                                           INT,
     active                                                            SMALLINT NOT NULL,
     PRIMARY KEY (paymethod_id)
     )\g

INSERT INTO paymentmethods
VALUES (
     0, 
     'Electronic Funds Transfer', 
     'Payment electronically transfers from customer\'s account', 
     NULL, 
     NULL, 
     NULL, 
     1 )\g

INSERT INTO paymentmethods
VALUES (
     1, 
     'Get info via fax', 
     'Customer types in fax number, and we fax them and we fax them an invoice', 
     'pay_fax.gif', 
     30, 
     19, 
     1 )\g

INSERT INTO paymentmethods
VALUES (
     2, 
     'Get info via phone', 
     'Customer types in a phone number, we call to get credit card info', 
     'pay_phone.gif', 
     30, 
     19, 
     1 )\g

INSERT INTO paymentmethods
VALUES (
     3, 
     'Check', 
     'Customer sends a check to us, on receipt, store info', 
     'pay_check.gif', 
     30, 
     19, 
     1 )\g

INSERT INTO paymentmethods
VALUES (
     4, 
     'Cash On Delivery (COD)', 
     'Package sent to customer, but not given until payment is given', 
     'pay_cod.gif', 
     30, 
     19, 
     1 )\g

INSERT INTO paymentmethods
VALUES (
     5, 
     'Purchase Order (PO)', 
     'Company to company credit', 
     'pay_po.gif', 
     30, 
     19, 
     1 )\g

INSERT INTO paymentmethods
VALUES (
     6, 
     'American Express', 
     'American Express credit card', 
     'pay_ae.gif', 
     30, 
     19, 
     1 )\g

INSERT INTO paymentmethods
VALUES (
     7, 
     'Discover Card', 
     'Discover card credit card', 
     'pay_discover.gif', 
     30, 
     19, 
     1 )\g

INSERT INTO paymentmethods
VALUES (
     8, 
     'MasterCard', 
     'MasterCard credit card', 
     'pay_master.gif', 
     30, 
     20, 
     1 )\g

INSERT INTO paymentmethods
VALUES (
     9, 
     'Visa', 
     'Visa credit card', 
     'pay_visa.gif', 
     30, 
     19, 
     1 )\g


CREATE TABLE personalization
     (
     storeid                                                           CHAR(50) NOT NULL,
     logoimg                                                           CHAR(50),
     logow                                                             CHAR(50),
     logoh                                                             CHAR(50),
     logoalt                                                           TEXT,
     logoposition                                                      CHAR(50),
     logolinkback                                                      CHAR(50),
     logolinkvisible                                                   CHAR(50),
     headerimg                                                         CHAR(50),
     headerw                                                           CHAR(50),
     headerh                                                           CHAR(50),
     headeralt                                                         TEXT,
     headerposition                                                    CHAR(50),
     footerimg                                                         CHAR(50),
     footerw                                                           CHAR(50),
     footerh                                                           CHAR(50),
     footeralt                                                         TEXT,
     footerposition                                                    CHAR(50),
     footertext                                                        CHAR(50),
     bgimg                                                             CHAR(50),
     bgcolor                                                           CHAR(50),
     secondcolor                                                       CHAR(50),
     textcolor                                                         CHAR(50),
     linktype                                                          CHAR(50),
     linkcolor                                                         CHAR(50),
     alinkcolor                                                        CHAR(50),
     vlinkcolor                                                        CHAR(50),
     headerh1                                                          CHAR(50),
     headerh1font                                                      CHAR(50),
     fpaffprog                                                         TINYINT UNSIGNED,
     fpcats                                                            CHAR(50),
     fpsubcats                                                         CHAR(50),
     fpsearch                                                          CHAR(50),
     fplogin                                                           CHAR(50),
     fporders                                                          CHAR(50),
     fpprice                                                           CHAR(50),
     fpspecials                                                        CHAR(50),
     fpsales                                                           CHAR(50),
     fpintrotext                                                       TEXT,
     fpclosetext                                                       TEXT,
     fpbgimg                                                           CHAR(50),
     fpbgcolor                                                         CHAR(50),
     fptextcolor                                                       CHAR(50),
     fplinktype                                                        CHAR(50),
     fplinkcolor                                                       CHAR(50),
     fpalinkcolor                                                      CHAR(50),
     fpvlinkcolor                                                      CHAR(50),
     mpnumperpage                                                      CHAR(50),
     mpordering                                                        CHAR(50),
     mppicture                                                         CHAR(50),
     mpdescrip                                                         CHAR(50),
     mpspecials                                                        CHAR(50),
     mpdiscount                                                        CHAR(50),
     mpid                                                              CHAR(50),
     mpsearch                                                          CHAR(50),
     specialstype                                                      CHAR(50),
     specialsimg                                                       CHAR(50),
     specialsimgw                                                      CHAR(50),
     specialsimgh                                                      CHAR(50),
     mpsales                                                           CHAR(50),
     salestype                                                         CHAR(50),
     salesimg                                                          CHAR(50),
     salesimgw                                                         CHAR(50),
     salesimgh                                                         CHAR(50),
     mpprice                                                           CHAR(50),
     mpavailstock                                                      CHAR(50),
     availstocktype                                                    CHAR(50),
     instockimg                                                        CHAR(50),
     instockimgw                                                       CHAR(50),
     instockimgh                                                       CHAR(50),
     outstockimg                                                       CHAR(50),
     outstockimgw                                                      CHAR(50),
     outstockimgh                                                      CHAR(50),
     mplayoutstyle                                                     CHAR(50),
     mpoptions                                                         CHAR(50),
     spimglocation                                                     CHAR(50),
     spmissimg                                                         CHAR(50),
     splayoutstyle                                                     CHAR(50),
     imgsizetype                                                       CHAR(50),
     smallimgw                                                         CHAR(5),
     smallimgh                                                         CHAR(5),
     medimgw                                                           CHAR(5),
     medimgh                                                           CHAR(5),
     largeimgw                                                         CHAR(5),
     largeimgh                                                         CHAR(5),
     discountmessage                                                   TEXT,
     fplfimg                                                           CHAR(20),
     fprtimg                                                           CHAR(20),
     templatenumber                                                    INT,
     buttonsnumber                                                     INT,
     headcolor                                                         CHAR(6),
     catabordercolor                                                   CHAR(6),
     catacolor                                                         CHAR(6),
     searchcolor                                                       CHAR(6),
     specialcolor                                                      CHAR(6),
     affcolor                                                          CHAR(6),
     leftimgcolor                                                      CHAR(6),
     rightimgcolor                                                     CHAR(6),
     bottomcolor                                                       CHAR(6),
     hotcolor                                                          CHAR(6),
     specialimgcolor                                                   CHAR(6),
     morespecialcolor                                                  CHAR(6),
     buttontype                                                        INT,
     buttonimgnumber                                                   INT,
     buttonnumber                                                      INT,
     buttonbordercolor                                                 CHAR(6),
     buttonbgcolor                                                     CHAR(6),
     buttontextcolor                                                   CHAR(6),
     tsptype                                                           INT,
     tsptextcolor                                                      CHAR(6),
     spDescrip                                                         CHAR(3),
     onspcolor                                                         CHAR(6),
     smptype                                                           INT,
     smptext                                                           CHAR(50),
     smpbgcolor                                                        CHAR(6),
     smptextcolor                                                      CHAR(6),
     introtextcolor                                                    CHAR(6),
     fpshort                                                           CHAR(3),
     tsptext                                                           CHAR(50),
     singleprice                                                       CHAR(3),
     singlediscount                                                    CHAR(3),
     singlestock                                                       CHAR(3),
     singlesearch                                                      CHAR(3),
     singleshowspimg                                                   CHAR(7),
     singleproddesc                                                    CHAR(5),
     singleprodnumber                                                  CHAR(1),
     multshowspdesc                                                    CHAR(3),
     multimgposition                                                   CHAR(5),
     KEY (storeid),
     PRIMARY KEY (storeid)
     )\g

INSERT INTO personalization
VALUES (
     '1', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     'headerimg.gif', 
     '777', 
     '67', 
     'My Shop', 
     'center', 
     'footerimg.gif', 
     '777', 
     '31', 
     '---', 
     'center', 
     NULL, 
     NULL, 
     'ecf5fe', 
     'FFFFFF', 
     '000000', 
     'regular', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     1, 
     'yes', 
     'yes', 
     'yes', 
     'yes', 
     'yes', 
     'yes', 
     'yes', 
     'yes', 
     'Welcome to our online store.', 
     'Questions, comments?  Please email us at mailLink.', 
     NULL, 
     'ecf5fe', 
     '000000', 
     'regular', 
     '208FFF', 
     'FF0000', 
     'CC33CC', 
     '10', 
     'no', 
     'yes', 
     'short', 
     'picture', 
     'yes', 
     '1', 
     'yes', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     'yes', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     'yes', 
     'yes', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     '1', 
     'off', 
     'left', 
     'no', 
     '1', 
     '0', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     'For a limited time only', 
     'fplfimg.jpg', 
     'fprtimg.gif', 
     0, 
     1, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     0, 
     1, 
     1, 
     '000000', 
     '7E4E00', 
     'FFFFFF', 
     0, 
     NULL, 
     'yes', 
     'ff0000', 
     0, 
     'More Products', 
     '000000', 
     'ffffff', 
     'ff0000', 
     'yes', 
     'Today Specials', 
     'yes', 
     'yes', 
     'yes', 
     'yes', 
     'picture', 
     'long', 
     '0', 
     'no', 
     'left' )\g


CREATE TABLE product_option
     (
     storeid                                                           CHAR(50) NOT NULL,
     deptid                                                            CHAR(50) NOT NULL,
     groupid                                                           CHAR(50) NOT NULL,
     prodid                                                            CHAR(50) NOT NULL,
     optid                                                             INT NOT NULL,
     opttitle                                                          CHAR(50),
     KEY (storeid, deptid, groupid, prodid),
     KEY (deptid),
     KEY (groupid),
     KEY (optid),
     PRIMARY KEY (storeid, deptid, groupid, prodid, optid),
     KEY (prodid),
     KEY (storeid)
     )\g

# This table has no data

CREATE TABLE products
     (
     storeid                                                           CHAR(50) NOT NULL,
     deptid                                                            CHAR(50) NOT NULL,
     groupid                                                           CHAR(50) NOT NULL,
     prodid                                                            CHAR(50) NOT NULL,
     prodtitle                                                         CHAR(255) NOT NULL,
     proddesc1                                                         CHAR(255),
     proddesc2                                                         TEXT,
     proddesc3                                                         TEXT,
     price                                                             REAL,
     onspecial                                                         SMALLINT,
     typeid                                                            CHAR(50),
     weight                                                            FLOAT,
     imgsml                                                            CHAR(50),
     imgsmlwidth                                                       SMALLINT,
     imgsmlheight                                                      SMALLINT,
     imgsmlparams                                                      CHAR(150),
     imgstd                                                            CHAR(50),
     imgstdwidth                                                       SMALLINT,
     imgstdheight                                                      SMALLINT,
     imgstdparams                                                      CHAR(150),
     imglrg                                                            CHAR(50),
     imglrgwidth                                                       SMALLINT,
     imglrgheight                                                      SMALLINT,
     imglrgparams                                                      CHAR(150),
     taxable                                                           SMALLINT NOT NULL,
     stockcurrent                                                      INT,
     stockmax                                                          INT,
     stockmin                                                          INT,
     active                                                            SMALLINT,
     datecreated                                                       DATETIME,
     discid                                                            INT,
     download                                                          SMALLINT,
     downloadurl                                                       CHAR(50),
     KEY (storeid, deptid, groupid),
     KEY (deptid),
     KEY (groupid),
     PRIMARY KEY (storeid, deptid, groupid, prodid),
     KEY (prodid),
     KEY (prodtitle),
     KEY (storeid)
     )\g

# This table has no data

CREATE TABLE shipmethods
     (
     shipmethod_id                                                     SMALLINT NOT NULL,
     name                                                              CHAR(50) NOT NULL,
     description                                                       CHAR(255) NOT NULL,
     countryid                                                         SMALLINT,
     active                                                            SMALLINT,
     PRIMARY KEY (shipmethod_id)
     )\g

INSERT INTO shipmethods
VALUES (
     1, 
     'UPS', 
     'United Parcel Service', 
     0, 
     1 )\g

INSERT INTO shipmethods
VALUES (
     2, 
     'USPS', 
     'United States Postal Service', 
     0, 
     1 )\g

INSERT INTO shipmethods
VALUES (
     3, 
     'FedEx', 
     'Federal Express', 
     0, 
     1 )\g


CREATE TABLE shiprate
     (
     shiprate_id                                                       INT NOT NULL DEFAULT 0,
     name                                                              CHAR(50),
     description                                                       CHAR(100),
     active                                                            SMALLINT,
     PRIMARY KEY (shiprate_id),
     KEY (shiprate_id)
     )\g

INSERT INTO shiprate
VALUES (
     1, 
     'None', 
     'No charge for shipping', 
     1 )\g

INSERT INTO shiprate
VALUES (
     2, 
     'Flatfee', 
     'Same charge for all orders', 
     1 )\g

INSERT INTO shiprate
VALUES (
     3, 
     'Percentage', 
     'Charge based on order cost', 
     1 )\g

INSERT INTO shiprate
VALUES (
     4, 
     'Tier', 
     'Cost increases based on weight or cost', 
     1 )\g

INSERT INTO shiprate
VALUES (
     5, 
     'Major Shippers', 
     'Use major shipppers such as UPS or U.S. Postal Service', 
     1 )\g


CREATE TABLE state
     (
     stateid                                                           CHAR(2) NOT NULL,
     statename                                                         CHAR(50),
     PRIMARY KEY (stateid),
     KEY (stateid)
     )\g

INSERT INTO state VALUES ('0', NULL)\g
INSERT INTO state VALUES ('AK', 'Alaska')\g
INSERT INTO state VALUES ('AL', 'Alabama')\g
INSERT INTO state VALUES ('AR', 'Arkansas')\g
INSERT INTO state VALUES ('AZ', 'Arizona')\g
INSERT INTO state VALUES ('CA', 'California')\g
INSERT INTO state VALUES ('CO', 'Colorado')\g
INSERT INTO state VALUES ('CT', 'Connecticut')\g
INSERT INTO state VALUES ('DC', 'District of Columbia')\g
INSERT INTO state VALUES ('DE', 'Delaware')\g
INSERT INTO state VALUES ('FL', 'Florida')\g
INSERT INTO state VALUES ('GA', 'Georgia')\g
INSERT INTO state VALUES ('HI', 'Hawaii')\g
INSERT INTO state VALUES ('IA', 'Iowa')\g
INSERT INTO state VALUES ('ID', 'Idaho')\g
INSERT INTO state VALUES ('IL', 'Illinois')\g
INSERT INTO state VALUES ('IN', 'Indiana')\g
INSERT INTO state VALUES ('KS', 'Kansas')\g
INSERT INTO state VALUES ('KY', 'Kentucky')\g
INSERT INTO state VALUES ('LA', 'Louisiana')\g
INSERT INTO state VALUES ('MA', 'Massachusetts')\g
INSERT INTO state VALUES ('MD', 'Maryland')\g
INSERT INTO state VALUES ('ME', 'Maine')\g
INSERT INTO state VALUES ('MI', 'Michigan')\g
INSERT INTO state VALUES ('MN', 'Minnesota')\g
INSERT INTO state VALUES ('MO', 'Missouri')\g
INSERT INTO state VALUES ('MS', 'Mississippi')\g
INSERT INTO state VALUES ('MT', 'Montana')\g
INSERT INTO state VALUES ('NC', 'North Carolina')\g
INSERT INTO state VALUES ('ND', 'North Dakota')\g
INSERT INTO state VALUES ('NE', 'Nebraska')\g
INSERT INTO state VALUES ('NH', 'New Hampshire')\g
INSERT INTO state VALUES ('NJ', 'New Jersey')\g
INSERT INTO state VALUES ('NM', 'New Mexico')\g
INSERT INTO state VALUES ('NV', 'Nevada')\g
INSERT INTO state VALUES ('NY', 'New York')\g
INSERT INTO state VALUES ('OH', 'Ohio')\g
INSERT INTO state VALUES ('OK', 'Oklahoma')\g
INSERT INTO state VALUES ('OR', 'Oregon')\g
INSERT INTO state VALUES ('PA', 'Pennsylvania')\g
INSERT INTO state VALUES ('RI', 'Rhode Island')\g
INSERT INTO state VALUES ('SC', 'South Carolina')\g
INSERT INTO state VALUES ('SD', 'South Dakota')\g
INSERT INTO state VALUES ('TN', 'Tennessee')\g
INSERT INTO state VALUES ('TX', 'Texas')\g
INSERT INTO state VALUES ('UT', 'Utah')\g
INSERT INTO state VALUES ('VA', 'Virginia')\g
INSERT INTO state VALUES ('VT', 'Vermont')\g
INSERT INTO state VALUES ('WA', 'Washington')\g
INSERT INTO state VALUES ('WI', 'Wisconsin')\g
INSERT INTO state VALUES ('WV', 'West Virginia')\g
INSERT INTO state VALUES ('WY', 'Wyoming')\g

CREATE TABLE store_payment
     (
     storeid                                                           CHAR(50) NOT NULL,
     paymethod_id                                                      SMALLINT NOT NULL,
     KEY (paymethod_id),
     KEY (storeid),
     KEY (storeid),
     KEY (paymethod_id),
     PRIMARY KEY (storeid, paymethod_id)
     )\g

INSERT INTO store_payment VALUES ('1', 0)\g
INSERT INTO store_payment VALUES ('1', 1)\g
INSERT INTO store_payment VALUES ('1', 2)\g
INSERT INTO store_payment VALUES ('1', 3)\g
INSERT INTO store_payment VALUES ('1', 4)\g
INSERT INTO store_payment VALUES ('1', 5)\g
INSERT INTO store_payment VALUES ('1', 6)\g
INSERT INTO store_payment VALUES ('1', 7)\g
INSERT INTO store_payment VALUES ('1', 8)\g
INSERT INTO store_payment VALUES ('1', 9)\g

CREATE TABLE store_shipmethod
     (
     a_id                                                              INT NOT NULL,
     shipmethod_id                                                     SMALLINT NOT NULL,
     storeid                                                           CHAR(50) NOT NULL,
     shipmethod                                                        CHAR(70) NOT NULL,
     KEY (a_id),
     KEY (storeid),
     PRIMARY KEY (a_id)
     )\g

# This table has no data

CREATE TABLE store_shiprate
     (
     a_id                                                              INT NOT NULL,
     shiprate_id                                                       INT NOT NULL,
     storeid                                                           CHAR(50) NOT NULL,
     shiprate                                                          CHAR(70) NOT NULL,
     flatfee                                                           FLOAT,
     percentagefee                                                     FLOAT,
     tiertype                                                          CHAR(50),
     KEY (a_id),
     PRIMARY KEY (a_id),
     KEY (storeid)
     )\g

INSERT INTO store_shiprate
VALUES (
     1, 
     1, 
     '1', 
     'None', 
     0, 
     0, 
     NULL )\g


CREATE TABLE store_shiptiers
     (
     shiptierid                                                        INT NOT NULL,
     storeid                                                           CHAR(50) NOT NULL,
     min_range                                                         FLOAT,
     max_range                                                         FLOAT NOT NULL,
     rate                                                              FLOAT,
     tiertype                                                          CHAR(50),
     KEY (storeid),
     PRIMARY KEY (shiptierid),
     KEY (shiptierid),
     KEY (storeid)
     )\g

# This table has no data

CREATE TABLE store_tax
     (
     storeid                                                           CHAR(50) NOT NULL,
     taxcountry                                                        CHAR(2) NOT NULL,
     taxstate                                                          CHAR(50) NOT NULL,
     taxzip                                                            CHAR(10) NOT NULL,
     taxrate                                                           FLOAT,
     KEY (taxcountry),
     KEY (storeid),
     KEY (taxstate),
     PRIMARY KEY (storeid, taxcountry, taxstate, taxzip),
     KEY (storeid)
     )\g

# This table has no data

CREATE TABLE stores
     (
     storeid                                                           CHAR(50) NOT NULL,
     storename                                                         CHAR(20) NOT NULL,
     addr1                                                             CHAR(90),
     addr2                                                             CHAR(90),
     city                                                              CHAR(50),
     province                                                          CHAR(50),
     postalcode                                                        CHAR(50),
     countryid                                                         CHAR(2),
     phone                                                             CHAR(20),
     fax                                                               CHAR(20),
     email                                                             CHAR(100),
     trackstock                                                        SMALLINT,
     showstocklevel                                                    SMALLINT,
     datecreated                                                       DATETIME,
     active                                                            SMALLINT,
     adminemailenable                                                  SMALLINT,
     verification_id                                                   INT NOT NULL DEFAULT 0,
     productsallowed                                                   INT NOT NULL DEFAULT 0,
     allow_disc                                                        TINYINT UNSIGNED,
     track_bonus                                                       TINYINT UNSIGNED,
     allow_bonus                                                       TINYINT UNSIGNED,
     bonus_val                                                         INT,
     bonus_limit                                                       INT,
     PRIMARY KEY (storeid),
     KEY (storeid)
     )\g

INSERT INTO stores
VALUES (
     '1', 
     'My Store', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     1, 
     1, 
     '2000-10-31 00:00:00', 
     1, 
     1, 
     0, 
     1000000, 
     0, 
     0, 
     0, 
     NULL, 
     NULL )\g


CREATE TABLE temporders
     (
     orderid                                                           INT NOT NULL,
     storeid                                                           CHAR(50) NOT NULL,
     orderdate                                                         DATETIME,
     KEY (orderid),
     PRIMARY KEY (orderid)
     )\g

INSERT INTO temporders VALUES (1, '1', '2003-07-17 09:18:33')\g

CREATE TABLE transactions
     (
     id                                                                INT NOT NULL,
     proc_date                                                         DATETIME,
     mid                                                               CHAR(50),
     aid                                                               CHAR(50),
     price                                                             REAL,
     commission                                                        REAL,
     discount                                                          REAL,
     orderid                                                           INT,
     status                                                            CHAR(50),
     KEY (aid),
     PRIMARY KEY (id),
     KEY (mid),
     KEY (orderid)
     )\g

# This table has no data

CREATE TABLE user_group
     (
     userid                                                            INT NOT NULL,
     usergrpid                                                         SMALLINT NOT NULL,
     KEY (usergrpid),
     KEY (userid),
     PRIMARY KEY (userid, usergrpid),
     KEY (userid),
     KEY (usergrpid)
     )\g

INSERT INTO user_group VALUES (1, 1)\g
INSERT INTO user_group VALUES (2, 3)\g

CREATE TABLE user_store
     (
     userid                                                            INT NOT NULL,
     storeid                                                           CHAR(50) NOT NULL,
     KEY (storeid),
     KEY (userid),
     PRIMARY KEY (userid, storeid),
     KEY (storeid)
     )\g

INSERT INTO user_store VALUES (2, '1')\g

CREATE TABLE usergroups
     (
     usergrpid                                                         SMALLINT NOT NULL,
     usergrpname                                                       CHAR(50),
     usergrpdesc                                                       CHAR(255),
     datecreated                                                       DATETIME,
     KEY (usergrpid),
     PRIMARY KEY (usergrpid)
     )\g

INSERT INTO usergroups
VALUES (
     1, 
     'malladmin', 
     NULL, 
     '1995-12-15 14:35:34' )\g

INSERT INTO usergroups
VALUES (
     2, 
     'customers', 
     NULL, 
     '1995-12-15 14:35:50' )\g

INSERT INTO usergroups
VALUES (
     3, 
     'storeadmin', 
     NULL, 
     '1998-03-12 18:59:49' )\g


CREATE TABLE users
     (
     userid                                                            INT NOT NULL,
     datecreated                                                       DATETIME,
     username                                                          CHAR(20),
     userpw                                                            CHAR(20),
     userpwtip                                                         CHAR(50),
     namefirst                                                         CHAR(50),
     namemi                                                            CHAR(20),
     namelast                                                          CHAR(50),
     billcompanyname                                                   CHAR(50),
     billname                                                          CHAR(50),
     billaddr1                                                         CHAR(50),
     billaddr2                                                         CHAR(50),
     billcity                                                          CHAR(50),
     billprovince                                                      CHAR(50),
     billpostalcode                                                    CHAR(50),
     billcountryid                                                     CHAR(2),
     billphone                                                         CHAR(50),
     billfax                                                           CHAR(20),
     shipcompanyname                                                   CHAR(50),
     billemail                                                         CHAR(100),
     billemailenable                                                   SMALLINT,
     shipname                                                          CHAR(50),
     namefirst2                                                        CHAR(25),
     namelast2                                                         CHAR(25),
     shipaddr1                                                         CHAR(50),
     shipaddr2                                                         CHAR(50),
     shipsuite                                                         CHAR(50),
     shipcity                                                          CHAR(50),
     shipprovince                                                      CHAR(50),
     shippostalcode                                                    CHAR(50),
     shipcountryid                                                     CHAR(2),
     shipphone                                                         CHAR(50),
     shipfax                                                           CHAR(20),
     shipemail                                                         CHAR(100),
     shipemailenable                                                   SMALLINT,
     activate                                                          SMALLINT,
     discountrate                                                      INT,
     bonuspoint                                                        INT,
     notes                                                             TEXT,
     KEY (userid),
     PRIMARY KEY (userid)
     )\g

INSERT INTO users
VALUES (
     1, 
     NULL, 
     'malladmin', 
     'password', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     1, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     0, 
     1, 
     0, 
     0, 
     NULL )\g

INSERT INTO users
VALUES (
     2, 
     NULL, 
     'storeadmin', 
     'password', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     1, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     1, 
     0, 
     0, 
     NULL )\g


CREATE TABLE webpadbannercompanies
     (
     storeid                                                           CHAR(50) NOT NULL,
     companyid                                                         INT NOT NULL DEFAULT 0,
     PRIMARY KEY (storeid),
     KEY (storeid)
     )\g

# This table has no data
