

CREATE TABLE Addresses
     (
     AddressID            INT NOT NULL AUTO_INCREMENT,
     FirstName            CHAR(50),
     LastName             CHAR(50) NOT NULL,
     SpouseName           CHAR(50),
     ChildrenNames        CHAR(255),
     Address              CHAR(255),
     City                 CHAR(50),
     StateOrProvince      CHAR(20),
     PostalCode           CHAR(20),
     Country              CHAR(50),
     EmailAddress         CHAR(50),
     HomePhone            CHAR(30),
     WorkPhone            CHAR(30),
     WorkExtension        CHAR(20),
     MobilePhone          CHAR(30),
     FaxNumber            CHAR(30),
     Birthdate            CHAR(50),
     SendCard             TINYINT,
     DateLastTalkedTo     CHAR(50),
     DateUpdated          CHAR(50),
     Nickname             CHAR(30),
     Notes                LONGBLOB,
     Hobbies              CHAR(255),
     HealthIssues         CHAR(255),
     KEY (LastName),
     PRIMARY KEY (AddressID)
     )\g

INSERT INTO Addresses
VALUES (
     1, 
     'Nancy', 
     'Davolio', 
     'Paul', 
     'Daniel, Jean', 
     '507 - 20th Ave. E.Apt. 2A', 
     'Seattle', 
     'WA', 
     '98122', 
     'USA', 
     'nancyd@anywhere.com', 
     '(504) 555-9857', 
     '(504) 555-9922', 
     NULL, 
     '(504) 555-8822', 
     '(504) 555-7722', 
     '8/4/72', 
     0, 
     '1/2/94', 
     '1/23/94', 
     '', 
     '', 
     'Drinking white wine while composing music', 
     '' )\g

INSERT INTO Addresses
VALUES (
     2, 
     'Andrew', 
     'Fuller', 
     'Anne', 
     'Paula, John, Helen', 
     '908 W. Capital Way', 
     'Tacoma', 
     'WA', 
     '98401', 
     'USA', 
     'andrewf@anywhere.com', 
     '(504) 555-9482', 
     '(504) 555-9933', 
     NULL, 
     '(504) 555-8833', 
     '(504) 555-7733', 
     '6/17/61', 
     0, 
     '1/23/95', 
     '2/1/95', 
     NULL, 
     NULL, 
     'Rollerblading, painting', 
     'Diabetes' )\g

INSERT INTO Addresses
VALUES (
     3, 
     'Janet', 
     'Leverling', 
     'Robert', 
     NULL, 
     '722 Moss Bay Blvd.', 
     'Kirkland', 
     'WA', 
     '98033', 
     'USA', 
     'janetl@anywhere.com', 
     '(504) 555-3412', 
     '(504) 555-9944', 
     NULL, 
     '(504) 555-8844', 
     '(504) 555-7744', 
     '7/14/65', 
     1, 
     '12/23/94', 
     '1/24/95', 
     NULL, 
     NULL, 
     'Crocheting, bicycling', 
     NULL )\g

INSERT INTO Addresses
VALUES (
     4, 
     'Margaret', 
     'Peacock', 
     'Michael', 
     'Laura', 
     '4110 Old Redmond Rd.', 
     'Redmond', 
     'WA', 
     '98052', 
     'USA', 
     'bob@any.com', 
     '(504) 555-8122', 
     '(504) 555-9955', 
     NULL, 
     '(504) 555-8855', 
     '(504) 555-7755', 
     '7/14/65', 
     1, 
     '6/17/94', 
     '1/23/94', 
     NULL, 
     NULL, 
     'Mountain climbing, hiking', 
     'Asthma' )\g

INSERT INTO Addresses
VALUES (
     5, 
     'Steven', 
     'Buchanan', 
     NULL, 
     NULL, 
     '14 Garrett Hill', 
     'London', 
     NULL, 
     'SW1 8JR', 
     'UK', 
     'steveb@anywhere.com', 
     '(71) 555-4848', 
     '(71) 555-5858', 
     NULL, 
     NULL, 
     NULL, 
     '8/12/70', 
     0, 
     '11/25/94', 
     '2/1/95', 
     NULL, 
     NULL, 
     'Ice skating, jogging', 
     NULL )\g

INSERT INTO Addresses
VALUES (
     38, 
     'Susan', 
     'Lee', 
     NULL, 
     NULL, 
     '143 Main Street', 
     'Washington, D.C.', 
     NULL, 
     '10001', 
     'USA', 
     'susan@is.csc.com', 
     '202-565-5656', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     0, 
     NULL, 
     NULL, 
     'sue', 
     NULL, 
     'Swimming, Playing BasketBall', 
     'Excellent' )\g


CREATE TABLE Chart
     (
     ID                   INT NOT NULL AUTO_INCREMENT,
     Year                 INT,
     Sales                INT,
     Profit               INT,
     KEY (ID),
     PRIMARY KEY (ID)
     )\g

INSERT INTO Chart
VALUES (
     2, 
     1994, 
     15, 
     5 )\g

INSERT INTO Chart
VALUES (
     3, 
     1995, 
     20, 
     10 )\g

INSERT INTO Chart
VALUES (
     4, 
     1996, 
     5, 
     5 )\g

INSERT INTO Chart
VALUES (
     5, 
     1997, 
     30, 
     20 )\g

INSERT INTO Chart
VALUES (
     6, 
     1998, 
     35, 
     25 )\g

INSERT INTO Chart
VALUES (
     7, 
     1999, 
     40, 
     30 )\g

INSERT INTO Chart
VALUES (
     8, 
     2000, 
     45, 
     40 )\g

INSERT INTO Chart
VALUES (
     9, 
     1993, 
     5, 
     5 )\g

INSERT INTO Chart
VALUES (
     10, 
     1992, 
     6, 
     8 )\g

INSERT INTO Chart
VALUES (
     1, 
     1991, 
     5, 
     5 )\g

INSERT INTO Chart
VALUES (
     11, 
     1990, 
     2, 
     2 )\g


CREATE TABLE Factors
     (
     TypeID               INT NOT NULL DEFAULT 0,
     UnitID               INT NOT NULL DEFAULT 0,
     Unit                 CHAR(50),
     Abbr                 CHAR(10),
     Factor               REAL NOT NULL DEFAULT 0,
     PRIMARY KEY (TypeID, UnitID),
     KEY (UnitID)
     )\g

INSERT INTO Factors
VALUES (
     1, 
     10, 
     'US dollars', 
     'US $', 
     1 )\g

INSERT INTO Factors
VALUES (
     1, 
     20, 
     'HK dollars', 
     'HK $', 
     0.128000006079674 )\g

INSERT INTO Factors
VALUES (
     1, 
     30, 
     'British pounds', 
     'L', 
     2 )\g

INSERT INTO Factors
VALUES (
     1, 
     40, 
     'yen', 
     'Y', 
     9.99999977648258E-03 )\g

INSERT INTO Factors
VALUES (
     1, 
     50, 
     'renmingbi', 
     'Y RMB', 
     0.125 )\g

INSERT INTO Factors
VALUES (
     2, 
     10, 
     'inches', 
     'in', 
     0.0254 )\g

INSERT INTO Factors
VALUES (
     2, 
     20, 
     'feet', 
     'ft', 
     0.3048 )\g

INSERT INTO Factors
VALUES (
     2, 
     30, 
     'yards', 
     'yds', 
     0.9144 )\g

INSERT INTO Factors
VALUES (
     2, 
     40, 
     'fathoms', 
     'fathoms', 
     1.8288 )\g

INSERT INTO Factors
VALUES (
     2, 
     50, 
     'furlongs', 
     'furlongs', 
     201.168 )\g

INSERT INTO Factors
VALUES (
     2, 
     60, 
     'miles', 
     'mi', 
     1609.344 )\g

INSERT INTO Factors
VALUES (
     2, 
     70, 
     'nautical miles', 
     'naut mi', 
     1852 )\g

INSERT INTO Factors
VALUES (
     2, 
     80, 
     'millimeters', 
     'mm', 
     0.001 )\g

INSERT INTO Factors
VALUES (
     2, 
     90, 
     'centimeters', 
     'cm', 
     0.01 )\g

INSERT INTO Factors
VALUES (
     2, 
     100, 
     'meters', 
     'm', 
     1 )\g

INSERT INTO Factors
VALUES (
     2, 
     110, 
     'kilometers', 
     'km', 
     1000 )\g

INSERT INTO Factors
VALUES (
     5, 
     10, 
     'watts', 
     'W', 
     1 )\g

INSERT INTO Factors
VALUES (
     5, 
     20, 
     'kilowatts', 
     'kW', 
     1000 )\g

INSERT INTO Factors
VALUES (
     5, 
     30, 
     'horsepower', 
     'hP', 
     745.700012207031 )\g

INSERT INTO Factors
VALUES (
     6, 
     10, 
     'torr', 
     'torr', 
     1 )\g

INSERT INTO Factors
VALUES (
     6, 
     20, 
     'millimeters of mercury', 
     'mm Hg', 
     1 )\g

INSERT INTO Factors
VALUES (
     6, 
     30, 
     'atmospheres', 
     'atm', 
     760 )\g

INSERT INTO Factors
VALUES (
     6, 
     40, 
     'feet of water', 
     'ft H2O', 
     22.3740005493164 )\g

INSERT INTO Factors
VALUES (
     6, 
     50, 
     'inches of mercury', 
     'in Hg', 
     25.3999996185303 )\g

INSERT INTO Factors
VALUES (
     6, 
     60, 
     'pascals', 
     'Pa', 
     7.49999983236194E-03 )\g

INSERT INTO Factors
VALUES (
     6, 
     70, 
     'kilopascals', 
     'kPa', 
     7.5 )\g

INSERT INTO Factors
VALUES (
     6, 
     80, 
     'pounds / square inch', 
     'psi', 
     51.7200012207031 )\g

INSERT INTO Factors
VALUES (
     7, 
     10, 
     'feet / second', 
     'ft / s', 
     1 )\g

INSERT INTO Factors
VALUES (
     7, 
     20, 
     'meters / second', 
     'm / s', 
     3.28083300590515 )\g

INSERT INTO Factors
VALUES (
     7, 
     30, 
     'miles / hour', 
     'mph', 
     1.46666669845581 )\g

INSERT INTO Factors
VALUES (
     7, 
     40, 
     'kilometers / hour', 
     'kph', 
     1.18110001087189 )\g

INSERT INTO Factors
VALUES (
     7, 
     50, 
     'nautical miles / hour', 
     'knots', 
     2.18741989135742 )\g

INSERT INTO Factors
VALUES (
     7, 
     60, 
     '(speed of light)', 
     'c', 
     984249920 )\g

INSERT INTO Factors
VALUES (
     7, 
     70, 
     'furlongs / fortnight', 
     'fpf', 
     5.46855560969561E-04 )\g

INSERT INTO Factors
VALUES (
     8, 
     10, 
     'cubic feet', 
     'ft^3', 
     28316.847 )\g

INSERT INTO Factors
VALUES (
     8, 
     20, 
     'cubic meters', 
     'm^3', 
     1000000 )\g

INSERT INTO Factors
VALUES (
     8, 
     30, 
     'cubic centimeters', 
     'cm^3', 
     1 )\g

INSERT INTO Factors
VALUES (
     8, 
     40, 
     'milliliters', 
     'ml', 
     1 )\g

INSERT INTO Factors
VALUES (
     8, 
     50, 
     'liters', 
     'l', 
     1000 )\g

INSERT INTO Factors
VALUES (
     8, 
     60, 
     'gallons (US)', 
     'gal', 
     3785.411784 )\g

INSERT INTO Factors
VALUES (
     8, 
     70, 
     'quarts', 
     'qt', 
     946.352946 )\g

INSERT INTO Factors
VALUES (
     8, 
     80, 
     'pints', 
     'pints', 
     473.176473 )\g

INSERT INTO Factors
VALUES (
     8, 
     90, 
     'fluid ounces', 
     'fl oz', 
     29.5735295625 )\g

INSERT INTO Factors
VALUES (
     9, 
     10, 
     'pounds', 
     'lbs', 
     0.45359237 )\g

INSERT INTO Factors
VALUES (
     9, 
     20, 
     'ounces', 
     'oz', 
     0.028349523125 )\g

INSERT INTO Factors
VALUES (
     9, 
     30, 
     'kilograms', 
     'kg', 
     1 )\g

INSERT INTO Factors
VALUES (
     9, 
     40, 
     'grams', 
     'g', 
     0.001 )\g

INSERT INTO Factors
VALUES (
     9, 
     50, 
     'milligrams', 
     'mg', 
     0.000001 )\g

INSERT INTO Factors
VALUES (
     9, 
     60, 
     'tons', 
     'tons', 
     907.18474 )\g

INSERT INTO Factors
VALUES (
     9, 
     65, 
     'long tons', 
     'long tons', 
     1016.046909 )\g

INSERT INTO Factors
VALUES (
     9, 
     70, 
     'metric tons', 
     'metric ton', 
     1000 )\g

INSERT INTO Factors
VALUES (
     9, 
     80, 
     'troy pounds', 
     'troy lbs', 
     0.3732417216 )\g

INSERT INTO Factors
VALUES (
     9, 
     90, 
     'troy ounces', 
     'troy oz', 
     0.0311034768 )\g

INSERT INTO Factors
VALUES (
     10, 
     10, 
     'square inches', 
     'in^2', 
     0.00064516 )\g

INSERT INTO Factors
VALUES (
     10, 
     20, 
     'square feet', 
     'ft^2', 
     0.09290304 )\g

INSERT INTO Factors
VALUES (
     10, 
     30, 
     'square yards', 
     'yd^2', 
     0.83612736 )\g

INSERT INTO Factors
VALUES (
     10, 
     40, 
     'acres', 
     'acres', 
     4046.8564 )\g

INSERT INTO Factors
VALUES (
     10, 
     50, 
     'square miles', 
     'mi^2', 
     2589988.11 )\g

INSERT INTO Factors
VALUES (
     10, 
     60, 
     'square centimeters', 
     'cm^2', 
     0.0001 )\g

INSERT INTO Factors
VALUES (
     10, 
     70, 
     'square meters', 
     'm^2', 
     1 )\g

INSERT INTO Factors
VALUES (
     10, 
     80, 
     'ares', 
     'ares', 
     100 )\g

INSERT INTO Factors
VALUES (
     10, 
     90, 
     'square kilometers', 
     'km^2', 
     1000000 )\g

INSERT INTO Factors
VALUES (
     11, 
     10, 
     'degrees', 
     'deg', 
     1 )\g

INSERT INTO Factors
VALUES (
     11, 
     20, 
     'radians', 
     'rad', 
     57.2957795131 )\g

INSERT INTO Factors
VALUES (
     11, 
     30, 
     'grads', 
     'grad', 
     0.9 )\g

INSERT INTO Factors
VALUES (
     11, 
     40, 
     'revolutions', 
     'rev', 
     360 )\g


CREATE TABLE TYPE
     (
     TYPEID               INT NOT NULL AUTO_INCREMENT,
     TYPE                 CHAR(50),
     KEY (TYPEID)
     )\g

INSERT INTO TYPE VALUES (1, 'CURRENCY')\g
INSERT INTO TYPE VALUES (2, 'DISTANCE')\g
INSERT INTO TYPE VALUES (3, 'FLOW RATE')\g
INSERT INTO TYPE VALUES (4, 'FORCE')\g
INSERT INTO TYPE VALUES (5, 'POWER')\g
INSERT INTO TYPE VALUES (6, 'PRESSURE')\g
INSERT INTO TYPE VALUES (7, 'SPEED')\g
INSERT INTO TYPE VALUES (8, 'VOLUME')\g
INSERT INTO TYPE VALUES (9, 'WEIGHT')\g
INSERT INTO TYPE VALUES (10, 'AREA')\g
INSERT INTO TYPE VALUES (11, 'ANGLE')\g
INSERT INTO TYPE VALUES (12, 'ROTATION')\g

CREATE TABLE Types
     (
     TypeID               INT NOT NULL AUTO_INCREMENT,
     Type                 CHAR(50),
     AbbrPrefix           TINYINT,
     Ordered              INT,
     KEY (TypeID)
     )\g

INSERT INTO Types
VALUES (
     2, 
     'distance', 
     0, 
     10 )\g

INSERT INTO Types
VALUES (
     5, 
     'power', 
     0, 
     70 )\g

INSERT INTO Types
VALUES (
     6, 
     'pressure', 
     0, 
     60 )\g

INSERT INTO Types
VALUES (
     7, 
     'speed', 
     0, 
     40 )\g

INSERT INTO Types
VALUES (
     8, 
     'volume', 
     0, 
     30 )\g

INSERT INTO Types
VALUES (
     9, 
     'weight / mass', 
     0, 
     50 )\g

INSERT INTO Types
VALUES (
     10, 
     'area', 
     0, 
     20 )\g

INSERT INTO Types
VALUES (
     11, 
     'angle', 
     0, 
     80 )\g


CREATE TABLE UNITCONV
     (
     CON_FROM             CHAR(22) NOT NULL,
     CON_TO               CHAR(22) NOT NULL,
     TYPEID               INT,
     CON_FACTOR           REAL,
     CON_FACTRO           REAL,
     FACTOR_SYM           CHAR(7),
     FACTRO_SYM           CHAR(7),
     DATE_ENTER           DATETIME,
     USE_COUNT            REAL,
     ADD_BY               CHAR(5),
     N_SER                REAL,
     F_N                  TINYINT,
     F_C                  TINYINT,
     KEY (CON_FROM),
     KEY (CON_TO)
     )\g

INSERT INTO UNITCONV
VALUES (
     'BAR', 
     'ATMOSPHERES @SEA LEVEL', 
     6, 
     0.98692, 
     1.01325, 
     'bar', 
     'atm', 
     '1993-02-23 00:00:00', 
     1, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'BAR', 
     'FEET OF WATER', 
     6, 
     33.52, 
     0.02983, 
     'bar', 
     'ftH2O', 
     '1993-02-23 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'BAR', 
     'INCHES OF MERCURY', 
     6, 
     29.53, 
     0.03386, 
     'bar', 
     'inHg', 
     '1993-02-23 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'BAR', 
     'KILOPASCALS', 
     6, 
     100, 
     0.01, 
     'bar', 
     'kPa', 
     '1993-02-23 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'BAR', 
     'POUNDS / SQUARE INCH', 
     6, 
     14.504, 
     0.06895, 
     'bar', 
     'psi', 
     '1993-02-23 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'BAR', 
     'TORR', 
     6, 
     750.06, 
     0.00133, 
     'bar', 
     'torr', 
     '1993-02-23 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'CENTIMETRES', 
     'INCHES', 
     2, 
     0.3937, 
     2.54001, 
     'cm', 
     'in', 
     NULL, 
     11, 
     'DB', 
     0, 
     0, 
     1 )\g

INSERT INTO UNITCONV
VALUES (
     'CENTIMETRES OF MERCURY', 
     'KILOPASCALS', 
     2, 
     1.3332, 
     0.75008, 
     'cmHg', 
     'kP', 
     '1993-02-23 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'CUBIC METRES', 
     'GALLONS (UK)', 
     8, 
     220, 
     0.00455, 
     'm3', 
     'gal UK', 
     '1993-02-23 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'CUBIC METRES', 
     'GALLONS (US)', 
     8, 
     264.2, 
     0.00379, 
     'm3', 
     'gal US', 
     '1993-02-23 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'CUBIC METRES', 
     'LITRES', 
     8, 
     1000, 
     0.001, 
     'm3', 
     'l', 
     '1993-02-23 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'DEGREES / SECOND', 
     'REVS / MINUTE', 
     12, 
     0.16666, 
     6.00024, 
     NULL, 
     NULL, 
     '1993-02-23 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'DEGREES, ANGULAR', 
     'RADIANS', 
     11, 
     0.01745, 
     57.30659, 
     NULL, 
     NULL, 
     '1993-02-23 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'FATHOMS', 
     'FEET', 
     2, 
     6, 
     0.1667, 
     NULL, 
     NULL, 
     NULL, 
     5, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'FATHOMS', 
     'METRES', 
     2, 
     1.8288, 
     0.5468, 
     NULL, 
     NULL, 
     NULL, 
     2, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'FEET', 
     'CENTIMETRES', 
     2, 
     30.48, 
     0.03281, 
     'ft', 
     'cm', 
     NULL, 
     12, 
     'DB', 
     0, 
     0, 
     1 )\g

INSERT INTO UNITCONV
VALUES (
     'FEET', 
     'METRES', 
     2, 
     0.3048, 
     3.2808, 
     'ft', 
     'm', 
     NULL, 
     2, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'FEET / MINUTE', 
     'CENTIMETRES / SECOND', 
     7, 
     0.508, 
     1.9685, 
     NULL, 
     NULL, 
     '1993-01-27 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'FEET / MINUTE', 
     'FEET / SECOND', 
     7, 
     0.0166, 
     60.241, 
     NULL, 
     NULL, 
     '1993-01-27 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'FEET / MINUTE', 
     'KILOMETERS / HOUR', 
     7, 
     0.0183, 
     54.6448, 
     NULL, 
     NULL, 
     '1993-01-27 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'FEET / MINUTE', 
     'METRES / MINUTE', 
     7, 
     0.3048, 
     3.2808, 
     NULL, 
     NULL, 
     '1993-01-27 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'FEET CUBIC', 
     'METRES CUBIC', 
     8, 
     0.0283, 
     35.33569, 
     'ft3', 
     'm3', 
     NULL, 
     3, 
     'DB', 
     0, 
     0, 
     1 )\g

INSERT INTO UNITCONV
VALUES (
     'FEET SQUARE', 
     'METRES SQUARE', 
     10, 
     0.0929, 
     10.7643, 
     NULL, 
     NULL, 
     NULL, 
     0, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS (IMP)', 
     'CUBIC FEET', 
     8, 
     0.16054, 
     6.22898, 
     'GAL', 
     'ft3', 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS (IMP)', 
     'CUBIC METRES', 
     8, 
     0.00455, 
     219.78022, 
     'GAL', 
     'm3', 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS (IMP)', 
     'CUBIC YARDS', 
     8, 
     0.00595, 
     168.06723, 
     'GAL', 
     'yd3', 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS (IMP)', 
     'LITRES', 
     8, 
     4.546, 
     0.21997, 
     'gal (i)', 
     'l', 
     NULL, 
     2, 
     'DB', 
     0, 
     0, 
     1 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS (IMP)', 
     'POUNDS WATER @62f', 
     8, 
     10, 
     0.1, 
     'GAL', 
     NULL, 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS (IMPERIAL)', 
     'GALLONS (US)', 
     8, 
     1.2009, 
     0.8327, 
     NULL, 
     NULL, 
     '1993-01-27 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS (US)', 
     'CUBIC CENTIMETRES', 
     8, 
     3785.4, 
     0.00026, 
     'GAL us', 
     'cm3', 
     '1993-01-27 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS (US)', 
     'CUBIC INCHES', 
     8, 
     231, 
     0.0043, 
     NULL, 
     NULL, 
     '1993-01-27 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS (US)', 
     'CUBIC METRES', 
     8, 
     0.0038, 
     263.1579, 
     NULL, 
     NULL, 
     '1993-01-27 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS (US)', 
     'GALLONS (IMPERIAL)', 
     8, 
     0.8327, 
     1.2009, 
     NULL, 
     NULL, 
     '1993-01-27 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS (US)', 
     'LITRES', 
     8, 
     3.7854, 
     0.2642, 
     NULL, 
     NULL, 
     '1993-01-27 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS (US)', 
     'POUNDS OF WATER @60F', 
     8, 
     8.328, 
     0.1201, 
     NULL, 
     NULL, 
     '1993-01-27 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS (US)', 
     'YARDS CUBIC', 
     8, 
     0.0049, 
     204.0816, 
     NULL, 
     NULL, 
     '1993-01-27 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS / MINUTE (US)', 
     'CUBIC FEET / HOUR', 
     3, 
     8.021, 
     0.12467, 
     'gpm', 
     'cfh', 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS / MINUTE (US)', 
     'CUBIC METRES / HOUR', 
     3, 
     0.22715, 
     4.40238, 
     'gpm', 
     'm3/h', 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GALLONS / MINUTE (US)', 
     'LITRES / SECOND', 
     3, 
     0.06309, 
     15.85037, 
     'gpm', 
     'l/s', 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GRAMS FORCE', 
     'NEWTONS', 
     4, 
     0.00981, 
     101.9368, 
     'gf', 
     'N', 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'GRAMS FORCE / cm', 
     'NEWTONS / METRE', 
     4, 
     98.07, 
     0.0102, 
     'g/cm3', 
     'N/m', 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'HORSEPOWER', 
     'KILOWATTS', 
     5, 
     0.7457, 
     1.34102, 
     'hp', 
     'kW', 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'HORSEPOWER', 
     'WATTS', 
     5, 
     745.7, 
     0.00134, 
     'hP', 
     'W', 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'INCHES', 
     'CENTIMETRES', 
     2, 
     2.54, 
     0.3937, 
     'in', 
     'cm', 
     NULL, 
     1, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'INCHES OF MERCURY', 
     'BARS', 
     6, 
     0.03386, 
     29.53337, 
     'inHg', 
     'bar', 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'INCHES OF MERCURY', 
     'FEET OF WATER @68 F', 
     6, 
     1.135, 
     0.88106, 
     'inHg', 
     'ftH2O', 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'INCHES OF MERCURY', 
     'INCHES OF WATER @68 F', 
     6, 
     13.62, 
     0.07342, 
     'inHg', 
     'inH2O', 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'INCHES OF MERCURY', 
     'KILOPASCALS', 
     6, 
     3.3864, 
     0.2953, 
     'inHg', 
     'kPa', 
     '1993-02-18 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'INCHES OF WATER', 
     'BARS', 
     6, 
     0.00249, 
     401.60643, 
     'inH2O', 
     'bar', 
     '1993-02-22 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'INCHES OF WATER', 
     'INCHES OF MERCURY', 
     6, 
     0.07342, 
     13.62027, 
     'inH20', 
     'inHg', 
     '1993-02-22 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'INCHES OF WATER', 
     'KILOPASCALS', 
     6, 
     0.2487, 
     4.02091, 
     'inH2O', 
     'kPa', 
     '1993-02-22 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'INCHES OF WATER', 
     'Kg FORCE / cm2', 
     6, 
     0.00255, 
     392.15686, 
     'inH2O', 
     'kg/cm2', 
     '1993-02-22 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'INCHES OF WATER', 
     'POUNDS / SQUARE INCH', 
     6, 
     0.03606, 
     27.73156, 
     'inH2O', 
     'psi', 
     '1993-02-22 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'IRISH POUNDS', 
     'STG POUNDS', 
     9, 
     1.04, 
     0.9615, 
     NULL, 
     NULL, 
     NULL, 
     2, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'IRISH POUNDS', 
     'US DOLLARS', 
     9, 
     1.65, 
     0.6061, 
     NULL, 
     NULL, 
     NULL, 
     1, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'KILOGRAMS', 
     'POUNDS', 
     9, 
     2.2046, 
     0.4536, 
     'kg', 
     'lb', 
     NULL, 
     1, 
     'DB', 
     0, 
     0, 
     1 )\g

INSERT INTO UNITCONV
VALUES (
     'KILOGRAMS FORCE', 
     'NEWTONS', 
     4, 
     9.807, 
     0.10197, 
     'kgf', 
     'N', 
     '1993-02-22 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'KILOMETRES', 
     'MILES', 
     2, 
     0.6214, 
     1.6093, 
     NULL, 
     NULL, 
     NULL, 
     1, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'KILOMETRES / HOUR', 
     'CENTIMETRES / SECOND', 
     7, 
     27.78, 
     0.036, 
     'km/h', 
     'cm/s', 
     '1993-02-22 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'KILOMETRES / HOUR', 
     'MILES / HOUR', 
     7, 
     0.6214, 
     1.60927, 
     'km/h', 
     'mph', 
     '1993-02-22 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'KILOMETRES PER SECOND', 
     'MILES PER MINUTE', 
     7, 
     37.28, 
     0.0268, 
     NULL, 
     NULL, 
     NULL, 
     1, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'KILOWATTS', 
     'HORSEPOWER', 
     5, 
     1.341, 
     0.74571, 
     'kW', 
     'hp', 
     '1993-02-23 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'KNOTS', 
     'MILES / HOUR', 
     7, 
     1.151, 
     0.86881, 
     'kn', 
     'mph', 
     '1993-02-22 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'KNOTS', 
     'MILES PER HOUR (LAND )', 
     7, 
     1.151, 
     0.8688, 
     NULL, 
     NULL, 
     NULL, 
     0, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'LITRES', 
     'CUBIC CENTIMETRES', 
     8, 
     9.99, 
     0.001, 
     NULL, 
     NULL, 
     NULL, 
     2, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'LITRES/SEC', 
     'GAL/MIN ( US )', 
     3, 
     15.85, 
     0.0631, 
     NULL, 
     NULL, 
     NULL, 
     3, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'LITRES/SEC', 
     'GAL/MIN (IMP )', 
     3, 
     13.2, 
     0.0758, 
     NULL, 
     NULL, 
     NULL, 
     1, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'METRES', 
     'FEET', 
     2, 
     3.281, 
     0.30479, 
     'm', 
     'ft', 
     '1993-02-22 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'METRES', 
     'INCHES', 
     2, 
     39.37, 
     0.0254, 
     NULL, 
     NULL, 
     NULL, 
     0, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'METRES', 
     'YARDS', 
     2, 
     1.0936, 
     0.91441, 
     'm', 
     'yd', 
     '1993-02-22 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'MILES', 
     'FEET', 
     2, 
     5280, 
     0.0002, 
     NULL, 
     NULL, 
     NULL, 
     1, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'MILES', 
     'KILOMETRES', 
     2, 
     1.6093, 
     0.62139, 
     'mi', 
     'km', 
     '1993-02-22 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'MILES', 
     'METRES', 
     2, 
     1609.3, 
     0.00062, 
     'mi', 
     'm', 
     '1993-02-22 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'MILES NAUTICAL', 
     'KILOMETRES', 
     2, 
     1.852, 
     0.54, 
     NULL, 
     NULL, 
     NULL, 
     0, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'MILES NAUTICAL', 
     'MILES ( LAND )', 
     2, 
     1.1508, 
     0.869, 
     NULL, 
     NULL, 
     NULL, 
     0, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'MILES PER HOUR', 
     'KILOMETRES PER HOUR', 
     7, 
     1.6093, 
     0.6214, 
     NULL, 
     NULL, 
     NULL, 
     3, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'MILLIMETRE', 
     'INCH', 
     2, 
     0.0394, 
     25.3807, 
     NULL, 
     NULL, 
     NULL, 
     1, 
     'DB', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'OUNCES', 
     'GRAMS', 
     9, 
     28.35, 
     0.03527, 
     'oz av', 
     'g', 
     '1993-02-22 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'PSI', 
     'METRES WATER', 
     6, 
     0.703, 
     1.42248, 
     NULL, 
     NULL, 
     NULL, 
     5, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'Database revision No', 
     'DO NOT DELETE', 
     NULL, 
     2, 
     3.1993, 
     NULL, 
     NULL, 
     '1993-03-01 00:00:00', 
     0, 
     'PS', 
     0, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'US DOLLAR', 
     'HK DOLLAR', 
     1, 
     7.8, 
     0.128, 
     '$ USD', 
     '$ HKD', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'US DOLLAR', 
     'RENMINGBI', 
     1, 
     8, 
     0.125, 
     '$ USD', 
     'Y RMB', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'US DOLLAR', 
     'YEN', 
     1, 
     100, 
     0.01, 
     '$ USD', 
     'Y', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     0, 
     0 )\g

INSERT INTO UNITCONV
VALUES (
     'US DOLLAR', 
     'BRITISH POUND', 
     1, 
     0.5, 
     2, 
     '$ USD', 
     'L', 
     NULL, 
     NULL, 
     NULL, 
     NULL, 
     0, 
     0 )\g


CREATE TABLE Users
     (
     Nbr                  INT NOT NULL AUTO_INCREMENT,
     UserName             CHAR(50),
     Password             CHAR(50),
     PRIMARY KEY (Nbr)
     )\g

INSERT INTO Users VALUES (1, 'Guest', 'Guest')\g
INSERT INTO Users VALUES (2, 'Administrator', 'Password')\g
