/*---------------------------------------------------------*/
/*                                                         */
/*   Turbo Vision 1.0                                      */
/*   Turbo Vision BGI Support Demo                         */
/*   Copyright (c) 1991 by Borland International           */
/*                                                         */
/*---------------------------------------------------------*/
/*
   Sorry, this is my first OOP (and Turbo Vision) program.
   Andrzej Resztak
   e-mail: Resztak@PLUMCS11.bitnet
 */
#define Uses_TKeys
#define Uses_TApplication
#define Uses_TEvent
#define Uses_TRect
#define Uses_TDialog
#define Uses_TButton
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TDeskTop
#define Uses_MsgBox
#define Uses_TChDirDialog
#define Uses_THistory
#define Uses_TWindow
#define Uses_TInputLine
#define Uses_TLabel
#define Uses_TSItem
#define Uses_TCheckBoxes
#define Uses_TCollection
#define Uses_TSystemError
#include <tv.h>

#include "Tvbgi.h"
#include <stdlib.h>
#include <graphics.h>
#include <string.h>
#include <strstrea.h>
#include <alloc.h>
#include <assert.h>

#include "tv2.h"
#include "prtgraph.h"
#include "BGIDEMO.H"

#if __BCPLUSPLUS__==0x0200
   #error Sorry, this program seems to not work under BC++ 2.0.
   #error I am new to OOP and Turbo Vision and don't know why.
   #error The error has nothing common with PrintBGI package.
   #error It just hangs up when (or after) choosing printer.
   #error So if you want to use it under BC++ 2.0 change code
          choosing printer.
#endif


unsigned _stklen=4096;

char pathToDrivers[MAXPATH] = "";  // Default location of *.BGI files

int _PRT__pascal TVUserPrtFunc( void far* UserPtr,
                                PRT__handleT   *handlePPtr,
                                const char far* BGIpath );

static int StdBGI;

/*================*/
TBGIApp::TBGIApp() :
/*================*/
    TProgInit( &TBGIApp::initStatusLine,
	       &TBGIApp::initMenuBar,
	       &TBGIApp::initDeskTop )
{   const char far *p=NULL;
    if (*pathToDrivers==0) p = getenv("BGIPATH");
    if ( p==NULL ) p = pathToDrivers;
    strcpy(Options.bgiPath, p);
    fexpand(Options.bgiPath);

    Options.PicWidth = 4.0;
    Options.PicHeight = 3.0;
    Options.Preview=1;
    StdBGI=Options.StdBGI=0;
    Options.PrinterNo = Options.PRTModeNo = -1;
    appDriver = DETECT;
    appMode = 0;
    if (graphAppInit(appDriver, appMode, Options.bgiPath, True) == False)
	messageBox("Cannot load graphics driver.", mfError | mfOKButton);
    PRT_LinkDrivers();
}

/*================*/
TBGIApp::~TBGIApp()
/*================*/
{
    graphAppDone();
}

/*===================*/
void TBGIApp::newWin()
/*===================*/
{
    static ushort winNum = 0;
    TWindow *p;

    TRect r(deskTop->getExtent());
    r = TRect( winNum % (deskTop->size.y-1),
	           winNum % (deskTop->size.y-1),
	           deskTop->size.x,
	           deskTop->size.y);

    char msgStr[10];
    ostrstream os( msgStr, 10 );
    os << "Window " << winNum << ends;
    p = new TWindow( r, msgStr, 0 );
    p->options |= ofTileable;
    deskTop->insert( validView(p) );
    winNum++;
}

int ScreenPreview=1;
/*========================================================================*/
void TBGIApp::doGraphics(int far Graphfunc(void far * UserPointer), void far* UserPointer)
/*========================================================================*/
{
    char errorMsg[MAXSIZE];
    ushort    maxX,maxY;
    static const int CLIP_ON=1;


   if ( Options.StdBGI )
   {  // Std. BGI driver and std. Borland example code
      suspend();
      if (graphicsStart() == False)
	   {
         resume();
	      strcpy(errorMsg,grapherrormsg(graphresult()));
	      strcat( errorMsg,"." );
	      messageBox(errorMsg, mfError | mfOKButton);
	   }
       else
	   {
	      maxX = getmaxx();
	      maxY = getmaxy();
	      outtextxy(0, (maxY - textheight("M")),
	          "Press any key to return...");
	      setviewport(0, 0, maxX - 1, (maxY - (textheight("M") + 5)), CLIP_ON);

         Graphfunc(UserPointer);

	      graphicsStop();
         resume();
	   }
   }
   else
   {
      static int   PRTdrv=DETECT,PRTmode;
      int          ReturnCode;
      unsigned     oldhelpCtx;
      PRT_LinkDrivers(); /* link drivers definitions into an executable code */
      ReturnCode=PRT_SetDriver ( Options.PrinterNo+1, Options.PRTModeNo,
                                 1000*Options.PicWidth,  1000*Options.PicHeight,
                                 PRT_INVERSE );
      if ( ReturnCode )
	        messageBox("Wrong printer or mode specified", mfError | mfOKButton);
      else
      {
         ScreenPreview=Options.Preview;
         PRT_SetOutName(Options.PrintDest);
         PRT_SetUserPrintFunc(TVUserPrtFunc);
         if ( PRTdrv==DETECT )
         {
            PRTmode=0;
            /* If you want you may not linkining in the BitImage BGI driver into the */
            /* EXE file. To do comment out following two lines. */
            PRTdrv = PRT_installuserdriver ( "BitImage", NULL );
            PRT_registerfarbgidriver ( BitImage );
            PRT_SetHaltVariable((unsigned char *)&TSystemError::ctrlBreakHit);
         }
         oldhelpCtx = helpCtx;
         helpCtx = hcGraphBuild;
         TProgram::application->statusLine->update(); // change status line
         TSystemError::ctrlBreakHit=0;     // reset break indicator
         ReturnCode = PRT_PrintBGI ( &PRTdrv,&PRTmode,Options.bgiPath,
                                     Graphfunc, UserPointer );
         helpCtx = oldhelpCtx;
         TProgram::application->statusLine->update();
         if ( ReturnCode )
	         messageBox(PRT_grapherrormsg(ReturnCode), mfError | mfOKButton);
      }
   }

}

/*-------------------------------------------------*/
void TEnumPrinter::newFocusedItem( ccIndex newItem )
/*-------------------------------------------------*/
{
   TEnumValue::newFocusedItem(newItem);
   if (EnumM!=NULL) EnumM->setModes(False);
}

/*----------------------------------------------*/
TEnumPrinter::TEnumPrinter(const TRect& bounds ):
   TEnumValue(bounds,32)
/*----------------------------------------------*/
{  int maxl=0;
    EnumM=NULL;
    TStrCollection *PrinterNames= new TStrCollection ( PRT_MaxDriver(),PRT_MaxDriver() );
    for ( int i=1; i<=PRT_MaxDriver(); i++ )
    {   const char*s;
        PRT_DriverName(i,&s);
        if ( maxl<strlen(s) ) maxl=strlen(s);
        PrinterNames->insert(newStr(s));
    }
   newList(PrinterNames,-1);
}

/*-----------------------------------------------------------------*/
TEnumMode::TEnumMode ( const TRect& bounds, const TEnumPrinter *EP ):
/*-----------------------------------------------------------------*/
   TEnumValue( bounds,32 )
{
   EnumP=EP;
   setModes(False);
};

/*------------------*/
Boolean TEnumMode::setModes(Boolean errMsg)
/*------------------*/
{  int p;
   p = EnumP->focusedItem;
    if ( p<0 || p>=PRT_MaxDriver() )
    {
       if ( errMsg )
		    messageBox("You must specify printer first", mfError | mfOKButton);
       return False;
    }
    else
    {
       int maxmode;
       PRT_MaxMode(p+1,&maxmode);
       TStrCollection *ModeNames= new TStrCollection ( maxmode+1,maxmode+1 );
       for ( int i=0; i<=maxmode; i++ )
       {   const char*s;
           PRT_ModeName(p+1,i,&s);
           ModeNames->insert(newStr(s));
       }
       newList(ModeNames,maxmode);
       return True;
    }
}

/*----------------------------------------------*/
void TEnumMode::MakeSelection()
/*----------------------------------------------*/
{
   if ( setModes(True) )
      TEnumValue::MakeSelection();
}

/*=======================*/
void TBGIApp::SetGraphOptions()
/*=======================*/
{

    TDialog *d = new TDialog(TRect(0,0,55,17), "Graph options");
    d->options |= ofCentered;

    // Buttons
    d->insert(new TButton( TRect(31,14,40,16), "~C~ancel", cmCancel, bfNormal) );
    d->insert(new TButton( TRect(10,14,19,16),"O~K~", cmOK, bfDefault) );

    // Input line, history list and label
    TInputLine *pathInput = new TInputLine( TRect(22,2,50,3), MAXPATH );
    d->insert( pathInput );
    // d->insert( new THistory(TRect(52,2,55,3), pathInput, hlSetBGIPath) );
    d->insert ( new TLabel( TRect(2,2,21,3), "~B~GI path:", pathInput ) );

    TInputLine *PrtInput = new TInputLine( TRect(22,4,50,5), MAXPATH );
    d->insert( PrtInput );
    d->insert ( new TLabel( TRect(2,4,21,5), "print ~D~estination:", PrtInput ) );

    TInput_float *Wfloat = new TInput_float(TRect(14,6,22,7),7);
    d->insert( Wfloat );
    d->insert ( new TLabel( TRect(2,6,11,7), "~W~idth:", Wfloat ) );
    TInput_float *Hfloat = new TInput_float(TRect(44,6,52,7),7);
    d->insert( Hfloat );
    d->insert ( new TLabel( TRect(32,6,41,7), "~H~eight:", Hfloat ) );

    d->insert ( new TCheckBoxes(TRect(2,8,31,9),
                new TSItem("screen pre~V~iew",NULL)) );
    d->insert ( new TCheckBoxes( TRect(2,9,31,10),
                               new TSItem("~S~tandard BGI driver",NULL) ) );

    TEnumPrinter *EP = new TEnumPrinter( TRect(16,11,50,12) );
    d->insert( EP );
    d->insert ( new TEnumArrow( TRect(50,11,51,12), "", EP ) );
    d->insert ( new TLabel( TRect(2,11,15,12), "~P~rinter type", EP ) );

    TEnumMode *EM = new TEnumMode( TRect(16,12,50,13), EP );
    d->insert( EM );
    d->insert ( new TEnumArrow( TRect(50,12,51,13), "", EM ) );
    d->insert ( new TLabel( TRect(2,12,15,13), "printer ~M~ode", EM ) );

    EP->EnumM = EM;
    EP->setData(&Options.PrinterNo);

    fexpand(Options.bgiPath);
    strcpy(Options.PrintDest,PRT_GetOutName());
    d->setData(&Options);
    d = (TDialog *) validView(d);
    if (d != NULL)
	{
      d->selectNext(True);
	   if (deskTop->execView(d) == cmOK)
	   {
	       d->getData(&Options);
	       if ( (strlen(Options.bgiPath) > 0) && (Options.bgiPath[strlen(Options.bgiPath)-1] != '\\') )
		   strcat(Options.bgiPath,"\\");
          PRT_SetOutName(Options.PrintDest);
	       if ( graphAppInit(appDriver, appMode, Options.bgiPath, True) == False )
		   messageBox("Cannot load graphics driver.", mfError | mfOKButton);
	   }
	destroy( d );
   StdBGI = Options.StdBGI;
	}
}

/*======================*/
void TBGIApp::changeDir()
/*======================*/
{
    TView *p;

    p = validView(new TChDirDialog(0, hlChangeDir));
    if (p != NULL)
	{
	deskTop->execView(p);
	destroy( p );
	}
}

/*=================*/
void TBGIApp::tile()
/*=================*/
{
    TRect r(deskTop->getExtent());
    deskTop->tile(r);
}

/*====================*/
void TBGIApp::cascade()
/*====================*/
{
    TRect r(deskTop->getExtent());
    deskTop->cascade(r);
}

/*=====================================*/
void TBGIApp::handleEvent(TEvent& event)
/*=====================================*/
{
    TApplication::handleEvent(event);
    switch (event.what)
	{
	   case evCommand:
	   switch (event.message.command)
	   {
	       case cmNewWin:
		   newWin();
		   break;
	       case cmChangeDir:
		   changeDir();
		   break;
	       case cmGraphOptions:
		   SetGraphOptions();
		   break;

         case cmReportStatus     : doGraphics(ReportStatus     ,&appDriver); break;
         case cmBar3DDemo        : doGraphics(Bar3DDemo        ,NULL); break;
         case cmRandomBars       : doGraphics(RandomBars       ,NULL); break;
         case cmColorDemo        : doGraphics(ColorDemo        ,NULL); break;
         case cmArcDemo          : doGraphics(ArcDemo          ,NULL); break;
         case cmCircleDemo       : doGraphics(CircleDemo       ,NULL); break;
         case cmPieDemo          : doGraphics(PieDemo          ,NULL); break;
         case cmBarDemo          : doGraphics(BarDemo          ,NULL); break;
         case cmLineRelDemo      : doGraphics(LineRelDemo      ,NULL); break;
         case cmPutPixelDemo     : doGraphics(PutPixelDemo     ,NULL); break;
         case cmPutImageDemo     : doGraphics(PutImageDemo     ,NULL); break;
         case cmLineToDemo       : doGraphics(LineToDemo       ,NULL); break;
         case cmLineStyleDemo    : doGraphics(LineStyleDemo    ,NULL); break;
         case cmUserLineStyleDemo: doGraphics(UserLineStyleDemo,NULL); break;
         case cmFillStyleDemo    : doGraphics(FillStyleDemo    ,NULL); break;
         case cmFillPatternDemo  : doGraphics(FillPatternDemo  ,NULL); break;
         case cmPolyDemo         : doGraphics(PolyDemo         ,NULL); break;

	       case cmTile:
		   tile();
		   break;
	       case cmCascade:
		   cascade();
		   break;
	       default :
		   return;

	   }
	   break;
	   default:
	       return;
	}
   clearEvent(event);
}

/*=====================================*/
TMenuBar *TBGIApp::initMenuBar(TRect r)
/*=====================================*/
{

    r.b.y = r.a.y + 1;

    return new TMenuBar( r,
       *new TSubMenu( "~T~est", hcNoContext ) +
	//*new TMenuItem( "~B~GI settings...", 0, kbNoKey, hcNoContext ) +
	*new TMenuItem( "~G~raph options...", cmGraphOptions,kbNoKey, hcNoContext ) +
	     newLine() +
	*new TMenuItem( "~C~hange dir...", cmChangeDir, kbNoKey, hcNoContext ) +
	*new TMenuItem( "E~x~it", cmQuit, kbAltX, hcNoContext, "Alt-X" ) +
   *new TSubMenu( "~G~raph", hcNoContext ) +
      *new TMenuItem( "ReportStatus     ", cmReportStatus     ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "Bar3DDemo        ", cmBar3DDemo        ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "RandomBars       ", cmRandomBars       ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "ColorDemo        ", cmColorDemo        ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "ArcDemo          ", cmArcDemo          ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "CircleDemo       ", cmCircleDemo       ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "PieDemo          ", cmPieDemo          ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "BarDemo          ", cmBarDemo          ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "LineRelDemo      ", cmLineRelDemo      ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "PutPixelDemo     ", cmPutPixelDemo     ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "PutImageDemo     ", cmPutImageDemo     ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "LineToDemo       ", cmLineToDemo       ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "LineStyleDemo    ", cmLineStyleDemo    ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "UserLineStyleDemo", cmUserLineStyleDemo,kbNoKey, hcNoContext ) +
      *new TMenuItem( "FillStyleDemo    ", cmFillStyleDemo    ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "FillPatternDemo  ", cmFillPatternDemo  ,kbNoKey, hcNoContext ) +
      *new TMenuItem( "PolyDemo         ", cmPolyDemo         ,kbNoKey, hcNoContext ) +
	*new TSubMenu( "~W~indows", hcNoContext ) +
	*new TMenuItem( "~S~ize/move", cmResize, kbCtrlF5, hcNoContext, "Ctrl-F5" ) +
	*new TMenuItem( "~Z~oom", cmZoom, kbF5, hcNoContext, "F5" ) +
	*new TMenuItem( "~T~ile", cmTile, kbNoKey, hcNoContext ) +
	*new TMenuItem( "C~a~scade", cmCascade, kbNoKey, hcNoContext ) +
	*new TMenuItem( "~N~ext", cmNext, kbF6, hcNoContext, "F6" ) +
	*new TMenuItem( "~P~revious", cmPrev, kbShiftF6, hcNoContext, "Shift-F6" ) +
	*new TMenuItem( "~C~lose",cmClose, kbAltF3, hcNoContext, "Alt-F3" ) +
	     newLine() +
	*new TMenuItem( "Add ~w~indow", cmNewWin, kbF4, hcNoContext, "F4" )
	);

}

/*==========================================*/
TStatusLine *TBGIApp::initStatusLine(TRect r)
/*==========================================*/
{
    r.a.y = r.b.y - 1;
    return new TStatusLine( r,
	*new TStatusDef( 0, 0xFFF0 ) +
	    *new TStatusItem( "~Alt-X~ Exit", kbAltX, cmQuit ) +
	    // *new TStatusItem( "~Alt-F5~ Graph", kbAltF5, cmDoGraphics ) +
	    *new TStatusItem( 0, kbF10, cmMenu ) +
	    *new TStatusItem( 0, kbAltF3, cmClose ) +
	    *new TStatusItem( 0, kbF5, cmZoom ) +
	    *new TStatusItem( 0, kbCtrlF5, cmResize ) +
	    *new TStatusItem("", kbF6, cmNext) +
	*new TStatusDef( 0xfffe, hcGraphBuild ) +
	    *new TStatusItem( "Creating bit image map of the picture", kbAltX, cmQuit ) +
	*new TStatusDef( 0xffff, hcGraphPrint ) +
	    *new TStatusItem( "Printing picture - press Ctrl Break to stop", kbAltX, cmQuit )
	    );
}

/*========================*/
void TBGIApp::outOfMemory()
/*========================*/
{
    messageBox("Out of memory.", mfError | mfOKButton);
}


    TBGIApp bgiApp;
/*=======*/
int main()
/*=======*/
{
    assert ( heapcheck()>0 );
    assert ( heapfillfree(0x12f7)>0 );
    assert ( heapcheckfree(0x12f7)>0 );

    bgiApp.run();
    return 0;
}


/*                         */
/* CHANGETEXTSTYLE: similar to settextstyle, but checks for */
/* errors that might occur whil loading the font file.      */
/*                         */

/*========================================================*/
void changetextstyle(int font, int direction, int charsize)
/*========================================================*/
{
  int m;
  int x,y;

  graphresult();        /* clear error code     */
  if ( font == DEFAULT_FONT )
  {
      PRT_Resolution ( &x,&y );
      m = min ( y+60/120, getmaxx()/600+1 );
      if (m>1) charsize *=m;
  }
  settextstyle(font, direction, charsize);
  // grErrorTest();
}


/*==============*/
void Pause(void)
/*==============*/
{
  static char msg[] = "Esc aborts, Ctrl-P prints, other key continue ...";
  TEvent event;

  StatusLine( msg );       /* Put msg at bottom of screen   */

   if ( StdBGI )
   {
	   do
      {
	       event.getKeyEvent();
	       // if (event.what == evNothing) event.getMouseEvent();
	   } while ( event.what != evMouseDown &&  event.what != evKeyDown );
      // clearEvent(event);
   }
}



#include "BGIDEMO.INC"                                     /* A.R. */

