; Set up for call from Turbo PROLOG

CSEG	  SEGMENT   
    	  ASSUME CS:CSEG,DS:CSEG,ES:CSEG,SS:CSEG
    
PUBLIC	  getcpu_0	   ; Turbo PROLOG expects external procedures
			   ; to end with "_0"
getcpu_0  PROC FAR         ; Turbo PROLOG requires all ext procedures
			   ; to be "FAR"
       	  PUSH BP          ; Save old Base Pointer, and load Stack
       	  		   ; Pointer, so that BP can be used to 
       	  MOV BP,SP        ; address parameters
		   
; MAIN subroutine (code contributed by Juan Jimenez)

          PUSHF            ; Save the flag registers 
 	  XOR AX,AX        ; Clear AX and push it onto the stack
                           ; etc..............
	  PUSH AX
	  POPF             ; Pop 0 into flag registers (all bits to 
	                   ; 0),
	  PUSHF            ; attempting to set bits 12-15 of flags to 
	                   ; 0's
    	  POP AX           ; Recover the saved flags
          AND AX,08000h    ; If bits 12-15 of flags are set to zero 
          CMP AX,08000h    ; then cpu is 8088/86 or 80188/86
          JZ  _8x_18x

; Decide whether CPU is 80286 or 80386

          MOV  AX,07000h   ; Try to set flag bits 12-14 to 1's
          PUSH AX          ; Push the test value onto the stack
          POPF             ; Pop it into the flag register
          PUSHF            ; Push it back onto the stack
          POP  AX          ; Pop it into AX for check
          AND  AX,07000h   ; If bits 12-14 are cleared then the chip
          JZ   _286        ; is an 80286

; It's an 80386

          MOV  AX,386      ; It's not a 286, so it must be a 386
          JMP  DONE

; It's an 80286

_286:     MOV  AX,286      ; Get the msg ready
    	  JMP  DONE

; It's an 8088/86 or 80188/86

_8x_18x:
    	  MOV  AX,0ffffh   ; Set AX to all 1's
          MOV  CL,33       ; Now we try to shift left 33 times. If
    	  SHL  AX,CL       ; it's an 808x it will shift it 33 times,  
                           ; id it's an 8018x it will only shift one
                           ; time.
          JNZ _18x         ; Shifting 33 times would have left all
                           ; 0's. If any 1's are left it's an 
                           ; 80188/186
          MOV  AX,86       ; No 1's, it's an 8088/86
          JMP  DONE

; It's an 80188 or 80186

_18x:     MOV  AX,186      ; Found a 1 in there somewhere, it's an 
                           ; 80188 or an 80186

; New "DONE" gets us back to Turbo PROLOG
                           
DONE:   
    	  LDS SI,DWORD PTR [BP]+6  ; Move returned value's address
    				   ; into SI (another register which
    				   ; allows indirect addressing can
    				   ; be used
    	  MOV [SI],AX		   ; Move the value in AX (i.e. the 
    				   ; processor # to the address in SI
    	  POPF    		   ; Restore the flag registers
      	  POP BP		   ; Restore Base Pointer
    	  RET 4		           ; Return to next execution address
    	  			   ; IP and de-allocate parameters (4
    	  			   ; bytes for returned variable)

getcpu_0  ENDP
CSEG	  ENDS
END
