(*ERROR.INC
  This is the error handler for ALL the INT9 front end
  demo programs*)
TYPE
  string2 = string[2];
  string4 = string[4];

CONST
  HexDigit : ARRAY[0..15] OF Char = '0123456789ABCDEF';

  FUNCTION HexByte(B : Byte) : string2;
  BEGIN
    HexByte := HexDigit[B SHR 4]+HexDigit[B AND $F];
  END;

  FUNCTION Hex(I : Word) : string4;
  BEGIN
    Hex := HexByte(Hi(I))+HexByte(Lo(I));
  END;


{$F+}  PROCEDURE My_Error; {$F-}
  BEGIN
    SetIntVec(Kbd_Int, Kbd_vec); {restore OLD INT9}
    IF (ExitCode <> 0) OR (ErrorAddr <> NIL) THEN
      BEGIN
        Assign(Output,'');
        ReWrite(OutPut);
        WriteLn(#7);
        IF ExitCode = $FF THEN
          WriteLn('USER BREAK')
        ELSE
          BEGIN
            WriteLn('Critical Error # ',HEX(ExitCode));
            Write('AT PROGRAM LOCATION ');
            WriteLn(HEX(seg(ErrorAddr^)),':',Hex(ofs(ErrorAddr^)));
          END;
      END;
    ExitProc := Exit_Vec;        {restore previous ExitProc}
  END;
