/********************************************************************
*  C O N C A T
*
*  Concatenate files.  For each file named as an argument, CONCAT
*  writes the contents of the file to standard output.  Command-line
*  redirection may be used to collect the contents of multiple files
*  into a single file.  This program is adapted for DOS from the
*  "cat" program presented in "The C Programming Language", by
*  Kernighan and Ritchie, Prentice-Hall, 1978.  Modifications include
*  argv[0] processing for DOS and improved error handling.
*
*  Exitcodes (DOS ERRORLEVEL):
*	0	success
*	1	error opening a named file
*	2	I/O error while copying
*	3	error closing a file
********************************************************************/

#include <stdio.h>

/* function prototype */
extern int filecopy(FILE *, FILE *);

main(argc, argv)
int argc;
char *argv[];
{
    int i;		/* loop index */
    FILE *fp;		/* input file pointer */

    static char progname[] = { "CONCAT" };	/* program name */

    /*
     *  Be sure that argv[0] is a useful program name.  Under DOS 3.x
     *  and later, argv[0] is the program name.  The program name is
     *  not available under earlier versions of DOS and is presented
     *  as a null string ("") by Turbo C.
     */
    if (argv[0][0] == '\0')
        argv[0] = progname;

    /* if no filenames are given, use standard input */
    if (argc == 1) {
        if (filecopy(stdin, stdout) == EOF) {
            perror(argv[0]);	/* display the system error message */
            exit(2);
        }
    }
    else
        /* process the named files one at a time */
        for (i = 1; i < argc; ++i) {
            /* attempt to open the source file */
            fp = fopen(argv[i], "r");
            if (fp == NULL) {
                /* unable to open the file */
                fprintf(stderr, "%s: cannot open %s\n",
                    argv[0], argv[i]);
                continue;	/* look for more files */
            }
            else {
                /* copy the current file to the standard output */
                if (filecopy(fp, stdout) == EOF) {
                    perror(argv[0]);
                    exit(2);
                }
                /* close the current file */
                if (fclose(fp) == EOF) {
                    fprintf(stderr, "%s: error closing %s\n",
                        argv[0], argv[i]);
                    exit(3);
                }
            }
        }

    exit(0);
}
