/* whello.c
 */

#include<windows.h>


long FAR PASCAL WndProc(HWND, WORD, WORD, LONG);

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)
    {
    static char szAppName[] = "HelloWin";
    HWND hWnd;
    MSG msg;
    WNDCLASS wndclass;

    if(!hPrevInstance)	
        {
        wndclass.style = NULL;
        wndclass.lpfnWndProc = WndProc;
        wndclass.cbClsExtra = 0;       
        wndclass.cbWndExtra = 0;       
        wndclass.hInstance = hInstance;
        wndclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
        wndclass.hbrBackground = GetStockObject(WHITE_BRUSH); 
        wndclass.lpszMenuName =  NULL;
        wndclass.lpszClassName = szAppName;

        RegisterClass(&wndclass);
        }

    hWnd = CreateWindow(szAppName,
        "Hello Program",
        WS_OVERLAPPEDWINDOW,            
        CW_USEDEFAULT,                  
        CW_USEDEFAULT,                  
        CW_USEDEFAULT,                  
        CW_USEDEFAULT,                  
        NULL,                           
        NULL,                           
        hInstance,                      
        NULL);

    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);        

    while(GetMessage(&msg, NULL, 0, 0))
    	{
	    TranslateMessage(&msg);
    	DispatchMessage(&msg); 
        }
    return (msg.wParam);  
}


long FAR PASCAL WndProc(HWND hWnd, WORD message,
    WORD wParam, LONG lParam)
    {
    char *text = "Hello, World!";

    switch(message)
        {
        case WM_PAINT:
            {
            PAINTSTRUCT ps;
            RECT rect;

            HDC hdc = BeginPaint(hWnd, &ps);

            GetClientRect(hWnd,&rect);

            TextOut(ps.hdc, rect.right/2, rect.bottom/2, (LPSTR)text,
                strlen(text));

            EndPaint(hWnd, &ps);
            }
            break;

        case WM_CLOSE:
            DestroyWindow(hWnd);
            break;

        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        }
    return DefWindowProc(hWnd, message, wParam, lParam);
    }

