/* restart program (V2.0) by Tom Almy, May 1990 */
/* improved version (V2.1) by Thomas Birnthaler, Aug 1990 */
/* still more improved version (V2.2) by Tom Almy, Sept 1990 */
/* contributed to the public domain */
/* compile with Turbo C using the options -1- -f- -G- -O -lt -mt -p */
/* compile with Microsoft C v6.0 with -AT -G0rs -Osleazr  */
/* This will generate minimum size modules */

#define VERSION "restart (V2.2 24.9.90)"

#ifdef __TURBOC__
#define _cdecl cdecl
#define _far far
#endif

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <time.h>


/* constant definitions */
#define  SEPSTR      "'"
#define  SEPCH       '\''
#define  NEGCH       '~'
#define  FILECH      '*'

#define  BOOTDRIVE   "BOOTDRIVE"
#define  COMSPEC     "COMSPEC"
#define  CONFIGFILE  "c:\\configur.dat"

#define  READONLY    "rt"
#define  WRITEONLY   "wt"

#define  MAXLINELEN  256   
#define  MAXDOSLINELEN 126  /* DOS can't handle more */

#define  MAXCONF     20   /* maximum configuration arguments */
#define  MAXCONFS    "20"

#define  ON   1
#define  OFF  0

#define  USAGE    1
#define  COMMENT  1

/* variable declarations */
int PREVIEW = OFF;
int REBOOT  = ON;
int DELAY   = 0;
int COLD  = OFF;

char *progname;
char infile[64] = CONFIGFILE;
char outfile[64];

FILE *input;
FILE *output = stdout;

char linebuf[MAXLINELEN];

int  confcnt = 0;
char *confname[MAXCONF];        /* selected restart config's */


/* function declarations */
void version(void);
void openconfigfile(void);
void getargs(int argc, char *argv[]);
int getline(void);
void trim(char *line);
void sendline(char *cp);
void printline(void);
void setargfromline(void);
void sleep(int delay);
void boot(void);
void error(char *string1, char *string2, int USAGEFLAG, int COMMENTFLAG);
void usage(void);
void showcomment(void);


void _cdecl main(int argc, char *argv[])
{
  char *cp;
  int  nr;

  version();
  openconfigfile();
  getargs(argc,argv);

  if (getline() == EOF)
    error("empty input file %s", infile, !USAGE, !COMMENT);

  if (linebuf[0] != SEPCH ||
      linebuf[strlen(linebuf)-1] != SEPCH ||
      strlen(linebuf) <= 2)
    error("wrong syntax in config line %s", linebuf, !USAGE, !COMMENT);


  for (nr=0; nr < confcnt; ++nr) {
    if (!strstr(linebuf,confname[nr]))
      error("config name %s not found in config file", confname[nr],
            !USAGE, COMMENT);
  }

  while (linebuf[0] != FILECH) {
    if (getline() == EOF)
      error("didn't find *filename line in config file %s", infile,
            !USAGE, !COMMENT);

    /* defining new argument? */
    if (linebuf[0] == SEPCH) {
      for (nr=0; nr < confcnt; ++nr) {
        if (strstr(linebuf, confname[nr]) != NULL) {
          setargfromline();
          break;
        }
      }
    }
    if (linebuf[0] == NEGCH) {
      for (nr=0; nr < confcnt; ++nr) {
        if (strstr(linebuf, confname[nr]) != NULL) break;
      }
      if (nr == confcnt) /* none matched */
        setargfromline();
    }
    
  }

  while (linebuf[0] == FILECH) {

    if (PREVIEW)
      printf("\n%s:\n",linebuf+1);
    else
      if((output = fopen(linebuf+1, WRITEONLY)) == NULL)
        error("cannot write file %s", linebuf+1, !USAGE, !COMMENT);

    while (getline() != EOF && linebuf[0] != FILECH) {

      /* config name dependent part */
      if (linebuf[0] == SEPCH) {
        for (nr=0; nr < confcnt; ++nr) {
          if (strstr(linebuf,confname[nr]) != NULL) {
            printline();  /* one matched */
            break;
          }
        }
      }

      /* inverted config name dependent part */
      else if (linebuf[0] == NEGCH) {
        for (nr=0; nr < confcnt; ++nr) {
          if (strstr(linebuf,confname[nr]) != NULL)
            break;
        }
        if (nr == confcnt) /* none matched */
          printline();
      }

      /* undependent part */
      else
        sendline(linebuf);
    }

    if (PREVIEW == OFF)
      fclose(output);
  }

  if (REBOOT == ON)  {
    if (DELAY > 0) sleep(DELAY);
    boot();
  }
}


/* trick system into reboot */
/* For warm (soft) reboot, first store 1234 into location 40:72 */
/* Perform a far call to the reboot location ffff:0000 */
void boot(void)
{
  if (COLD == OFF) *((unsigned int _far *) 0x00400072) = 0x1234;
  ((void (_far *)(void)) 0xffff0000)();
}


/* remove leading and trailing white space (includes '\n')from line */
void trim(char *line)
{
  char *s;
  char *d;

  s = d = line;
  while (isspace(*s)) ++s;
  while (*s) *d++ = *s++;
  do {
    *d-- = '\0';
  } while (d >= line && isspace(*d));
}


/* give error message and exit */
void error(char *string1, char *string2, int USAGEFLAG, int COMMENTFLAG)
{
  char c;

  fprintf(stderr,"error: ");
  fprintf(stderr,string1,string2);
  fprintf(stderr,"\n\n");
  if (USAGEFLAG) usage();
  if (COMMENTFLAG) showcomment();
  exit(1);
}


/* keep idle for delay seconds */
void sleep(int delay)
{
  time_t endtime;

  endtime = time(NULL) + delay;
  while (time(NULL) < endtime) 
    ;
}


/* get next nonempty line of input, return it's length or EOF */
int getline(void)
{
  int i;

  do {
    if (fgets(linebuf,MAXLINELEN,input) == NULL) {
      *linebuf = '\0';
      return(EOF);
    }
    trim(linebuf);
  } while ((i = strlen(linebuf)) == 0);

  if (i == MAXLINELEN-1)
    error("line too long: %s", linebuf, !USAGE, !COMMENT);

  return(i);
}


/* send a line to the file, checking for being too long */
void sendline(char *cp)
{
  if (strlen(cp) > MAXDOSLINELEN) 
    error("line too long for DOS: %s", cp, !USAGE, !COMMENT);
  fprintf(output,"%s\n",cp);
}


/* output line without leading config names */
void printline(void)
{
  char *cp;
  
  cp = linebuf;
  while (*cp && !isspace(*cp)) ++cp;
  while (isspace(*cp)) ++cp;
  if (*cp)
    sendline(cp);
}
  
/* string in line sets another argument as if in command line */
void setargfromline(void)
{
  char *cp, *cp2;
  cp = linebuf;
  while (*cp && !isspace(*cp)) ++cp;
  while (isspace(*cp)) ++cp;
  cp2 = cp;
  while (*cp2 && !isspace(*cp2)) ++cp2;
  *cp2 = 0;
  if (*cp) {
    if (confcnt >= MAXCONF) 
      error("Too many configurations (>%s)", MAXCONFS, USAGE, COMMENT);
    confname[confcnt] = (char *) malloc(strlen(cp) + 3);
    strcpy(confname[confcnt],SEPSTR);
    strcat(confname[confcnt],cp);
    strcat(confname[confcnt],SEPSTR);
    ++confcnt;
  }
}
      

void getargs(int argc, char *argv[])
{
  char *cp;

  /* reduce to base name */
  progname = *argv;
  if ((cp = strrchr(progname,'\\')) != NULL) progname = cp+1;
  if ((cp = strrchr(progname,'/')) != NULL) progname = cp+1;
  if ((cp = strchr(progname,'.')) != NULL) *cp = '\0';
  for (cp = progname; *cp; ++cp) *cp = tolower(*cp);
  ++argv;
  --argc;

  /* get options */
  while (*argv[0] == '-') {

    if (strcmp(*argv,"-p") == 0) {
      PREVIEW = ON;
      REBOOT = OFF;
    }

    else if (strcmp(*argv,"-n") == 0) {
      REBOOT = OFF;
    }

    else if (strcmp(*argv,"-c") == 0) {
      COLD = ON;
    }

    else if (sscanf(*argv+1,"%d",&DELAY) == 1 && DELAY > 0) {
    }
    else
      error("unknown option %s", *argv, USAGE, !COMMENT);

    ++argv;
    --argc;
  }

  /* get selected config names */
  confcnt = 0;
  while (argc-- > 0) {
    if (confcnt >= MAXCONF) 
      error("Too many configurations (>%s)", MAXCONFS, USAGE, COMMENT);
    confname[confcnt] = (char *) malloc(strlen(*argv) + 3);
    strcpy(confname[confcnt],SEPSTR);
    strcat(confname[confcnt],*argv++);
    strcat(confname[confcnt],SEPSTR);
    ++confcnt;
  }

  if (confcnt == 0) {
    getline();
    error("no config name(s) given", NULL, USAGE, COMMENT);
    getline();
    exit(1);
  }
}


void openconfigfile(void)
{
  char *cp;

  if ((cp = getenv(BOOTDRIVE)) == NULL)
    cp = getenv(COMSPEC);
  infile[0] = cp[0];

  if ((input = fopen(infile,READONLY)) == NULL)
    error("config file %s not found", infile, !USAGE, !COMMENT);
}


/* print first line and comments of config file */
void showcomment(void)
{
  char *cp;

  while ((cp = strchr(linebuf,SEPCH)) != NULL) *cp = ' ';
  fprintf(stderr,"names:%s\n\n",linebuf);
  while (getline() != EOF && *linebuf != FILECH)
    if (*linebuf != SEPCH && *linebuf != NEGCH) 
      fprintf(stderr,"\t%s\n",linebuf);
}


void version(void)
{
  printf("%s\n\n",VERSION);
}


void usage(void)
{
  fprintf(stderr,"usage: %s [-p | -n | -c | -<n>] <name> ...\n\n", progname);
  fprintf(stderr,"       -p   show resulting files on screen\n");
  fprintf(stderr,"       -n   don't reboot\n");
  fprintf(stderr,"       -c   cold reboot\n");
  fprintf(stderr,"       -<n> delay <n> seconds before reboot [Default: 0]\n\n");
}
