#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*           output module           */
/*                                   */
/*     (dynamic data is output by    */
/*      the dynamic() function)      */
/*                                   */
/*        Zortech C/C++ 3.0 r4       */
/*          MICROSOFT C 6.00         */
/*          Visual C/C++ 1.0         */
/*           QuickC/WIN 1.0          */
/*             ULTRIX cc             */
/*              GNU gcc              */
/*                                   */
/*   (include here compilers that    */
/*   compiled GEPASI successfully)   */
/*                                   */
/*************************************/


#include <stdio.h>
/*#include <conio.h>*/
#include <string.h>
#include <math.h>
#include <time.h>
#include "globals.h"
#include "globvar.h"
#include "datab.h"
#include "newton.h"
#include "metconan.h"
#include "lsoda.h"
#include "pmu.h"
#include "heapchk.h"

void report_header( FILE *ch );
void out_rstoi( FILE *o );
void out_rinv( FILE *o );

/* print an error message			 */
void out_error( int n )
{
 printf( "\n%s\n", errormsg[n] );
}

int dat_fileovr( void )
{
 FILE *ch1;

 /*unlink*/
 ch1 = fopen( options.datname, "wt" );             /* open output for .dat   */
 if ( ch1 == NULL )                                /* fopen failed ?         */
 {
  if( options.debug )
   printf("\n  * dat_out() - fatal error: couldn't open file %s\n", options.datname );
  return -1;
 }
 fclose( ch1 );
 return 0;
}

int dat_nl( void )
{
 FILE *ch1;

 ch1 = fopen( options.datname, "at" );             /* open output for .dat   */
 if ( ch1 == NULL )                                /* fopen failed ?         */
 {
  if( options.debug )
   printf("\n  * dat_out() - fatal error: couldn't open file %s\n", options.datname );
  return -1;
 }

 fprintf(ch1,"\n");

 fclose( ch1 );
 return 0;
}

int dat_titles( void )
{
 FILE *ch1;
 char *ptr;
 char delim;
 int i;

 switch( options.datsep )
 {
  case 0: delim = ' '; break;
  case 1: delim = ','; break;
  case 2: delim = '\t'; break;
  default: delim = ' ';
 }
 ch1 = fopen( options.datname, "at" );             /* open output for .dat   */
 if ( ch1 == NULL )                                /* fopen failed ?         */
 {
  if( options.debug )
   printf("\n  * dat_out() - fatal error: couldn't open file %s\n", options.datname );
  return -1;
 }
 ptr = outtit;
 for(i=0;i<totsel;i++)
 {
  if( i ) fprintf(ch1,"%c", delim );
  if( options.quotes ) fprintf(ch1,"\"" );
  fprintf(ch1,"%.*s%*s", options.datwidth, ptr, options.datwidth-strlen(ptr), "" );
  if( options.quotes ) fprintf(ch1,"\"" );
  do{ }while( *ptr++ );
 }
 fprintf(ch1,"\n");

 fclose( ch1 );
 return 0;
}

int dat_values( void )
{
 FILE *ch1;
 int i;
 char delim;

 switch( options.datsep )
 {
  case 0: delim = ' '; break;
  case 1: delim = ','; break;
  case 2: delim = '\t'; break;
  default: delim = ' ';
 }
 ch1 = fopen( options.datname, "at" );             /* open output for .dat   */
 if ( ch1 == NULL )                                /* fopen failed ?         */
 {
  if( options.debug )
   printf("\n  * dat_out() - fatal error: couldn't open file %s\n", options.datname );
  return -1;
 }

 for(i=0;i<totsel;i++)
 {                                                 /* output values			 */
  if( i ) fprintf(ch1,"%c", delim );
  fprintf(ch1,"% -*.*le", options.datwidth, options.datwidth-8, *(poutelem[i]));
 }
 fprintf(ch1,"\n");

 fclose( ch1 );
 return 0;
}

int dat_error( void )
{
 FILE *ch1;
/* char delim;

 switch( options.datsep )
 {
  case 0: delim = ' '; break;
  case 1: delim = ','; break;
  case 2: delim = '\t'; break;
  default: delim = ' ';
 }*/
 ch1 = fopen( options.datname, "at" );             /* open output for .dat   */
 if ( ch1 == NULL )                                /* fopen failed ?         */
 {
  if( options.debug )
   printf("\n  * dat_error() - fatal error: couldn't open file %s\n", options.datname );
  return -1;
 }

/* for(i=0;i<totsel;i++)
 {                      */                          /* output values				*/
/*  if( i ) fprintf(ch1,"%c", delim );*/
  /*fprintf(ch1,"% -*.*le", options.datwidth, options.datwidth-8, (double) 0 );*/
/*  for(j=0;j<options.datwidth;j++) fprintf(ch1," ");
 }*/
 fprintf(ch1,"\n");

 fclose( ch1 );
 return 0;
}

void report_init( int p )
{
 FILE *ch1;
 char mode[4];
 int i,j,k;
 char *ptr, auxstr[10];

 if( options.append ) strcpy( mode, "at" );
 else strcpy( mode, "wt" );
 strcpy( repfile, filename[p] );
 fixext( repfile, '.', ".txt" );
 ch1 = fopen( repfile, mode );
 if( options.append ) fprintf( ch1, "\n" );			/* separate from previous	*/
 report_header( ch1 );

 fprintf( ch1, "\n%s\n", topname );                 /* pathway title			*/
                                                    /* output struct filen 		*/
 if ( options.structan )
 {
  fprintf(ch1,"\nREDUCED STOICHEIOMETRY MATRIX\n");
  out_rstoi( ch1 );
  fprintf(ch1,"\nINVERSE OF THE REDUCTION MATRIX\n");
  out_rinv( ch1 );
 }
                                                    /* info about moieties */
 if ( depmet > 0 )
 {
  fprintf(ch1,"\nCONSERVATION RELATIONSHIPS\n");
  for( i=indmet; i<nmetab; i++ )
  {
   for(j=0, k=0;j<totmet;j++)
    if ( intmet[j] )
     if (ld[i][j] != (float) 0)
     {
      sprintf(auxstr, "%s ", k ? "+" : " " );
      if (ld[i][j] > (float) 1)
       sprintf(auxstr, "%s %3.1f*", k ? "+" : " ", ld[i][j] );
      else if (ld[i][j] < (float) -1)
            sprintf(auxstr, "- %3.1f*", fabs(ld[i][j]));
           else if (ld[i][j] == (float) -1)
                 sprintf(auxstr, "- ");
      fprintf(ch1,"%s[%s] ", auxstr, metname[j] );
      k++;
     }
   fprintf(ch1,"= %.4lg %s\n", moiety[i], options.concu);
  }
 }
 else
  fprintf(ch1,"\nNO CONSERVATION RELATIONSHIPS\n");

 fprintf(ch1,"\nKINETIC PARAMETERS\n");             /* output kinetic p.		*/
 for( i=0; i<nsteps; i++ )
 {
  fprintf(ch1,"%s (%s)\n",stepname[i], ktype[kinetype[i]].descr);
  ptr = ktype[kinetype[i]].constnam;
  for(j=0;j<(int)ktype[kinetype[i]].nconst; j++)
  {
   fprintf(ch1," %s = % .4le\n", ptr, params[i][j] );
   do{ } while( *(ptr++) );
  }
 }

 fclose(ch1);
}

void report_dyn( void )
{
 FILE *ch1;
 int i;

 ch1 = fopen( repfile, "at" );

 /* output concentrations	*/
 fprintf( ch1, "\nRESULTS OF INTEGRATION (after %.2le %s)\n", endtime, options.timeu );
 for( i=0; i<totmet; i++ )
  fprintf(ch1,"[%s] initial = % .6le %s, final = % .6le %s%s\n",
              metname[i], x0[i], options.concu, x[i],
              options.concu, x[i] >= 0 ? "" : " BOGUS!");

 /* output fluxes			*/
 for( i=0; i<nsteps; i++ )
  fprintf( ch1, "J(%s) = % .6le %s/%s\n", stepname[i], flux[i], options.concu, options.timeu );

 fclose(ch1);
}

void report_ss( int diverge, int ccfs )
{
 FILE *ch1;
 int i,j,k;
 double moi;
 char auxstr[10];

 ch1 = fopen( repfile, "at" );

 if( diverge == N_OK )
 {
  /* check if steady state is an equilibrium */
  if ( equilibrium() )
   fprintf(ch1,"\nEQUILIBRIUM SOLUTION\n");
  else
   fprintf(ch1,"\nSTEADY STATE SOLUTION\n");

  /* concentrations	*/
  for( i=0; i<totmet; i++ )
  {
   fprintf(ch1,"[%s] = % .6le %s, tt = % .6le %s, rate = % .3le %s/%s",
               metname[i], xss[i], options.concu, tt[i], options.timeu,
               rate[i], options.concu, options.timeu);
   if( xss[i] < 0 ) fprintf(ch1," BOGUS!");
   fprintf(ch1,"\n");
  }

  /* mass conservation	*/
  if ( depmet > 0 )
  {
   for( i=indmet; i<nmetab; i++ )
   {
    moi = 0;
    for(j=0, k=0;j<totmet;j++)
     if ( intmet[j] )
      if (ld[i][j] != (float) 0)
      {
       moi += (double)ld[i][j] * xss[j];
       sprintf(auxstr, "%s ", k ? "+" : " " );
       if (ld[i][j] > (float) 1)
        sprintf(auxstr, "%s %3.1f*", k ? "+" : " ", ld[i][j] );
       else
       {
        if (ld[i][j] < (float) -1) sprintf(auxstr, "- %3.1f*", fabs(ld[i][j]));
        else if (ld[i][j] == (float) -1) sprintf(auxstr, "- ");
       }

       fprintf( ch1,"%s[%s] ", auxstr, metname[j] );
       k++;
      }
    fprintf( ch1, "= %.4lg %s%s\n", moi, options.concu,
                  fabs(moi-moiety[i]) < options.hrcz  ? "" : " BOGUS!" );
   }
  }

  /* fluxes	*/
  for( i=0; i<nsteps; i++ )
   fprintf( ch1, "J(%s) = % .6le %s/%s\n", stepname[i], flux[i], options.concu, options.timeu );

  /* Reder's elasticities	*/
  if ( options.nonela )
  {
   fprintf(ch1,"\nABSOLUTE ELASTICITIES\n");
   for( i=0; i<nsteps; i++ )
   {
    for(j=0;j<totmet;j++)
     if ( Dxv[i][j] != (double) 0 )
      fprintf(ch1,"ae(%s,[%s]) =% .4le  ",
                  stepname[i],
                  metname[j],
                  Dxv[i][j]);
    fprintf(ch1,"\n");
   }
  }

  /* logarithmic elasticities	*/
  if ( options.stdela )
  {
   fprintf(ch1,"\nLOGARITHMIC ELASTICITIES\n");
   for( i=0; i<nsteps; i++ )
   {
    for(j=0;j<totmet;j++)
     if ( Dxv[i][j] != (float) 0 )
      if( fabs( flux[i] ) >= options.hrcz )
       fprintf(ch1, " e(%s,[%s]) =% .4le  ",
                    stepname[i],
                    metname[j],
                    Dxv[i][j] * xss[j] / flux[i] );
      else fprintf(ch1, " e(%s,%s) = infinity  ", stepname[i], metname[j] );
     fprintf(ch1,"\n");
   }
  }

  /* Reder's conc. control coeffs.	*/
  if ( options.noncc )
  {
   if ( ccfs != MCA_NOCC )
   {
    fprintf(ch1,"\nCONCENTRATION CONTROL COEFFICIENTS (unscaled)\n");
    for( i=0; i<totmet; i++)
     if (intmet[i])
     {
      fprintf(ch1,"\n%s\n", metname[i]);
      for( j=0; j<nsteps; j++)
       fprintf(ch1,"C([%s],J(%s)) = % 6.4le\n", metname[i],
                   stepname[j], Gamma[i][j] );
     }
   }
  }

  /* logarithmic conc. control coeffs.	*/
  if ( options.stdcc )
  {
   if ( ccfs != MCA_NOCC )
   {
    fprintf(ch1,"\nCONCENTRATION CONTROL COEFFICIENTS (scaled)\n");
    for( i=0; i<totmet; i++)
     if (intmet[i])
     {
      fprintf( ch1, "\n%s\n", metname[i] );
      for( j=0; j<nsteps; j++)
      {
       if ( xss[i] == (double) 0 )
        fprintf( ch1, "C([%s],J(%s)) = not defined\n", metname[i], stepname[j] );
       else
        fprintf(ch1,"C([%s],J(%s)) = % 6.4le\n", metname[i],
                    stepname[j],
                    Gamma[i][j] *
                    flux[j] / xss[i] );
      }
     }
   }
  }

  /* Reder's flux control coefficients	*/
  if ( options.noncc )
  {
   if ( ccfs != MCA_NOCC )
   {
    fprintf(ch1,"\nFLUX CONTROL COEFFICIENTS (unscaled)\n");
    for( i=0; i<nsteps; i++)
    {
     fprintf(ch1,"\n%s\n", stepname[i]);
      for( j=0; j<nsteps; j++ )
       fprintf(ch1,"C(J(%s),%s) = % 6.4le\n",
                  stepname[i], stepname[j], C[i][j] );
    }
   }
  }

  /* logarithmic flux control coeffs.	*/
  if ( options.stdcc )
  {
   if ( ccfs != MCA_NOCC )
   {
    fprintf(ch1,"\nFLUX CONTROL COEFFICIENTS (scaled)\n");
    for( i=0; i<nsteps; i++)
    {
     fprintf(ch1,"\n%s\n",stepname[i]);
     for( j=0; j<nsteps; j++)
     {
      if ( fabs( flux[i] ) < options.hrcz )
      {
       if ( fabs( flux[j] ) < options.hrcz )
        fprintf(ch1,"C(J(%s),%s) = not defined\n",
                   stepname[i], stepname[j] );
       else
        fprintf(ch1,"C(J(%s),%s) = infinity\n", stepname[i], stepname[j] );
      }
      else
       fprintf(ch1,"C(J(%s),%s) = % 6.4le\n", stepname[i], stepname[j],
                   C[i][j] *
                   flux[j] / flux[i] );
     }
    }
   }
  }
 }
 else  /* no steady state solution	*/
 {
  fprintf(ch1,"\n**** NO STEADY-STATE! ****\n");
  switch( diverge )
  {
   case N_NOCONV: fprintf(ch1,"\nno convergence "); break;
   case N_LMIN  : fprintf(ch1,"\nstuck in local minimum "); break;
   case N_JSING : fprintf(ch1,"\nsingular jacobian ");
  }
  fprintf(ch1,"after 1e+10 %s\n", options.timeu);

  for( i=0; i<totmet; i++ )
   fprintf(ch1,"[%s] = % .6le %s, tt = % .6le %s, rate = % .3le %s/%s%s\n",
               metname[i], xss[i], options.concu, tt[i], options.timeu,
               rate[i], options.concu, options.timeu, xss[i] >= 0 ? "" : " BOGUS!");
  for( i=0; i<nsteps; i++ )
   fprintf( ch1, "J(%s) = % .6le\n", stepname[i], flux[i] );
 }
 fclose(ch1);
}

void report_tech( void )
{
 FILE *ch1;

 ch1 = fopen( repfile, "at" );

 fprintf(ch1, "\n\nTECHNICAL INFORMATION");
 fprintf(ch1, "\nlast ODE integration method used: %1d%s order %s",
              nqu, (nqu==1) ? "st" : ( (nqu==2) ? "nd" : ( (nqu==3) ? "rd" : "th" ) ),
              (mused==1) ? "adams" : "gear ");
 fprintf(ch1, "\nnumber of steps taken: %-4d", nst );
 fprintf(ch1, "\nnumber of function evaluations: %-4d", nfe );
 fprintf(ch1, "\nnumber of jacobian evaluations: %-4d", nje );
 fprintf(ch1, "\nlast step size used: %.2le", hu );

 fclose(ch1);
}

void out_rstoi( FILE *o )
{
 int i,j;

 fprintf( o , "\nkey for step (column) numbers:" );
 for( j=0; j<nsteps; j++ )
  fprintf( o, "\n%2d - %s", j, stepname[j]);
 fprintf( o , "\n              " );
 for( j=0; j<nsteps; j++ )
  fprintf( o, "%2d  ", j);
 fprintf( o , "\n" );
 fprintf( o , "           -" );
 for( j=0; j<nsteps; j++ )
  fprintf( o, "----" );
 fprintf( o, "-\n" );
 for( i=0; i<indmet; i++ )
 {
   fprintf( o, "%-10.10s | ", metname[i] );
   for( j=0; j<nsteps; j++ )
    fprintf( o, " % 1.0f ", rstoi[i][j] );
   fprintf( o, "\n");
 }
}

void out_rinv( FILE *o )
{
 int i,j;

 fprintf( o , "\n              " );
 for( j=0; j<nmetab; j++ )
  fprintf( o, "%2d  ", j);
 fprintf( o, "\n" );
 fprintf( o , "           -" );
 for( j=0; j<nmetab; j++ )
  fprintf( o, "----" );
 fprintf( o, "-\n" );
 for( i=0; i<nmetab; i++ )
 {
   fprintf( o, "%-10.10s | ", metname[i] );
   for( j=0; j<nmetab; j++ )
    fprintf( o, " % 1.0f ", ml[i][j] );
   fprintf( o, "\n");
 }
}


void report_error( void )
{
 FILE *ch1;

 ch1 = fopen( repfile, "at" );
 fprintf( ch1, "\n\nFLOATING-POINT ERROR\n%s: (%d)\n", fpstr, fperr );
 fclose( ch1 );
}

/* print the header of the .txt file */
void report_header( FILE *ch )
{
 register int i, hw;
 int pre, suf;
 struct tm *newtime;
 time_t ltime;
 char strtime[26];

 /* get seconds elapsed since 1 Jan 1970	*/
 time( &ltime );
 /* Obtain greenwich mean time: */
 newtime = localtime( &ltime );
 strcpy( strtime, asctime( newtime ) );
 strtime[24] ='\0';

 if (strlen(gepasi) > strlen(repfile)) hw = strlen(gepasi);
 else hw = strlen(repfile);
 if ( (int) strlen(version_no) > hw) hw = (int) strlen(version_no);
 for(i=0;i<hw+4;i++) fprintf(ch,"*");
 fprintf(ch,"\n");
 fprintf(ch,"* ");
 pre = ( hw - strlen( gepasi ) ) / 2;
 suf = hw - pre - strlen( gepasi );
 for(i=0;i<pre;i++) fprintf(ch," ");
 fprintf(ch, gepasi);
 for(i=0;i<suf;i++) fprintf(ch," ");
 fprintf(ch," *\n");
 fprintf(ch,"* ");
 pre = ( hw - strlen( version_no ) ) / 2;
 suf = hw - pre - strlen( version_no );
 for(i=0;i<pre;i++) fprintf(ch," ");
 fprintf(ch, version_no);
 for(i=0;i<suf;i++) fprintf(ch," ");
 fprintf(ch," *\n");
 fprintf(ch,"* ");
 pre = ( hw - strlen( strtime ) ) / 2;
 suf = hw - pre - strlen( strtime );
 for(i=0;i<pre;i++) fprintf(ch," ");
 fprintf( ch, strtime );
 for(i=0;i<suf;i++) fprintf(ch," ");
 fprintf(ch," *\n");
 fprintf(ch,"* ");
 pre = ( hw - strlen( repfile ) ) / 2;
 suf = hw - pre - strlen( repfile );
 for(i=0;i<pre;i++) fprintf(ch," ");
 fprintf(ch, repfile);
 for(i=0;i<suf;i++) fprintf(ch," ");
 fprintf(ch," *\n");
  for(i=0;i<hw+4;i++) fprintf(ch,"*");
 fprintf(ch,"\n");
}
