#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*         GWSIM - Simulation        */
/*        MS-WINDOWS front end       */
/*                                   */
/*         Numerical methods         */
/*            dialog box             */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <stdlib.h>
#include <math.h>
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwsim.h"						/* macros, function prototypes, etc.	*/
#include "gep2.h"						/* gepasi's variables					*/
#include "simgvar.h"					/* global variables						*/
#include "strtbl.h"						/* symbols for the string table			*/

#pragma alloc_text( CODE10, EdNumer )

BOOL FAR PASCAL EdNumer(HWND hDlg, WORD message, WORD wParam, LONG lParam)
{
 static	HWND	hRtol, hAtol, hAdams, hBdf, hFres;
 char buff[128];
 int len;
 double daux;

 switch( message )
 {
  case WM_INITDIALOG:
   /* get handles to controls										*/
   hRtol  = GetDlgItem( hDlg, IDE_M0 );
   hAtol  = GetDlgItem( hDlg, IDE_M1 );
   hAdams = GetDlgItem( hDlg, IDE_M2 );
   hBdf   = GetDlgItem( hDlg, IDE_M3 );
   hFres  = GetDlgItem( hDlg, IDE_M4 );

   /* fill in the current set of options							*/
   gcvt( options.reltol, 16, buff );
   SendMessage( hRtol, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
   gcvt( options.abstol, 16, buff );
   SendMessage( hAtol, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
   wsprintf( (LPSTR) buff, "%d", options.adams );
   SendMessage( hAdams, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
   wsprintf( (LPSTR) buff, "%d", options.bdf );
   SendMessage( hBdf, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
   gcvt( options.hrcz, 16, buff );
   SendMessage( hFres, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
   return TRUE;

  case WM_COMMAND:
   switch( wParam )
   {
    case IDC_DEFAULTS:
     numer_dft();
     SendMessage( hDlg, WM_INITDIALOG, 0, 0 );
     return TRUE;

    case IDC_HELP:            /* Help on this Dialog Box				*/
   	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Numerical parameters" );
   	 return TRUE;

    case IDOK:
     /* read all variables from the controls		*/
     len = (int) SendMessage( hRtol, WM_GETTEXT, (WORD) sizeof( buff ), (DWORD)(LPSTR) buff );
     if( len>0 ) daux = strtod( buff, NULL );
     else daux = options.reltol;
     if( (daux==HUGE_VAL) || (daux==-HUGE_VAL) )
     {
      LoadString(hInst, IDS_ERR_OVERFLOW, szString, sizeof(szString));
      MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
      SetFocus( hRtol );
      return TRUE;
     }
     if( (daux<=0) )
     {
      LoadString(hInst, IDS_ERR_ZEROBAD, szString, sizeof(szString));
      MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
      SetFocus( hRtol );
      return TRUE;
     }
     options.reltol = daux;

     len = (int) SendMessage( hAtol, WM_GETTEXT, (WORD) sizeof( buff ), (DWORD)(LPSTR) buff );
     if( len>0 ) daux = strtod( buff, NULL );
     else daux = options.abstol;
     if( (daux==HUGE_VAL) || (daux==-HUGE_VAL) )
     {
      LoadString(hInst, IDS_ERR_OVERFLOW, szString, sizeof(szString));
      MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
      SetFocus( hAtol );
      return TRUE;
     }
     if( (daux<=0) )
     {
      LoadString(hInst, IDS_ERR_ZEROBAD, szString, sizeof(szString));
      MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
      SetFocus( hAtol );
      return TRUE;
     }
     options.abstol = daux;

     len = (int) SendMessage( hAdams, WM_GETTEXT, (WORD) sizeof( buff ), (DWORD)(LPSTR) buff );
     if( len>0 ) len = atoi( buff );
     else len = options.adams;
     if( (len<=0) )
     {
      LoadString(hInst, IDS_ERR_ZEROBAD, szString, sizeof(szString));
      MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
      SetFocus( hAdams );
      return TRUE;
     }
     options.adams = len;

     len = (int) SendMessage( hBdf, WM_GETTEXT, (WORD) sizeof( buff ), (DWORD)(LPSTR) buff );
     if( len>0 ) len = atoi( buff );
     else len = options.bdf;
     if( (len<=0) )
     {
      LoadString(hInst, IDS_ERR_ZEROBAD, szString, sizeof(szString));
      MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
      SetFocus( hBdf );
      return TRUE;
     }
     options.bdf = len;

     len = (int) SendMessage( hFres, WM_GETTEXT, (WORD) sizeof( buff ), (DWORD)(LPSTR) buff );
     if( len>0 ) daux = strtod( buff, NULL );
     else daux = options.hrcz;
     if( (daux==HUGE_VAL) || (daux==-HUGE_VAL) )
     {
      LoadString(hInst, IDS_ERR_OVERFLOW, szString, sizeof(szString));
      MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
      SetFocus( hFres );
      return TRUE;
     }
     if( (daux<=0) )
     {
      LoadString(hInst, IDS_ERR_ZEROBAD, szString, sizeof(szString));
      MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
      SetFocus( hFres );
      return TRUE;
     }
     options.hrcz = daux;


     /* signal that changes were made				*/
     notsaved = 1;

     /* close the dialog box and return				*/
     EndDialog( hDlg, IDOK );
     return TRUE;

    case IDCANCEL:
     /* close the dialog box and return			*/
     EndDialog( hDlg, IDCANCEL );
     return TRUE;
   }

  default: return FALSE;
 }
}