/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*   databases and their functions   */
/*                                   */
/*          MICROSOFT C 6.00         */
/*           QuickC/WIN 1.0          */
/*             ULTRIX cc             */
/*              GNU gcc              */
/*                                   */
/*   (include here compilers that    */
/*   compiled GEPASI successfully)   */
/*                                   */
/*************************************/


/* structure holding information relative to kinetic mechanisms	*/

struct kint {
		  		unsigned char nsub;		/* number ofsubstrates	*/
				unsigned char npro;		/* number of products	*/
				unsigned char nmodf;	/* number of modifiers	*/
				unsigned char revers;	/* reversability		*/
		  		unsigned char nconst;	/* number of kin. const.*/
				char *descr;			/* title				*/
				char *constnam;			/* kin. constant names	*/
	   	    };

/* structures for user-defined rate equations					*/

struct nodet{
             char item;
             unsigned char val;
             unsigned char left;
             unsigned char right;
            } ;

struct treet{
             struct nodet node[256];
             char id[64][10];
             float constant[32];
             int nnode,
                 nnum,
                 nid,
                 nsub,
                 npro,
                 nmodf,
                 nconst,
                 revers;
             char descr[64];
            } ;


/* structure holding simulation options							*/

struct opt {
            int dyn;
            long pfo;
	        double	endtime;
            double	reltol;
            double	abstol;
            double	hrcz;
            int adams;
            int bdf;
            int ss;
            int debug;
            int txt;
            int structan;
            int staban;
            int stdela;
            int nonela;
            int stdcc;
            int noncc;
            int dat;
			char datname[PWIDTH];
            int datsep;
            int datwidth;
            int dattit;
            int datmca;
            int datss;
            int append;
            int quotes;
			char timeu[32];
			char concu[32];
            int scan;
            int scanfill;
            int scandens;
            int scanlog;
           };

struct sp{
	      PDBL var;
	      double low;
	      double high;
	      double ampl;
	      int dens;
	      int log;
          PDBL linkedto;
	      double factor;
	      int operation;
	     };


extern PDBL		params[MAX_STEP];							/* ptr to parameters for each rate eq.	*/
extern int *eff[MAX_STEP];								/* ptr to parameters for each rate eq.	*/
extern unsigned char	revers[MAX_STEP];					/* 1 if reaction is reversible			*/
extern struct	opt options;								/* structure with simulation options	*/
extern struct 	kint *ktype;								/* ptr array of kinetic types & proprt	*/
extern struct sp  *sparam;									/* ptr array with parameters to scan	*/
extern PDBL		*scanpar;									/* ptrs to all possbl.params 4 scanning */
extern PDBL		*outpel;									/* array of ptr to values for dat output*/
extern PDBL		*poutelem;									/* ptrs to values for actual dat output	*/
extern char		*outtit;									/* pointer to buffer with column titles */
extern char		*treestr;									/* pointer to buffer with constant names*/
extern char		*treeptr;									/* pointer to buffer with constant names*/
extern int		*scindex;									/* ptr to base of array with idx to scan*/
extern int		*lindex;									/* ptr to base of array with idx 2 links*/
extern int		noutpel;                                    /* number of output elements			*/
extern int		nscanpar;                                   /* number of scanning elements			*/
extern int		totscan;                                    /* number of selected scanning params	*/
extern int		nlinks;										/* number of linked parameters			*/
extern int		nudf;										/* number of user-def functions			*/
extern int		nrateq;										/* number of total rate equations		*/
extern int		totsel;                                     /* number of selected output elements	*/
extern int		kfl[MAX_STEP];								/* flags for kinetic types				*/
extern unsigned int sizespar;
extern unsigned int sizeparam;
extern unsigned int sizeeff;
extern unsigned int sizeoutp;
extern unsigned int sizetr;
extern struct treet *tree;								/* function tree for rate equations		*/
extern struct	treet tr;									/* tree for the input					*/

int MemAlloc( void );
void InitDataBase( void );
int SetParams( void );
int SetEff( void );
int SetOutpEl( void );
int SetScanPar( void );
int addtr( int e );
int new_rateq( int idx );
int new_tree( int idx );
void FreeMem( void );
