/* TWINDOW.C File */

#include <stdio.h>
#include <ctype.h>
#include <stdarg.h>
#include <dos.h>
#include <alloc.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include "twindow.h"
#include "keys.h"

#define TABS 		4
#define ON		1
#define OFF		0
#define ERROR		-1

/* Local prototypes */

void pascal redraw(WINDOW *wnd);
void pascal dtitle(WINDOW *wnd);
int * pascal waddr(WINDOW *wnd,int x,int y);
void pascal vswap(WINDOW *wnd);
void pascal vsave(WINDOW *wnd);
void pascal vrstr(WINDOW *wnd);
void pascal add_list(WINDOW *wnd);
void pascal beg_list(WINDOW *wnd);
void pascal remove_list(WINDOW *wnd);
void pascal insert_list(WINDOW *w1,WINDOW *w2);
#ifndef FASTWINDOWS
 int pascal dget(WINDOW *wnd,int x,int y);
 int pascal verify_wnd(WINDOW **w1);
#endif
#ifdef USECLOCK
 extern void pascal print_clock(void);
#endif

/* Array of border character sets */

struct {
  int nw,ne,se,sw,side,line;
  } wcs[]={
	{254,24,217,25,179,196}, 	/* single line */
	{254,24,188,25,186,205}, 	/* double line */
	{254,24,189,25,186,196}, 	/* single top, double side */
	{254,24,190,25,179,205}, 	/* double top, single side */
	{194,26,217,27,179,196}, 	/* pop-down menu */
	{201,187,188,200,186,205},	/* double line no cues*/
	{254,183,189,211,186,196}   /* horizontal menu of pull-down */
  };

/* Window structure linked list head & tail */

WINDOW *listhead = NULL;
WINDOW *listtail = NULL;

WINDOW *ewnd=NULL;	/* Global error/note window */

int VSG;  /* video segment address */

/* Variables which should be set by external functions */

unsigned int vbase=0;  			/* for pd direct screen funcs if used */
unsigned int maxx=0;            /* # columns on screen */
unsigned int maxy=0;            /* # rows on screen */
unsigned char current_color=7;  /* for pd direct screen funcs if used */
unsigned int videomethod=0;     /* for pd direct screen funcs if used */
unsigned char usemouse=0;       /* mouse used if non-zero */
int oldmousex=-1,oldmousey,oldmousevid;
int wasconfinedx1=-1,wasconfinedy1,wasconfinedx2,wasconfinedy2;

/* Establish a new window */

WINDOW * pascal establish_window (x,y,h,w) {

  WINDOW *wnd;

  VSG=(vmode()==7 ? 0xb000: 0xb800);
  if ((wnd=(WINDOW *) malloc(sizeof(WINDOW)))==NULL)
    return NULL;

  /* Adjust for out-of-bounds parameters */

  WTITLE="";
  HEIGHT=min(h,maxy);
  WIDTH=min(w,maxx);
  COL=max(0,min(x,maxx-WIDTH));
  ROW=max(0,min(y,maxy-HEIGHT));
  WCURS=0;
  SCROLL=0;
  SELECT=1;
  BTYPE=0;
  VISIBLE=HIDDEN=0;
  PREV=NEXT=NULL;
  FHEAD=FTAIL=NULL;
  WBORDER=WNORMAL=PNORMAL=WTITLEC=clr(BLACK,WHITE,BRIGHT);
  WACCENT=clr(WHITE,BLACK,DIM);
    if ((SAV=malloc(WIDTH * HEIGHT * 2))==(char *)0) return NULL;
    add_list(wnd);
  #ifndef FASTWINDOWS
    clear_window(wnd);
    wframe(wnd);
  #endif
    return(wnd);
}


/* Set the window's border */

void pascal set_border (WINDOW *wnd,int btype) {

  if (verify_wnd(&wnd)) {
    BTYPE=btype;
    redraw(wnd);
  }
}

/* Set colors */

void pascal set_colors (WINDOW *wnd,int area,int bg,int fg,int inten) {

  if (vmode()==7) {
    if (bg != WHITE && bg !=BLACK) return;
    if (fg !=WHITE && fg!=BLACK) return;
  }
  if(fg==bg) return;
  if (verify_wnd(&wnd)) {
    if (area==ALL)
      while (area)
        WCOLOR[--area]=clr(bg,fg,inten);
    else WCOLOR[area]=clr(bg,fg,inten);
    redraw (wnd);
  }
}

/* Set intensity of window */

void pascal set_intensity (WINDOW *wnd,int inten) {

  int area=ALL;

  if (verify_wnd(&wnd)) {
    while (area) {
      WCOLOR[--area]&= ~BRIGHT;
      WCOLOR[area] |= inten;
    }
    redraw(wnd);
  }
}

/* Set title */

void pascal set_title (WINDOW *wnd,char *title) {
  if (verify_wnd(&wnd)) {
    WTITLE=title;
    redraw(wnd);
  }
}

/* Redraw a window when an attribute changes */

static void pascal redraw (WINDOW *wnd) {

#ifndef FASTWINDOWS
  int x,y,chat,atr;

  for (y=1;y<HEIGHT-1;y++)
    for (x=1;x<WIDTH-1;x++) {
      chat=dget(wnd,x,y);
      atr=(((chat>>8)&255) ==
	PNORMAL ? WNORMAL : WACCENT);
      displ(wnd,x,y,chat&255,atr);
    }
  wframe(wnd);
#endif
  PNORMAL=WNORMAL;
}

/* Display an established window */

void pascal display_window (WINDOW *wnd) {

  if (verify_wnd(&wnd)&& !VISIBLE) {
    VISIBLE=1;
#ifdef FASTWINDOWS
    if (HIDDEN) {
	  HIDDEN=0;
	  vrstr(wnd);
	  wframe(wnd);
	}
    else {
      vsave (wnd);
      clear_window(wnd);
	  wframe(wnd);
    }
#else
    vswap(wnd);
#endif
  }
}

/* Close all windows */

void pascal close_all() {

  WINDOW *sav,*wnd=listtail;

  while(wnd) {
    sav=PREV;
    delete_window(wnd);
    wnd=sav;
  }
}

/* Remove a window */

void pascal delete_window (WINDOW *wnd) {

  if (verify_wnd(&wnd)) {
	hide_window(wnd);
	free(SAV);
    remove_list(wnd); /* remove window from list */
	free(wnd);
  }
}

/* Hide a window */

void pascal hide_window (WINDOW *wnd) {

  if (verify_wnd(&wnd) && VISIBLE) {
#ifndef FASTWINDOWS
    vswap(wnd);
#else
	vrstr(wnd);
#endif
	HIDDEN=1;
    VISIBLE=0;
  }
}

#ifndef FASTWINDOWS

/* Reposition the window in its 3-axis plane */

void pascal repos_wnd(WINDOW *wnd,int x,int y,int z) {

  WINDOW *twnd;
  int x1,y1,chat;
  if (!verify_wnd(&wnd))
    return;
  twnd=establish_window(x+COL,y+ROW,HEIGHT,WIDTH);
  twnd->_tl=WTITLE;
  twnd->btype=BTYPE;
  twnd->wcolor[BORDER]=WBORDER;
  twnd->wcolor[TITLE]=WTITLEC;
  twnd->wcolor[ACCENT]=WACCENT;
  twnd->wcolor[NORMAL]=WNORMAL;
  twnd->_wsp=SCROLL;
  twnd->_cr=WCURS;
  if (z!=1) {
    remove_list(twnd);
    if (z==0)
      insert_list(twnd,wnd);
    else
      beg_list(twnd);
  }
  for(y1=0;y1<twnd->_wh;y1++)
    for (x1=0;x1<twnd->_ww;x1++) {
      chat = dget(wnd,x1,y1);
      displ(twnd,x1,y1,chat&255,(chat>>8)&255);
    }
  twnd->_wv=1;
  vswap(twnd);
  hide_window(wnd);
  free(SAV);
  remove_list(wnd);
  *wnd=*twnd;
  insert_list(wnd,twnd);
  remove_list(twnd);
  free(twnd);
}
#endif

/* Clear window */

void pascal clear_window (WINDOW *wnd) {

  register int x1,y1;

  if (verify_wnd(&wnd))
    for(y1=1;y1<HEIGHT-1;y1++)
      for(x1=1;x1<WIDTH-1;x1++)
	displ(wnd,x1,y1,' ',WNORMAL);
}

/* Draw the window frame */

void pascal wframe (WINDOW *wnd) {

  register int x1,y1;

  if (!verify_wnd(&wnd)) return;
  /* Window title */
  displ(wnd,0,0,NW,WBORDER);
  dtitle(wnd);
  displ(wnd,WIDTH-1,0,NE,WBORDER);
  /* Window sides */
  for (y1=1;y1<HEIGHT-1;y1++) {
    displ(wnd,0,y1,SIDE,WBORDER);
    displ(wnd,WIDTH-1,y1,SIDE,WBORDER);
  }
  /* Bottom of frame */
  displ(wnd,0,y1,SW,WBORDER);
  for(x1=1;x1<WIDTH-1;x1++)
    displ(wnd,x1,y1,LINE,WBORDER);
  displ(wnd,x1,y1,SE,WBORDER);
}


static void pascal dtitle (WINDOW *wnd) {

  int x1=1,i,ln;
  char *s=WTITLE;

  if (!verify_wnd(&wnd)) return;
  if (s) {
    ln=strlen(s);
    if (ln>WIDTH-2)
      i=0;
    else
      i=((WIDTH-2-ln)/2);
    if (i>0)
      while (i--)
	displ(wnd,x1++,0,LINE,WBORDER);
    while(*s && x1<WIDTH-1)
      displ(wnd,x1++,0,*s++,WTITLEC);
  }
  while(x1<WIDTH-1)
    displ(wnd,x1++,0,LINE,WBORDER);
}

/* Window-oriented printf */

void cdecl wprintf (WINDOW *wnd,char *ln,...) {

  char dlin[100],*dl=dlin;

  if (verify_wnd(&wnd)) {
    va_list ap;
    va_start(ap,ln);
    vsprintf(dlin,ln,ap);
    va_end(ap);
    while(*dl)
      wputchar(wnd,*dl++);
  }
}


/* Window-oriented 'raw' printf */

void cdecl wprintfraw (WINDOW *wnd,char *ln,...) {

  char dlin[100],*dl=dlin;

  if (verify_wnd(&wnd)) {
    va_list ap;
    va_start(ap,ln);
    vsprintf(dlin,ln,ap);
    va_end(ap);
    while(*dl)
      wputchar(wnd,*dl++);
  }
}

/* Write a character to the window */

void pascal wputchar (WINDOW *wnd,int c) {

  if (!verify_wnd(&wnd)) return;
  switch(c) {
    case '\n':
      if (SCROLL==HEIGHT-3)
	scroll(wnd,UP);
      else
	SCROLL++;
      WCURS=0;
      break;
    case '\t':
      do displ(wnd,(WCURS++)+3,SCROLL+1,' ',WNORMAL);
	while ((WCURS%TABS) && (WCURS+1)<WIDTH-1);
      break;
    default:
      if ((WCURS+1)<WIDTH-1) {
		  displ(wnd,WCURS+1,SCROLL+1,c,WNORMAL);
		  WCURS++;
      }
      break;
  }
}


/* Write a raw character to the window */

void pascal wputcharaw (WINDOW *wnd,int c) {

  if (!verify_wnd(&wnd)) return;
  if ((WCURS+1)<WIDTH-1) {
	  displ(wnd,WCURS+1,SCROLL+1,c,WNORMAL);
	  WCURS++;
  }
}

/* Set window cursor */

void pascal wcursor (WINDOW *wnd,int x,int y) {

  if (verify_wnd(&wnd) && x<WIDTH-1 && y<HEIGHT-1) {
    WCURS=x;
    SCROLL=y;
    cursor(COL+x+1,ROW+y+1);
  }
}

/* Allow user to select window */

int pascal get_selection (WINDOW *wnd,int s,char *keys) {

  int c=0,ky;

  if (!verify_wnd(&wnd)) return(0);
	SHOWMOUSE;
	CONFINEMOUSE(wnd);
	SELECT=s;
    while (c !=ESC && c!='\r' && c !=BS && c!=FWD) {
	  HIDEMOUSE;
	  accent(wnd);
	  SHOWMOUSE;
      c=0;
      while(!kbhit()) {
		  if(usemouse) {

                union REGS rg;

				rg.x.ax=3;
				int86(0x33,&rg,&rg);
				move_mouse(rg.x.cx/8,rg.x.dx/8);
                rg.x.ax=5;
                rg.x.bx=0;          /* Check left button */
                int86(0x33,&rg,&rg);
				rg.x.cx/=8;
				rg.x.dx/=8;
				if(rg.x.bx) {       /* Button pressed */
					if(rg.x.cx==COL && rg.x.dx==ROW) {
						c=ESC;
						break;
					}
					if(rg.x.dx==ROW && rg.x.cx==COL+WIDTH-1) {
						c=PGUP;
						break;
					}
					if(rg.x.cx==COL && rg.x.dx==ROW+HEIGHT-1) {
						c=PGDN;
						break;
					}
					if(rg.x.cx==COL+WIDTH-1 && rg.x.cx==ROW+HEIGHT-1) {
						c=END;
						break;
					}
					if(rg.x.cx==COL+WIDTH-1) {
						c=FWD;
						break;
					}
					if(rg.x.cx==COL) {
						c=BS;
						break;
					}
					if(rg.x.dx==ROW+HEIGHT-1) {
						c=DN;
						break;
					}
					if(rg.x.dx==ROW) {
						c=UP;
						break;
					}
					if(rg.x.cx>COL && rg.x.dx>ROW && rg.x.cx<((COL+WIDTH)-1) && rg.x.dx<((ROW+HEIGHT)-1)) {
                        rg.x.cx=rg.x.dx-ROW;    /* rg.x.cx = window y pos of mouse */
						if(rg.x.cx<=SCROLL+1) {    /* In valid area */
                            c='\r';
							HIDEMOUSE;
							deaccent(wnd);
                            SELECT=rg.x.cx;
							SHOWMOUSE;
							accent(wnd);
							break;
                        }
					}
				}
				rg.x.ax=3;
				int86(0x33,&rg,&rg);
				move_mouse(rg.x.cx/8,rg.x.dx/8);
				rg.x.ax=5;
				rg.x.bx=1;
				int86(0x33,&rg,&rg);
				if(rg.x.bx) {
					c=ESC;
					break;
				}
          }
#ifdef USECLOCK
          print_clock();
#endif
      }
	  HIDEMOUSE;
	  if(!c)c=get_char();
	  deaccent(wnd);
	  SHOWMOUSE;
      switch(c) {
        case UP:  if (SELECT > 1) SELECT --;
                  else SELECT = SCROLL+1;
                  break;
        case DN:  if (SELECT < SCROLL+1) SELECT++;
                  else SELECT=1;
                  break;
		case HOME:
		case END:
		case PGUP:
		case PGDN:
		case F10:
        case ALT_F1:
        case ALT_F2:
        case ALT_F3:
        case ALT_F4:
        case ALT_F5:
        case ALT_F6:
        case ALT_F7:
        case ALT_F8:
        case ALT_F9:
		case ALT_F10:   HIDEMOUSE;
                        return c;
        case '\r':
		case ESC:
        case FWD:
        case BS:      break;
        default:      if (keys) {
                          ky=0;
                          while(*(keys+ky)) {
                            if (*(keys+ky)==toupper(c) || *(keys+ky)==tolower(c)) {
								HIDEMOUSE;
								return ky+1;
                            }
                            ky++;
                          }
                      }
                      break;
      }
    }
	HIDEMOUSE;
	return c=='\r' ? SELECT : c==ESC ? 0 : c;
}

/* Scroll a window's contents up or down */

void pascal scroll (WINDOW *wnd,int dir) {

  int row=HEIGHT-1,col,chat;
  union REGS rg;

  if (!verify_wnd(&wnd)) return;
  if (NEXT == NULL && HEIGHT > 3 && VISIBLE) {
    rg.h.ah=dir==UP ? 6:7;
    rg.h.al=1;
    rg.h.bh=WNORMAL;
    rg.h.cl=COL+1;
    rg.h.ch=ROW+1;
    rg.h.dl=COL+WIDTH-2;
    rg.h.dh=ROW+HEIGHT-2;
    int86(16,&rg,&rg);
	return;
  }
  if (dir==UP) {
    for (row=2;row<HEIGHT-1;row++)
      for (col = 1;col<WIDTH-1;col++) {
        chat=dget(wnd,col,row);
        displ(wnd,col,row-1,chat&255,(chat>>8)&255);
      }
    for (col=1;col<WIDTH-1;col++)
      displ(wnd,col,row-1,' ',WNORMAL);
  }
  else {
    for (row=HEIGHT-2;row>1;--row)
      for(col=1;col<WIDTH-1;col++) {
        chat=dget(wnd,col,row-1);
        displ(wnd,col,row,chat&255,(chat>>8)&255);
      }
    for (col=1;col < WIDTH-1;col++)
      displ(wnd,col,row,' ',WNORMAL);
  }
}

#ifndef FASTWINDOWS

/* Compute address of a window's display character */

static int * pascal waddr (WINDOW *wnd,int x,int y) {

  WINDOW *nxt=NEXT;
  int *vp;

  if (!VISIBLE) return(int *)(SAV+y*(WIDTH*2)+x*2);
  x+=COL;
  y+=ROW;
  while(nxt) {
    if (nxt->_wv)
      if (x>=nxt->_wx && x<= nxt->_wx+nxt->_ww-1)
        if (y>=nxt->_wy && y<=nxt->_wy +nxt->_wh-1) {
            x-=nxt->_wx;
            y-=nxt->_wy;
            vp=(int *)((nxt->_ws)+y*(nxt->_ww*2)+x*2);
            return vp;
        }
        nxt=nxt->_nx;
  }
  return NULL;
}

/* Display a character to a window */

void pascal displ (WINDOW *wnd,int x,int y,int ch,int at) {

    int *vp;
    int vch = ch + (at<<8);

    if((vp=waddr(wnd,x,y))!=NULL) *vp=vch;
    else vpoke(VSG,vad(x+COL,y+ROW),vch);
}

/* Get a displayed character from a window */

static int pascal dget (WINDOW *wnd,int x,int y) {

  int *vp;

  if((vp=waddr(wnd,x,y))!=NULL) return *vp;
  return vpeek(VSG,vad(x+COL,y+ROW));
}

/* Low-level video functions */

/* Swap the video image with the save buffer */

static void pascal vswap (WINDOW *wnd) {

  int x,y,chat;
  int *bf=(int *)SAV;

  for (y=0;y<HEIGHT;y++)
    for (x=0;x<WIDTH;x++) {
      chat=*bf;
      *bf++=dget(wnd,x,y);
      displ(wnd,x,y,chat&255,(chat>>8)&255);
    }
}

#else

/* Save video memory into the save buffer */

static void pascal vsave (WINDOW *wnd) {

  int x,y;
  int *bf=(int *) SAV;

  for(y=0;y<HEIGHT;y++)
    for(x=0;x<WIDTH;x++)
      *bf++=vpeek(VSG,vad(x+COL,y+ROW));
}

/* Restore video memory from the save buffer */

static void pascal vrstr (WINDOW *wnd) {

  int x,y;
  int *bf=(int *)SAV;

  for(y=0;y<HEIGHT;y++)
    for (x=0;x<WIDTH;x++)
	  vpoke(VSG,vad(x+COL,y+ROW),*bf++);
}

#endif

/* (de)Accent the line where SELECT points */

void pascal acline(WINDOW *wnd,int set) {

  int x,ch;

  if (!verify_wnd(&wnd)) return;
  for(x=1;x<WIDTH-1;x++) {
    ch=dget(wnd,x,SELECT) & 255;
    displ(wnd,x,SELECT,ch,set);
  }
}

/* Linked List functions */

/* Add a window to the end of the list */

static void pascal add_list (WINDOW *wnd) {

  if(listtail) {
    PREV=listtail;
    listtail->_nx=wnd;
  }
  listtail=wnd;
  if (!listhead)
    listhead=wnd;
}

/* Add a window to the beginning of the list */

static void pascal beg_list(WINDOW *wnd) {

  if(listhead) {
    NEXT=listhead;
    listhead->_pv=wnd;
  }
  listhead=wnd;
  if(!listtail)
    listtail=wnd;
}

/* Remove a window from the list */

static void pascal remove_list (WINDOW *wnd) {

  if(NEXT)
    NEXT->_pv=PREV;
  if(PREV)
    PREV->_nx=NEXT;
  if (listhead==wnd)
    listhead=NEXT;
  if (listtail==wnd)
    listtail=PREV;
  NEXT=PREV=NULL;
}

/* Insert w1 after w2 */

static void pascal insert_list (WINDOW *w1,WINDOW *w2) {

  w1->_pv=w2;
  w1->_nx=w2->_nx;
  w2->_nx=w1;
  if (w1->_nx==NULL)
    listtail=w1;
  else
    w1->_nx->_pv=w1;
}

#ifndef FASTWINDOWS

/* Verify the presence of a window in the list */

static int pascal verify_wnd (WINDOW **w1) {

  WINDOW *wnd;

  wnd=listhead;
  if(*w1==NULL)
     *w1=listtail;
  else {
     while(wnd !=NULL) {
       if(*w1==wnd)
	 break;
       wnd=NEXT;
     }
  }
  return wnd != NULL;
}

#endif

/* Error messages */

void pascal error_message(char *s) {

  clear_message();
  ewnd=establish_window(50,(maxy-3),3,max(10,strlen(s)+2));
  set_colors(ewnd,ALL,RED,YELLOW,BRIGHT);
  set_colors(ewnd,TITLE,RED,YELLOW,BRIGHT|128);
  set_border(ewnd,5);
  set_title(ewnd," ERROR! ");
  display_window(ewnd);
  wprintf(ewnd,s);
}


void pascal any_message (char *s) {

  clear_message();
  ewnd=establish_window(65,(maxy-4),3,max(9,strlen(s)+2));
  set_border(ewnd,5);
  set_colors(ewnd,ALL,AQUA,BLACK,DIM);
  set_colors(ewnd,TITLE,AQUA,BLACK,BRIGHT);
  set_title(ewnd," NOTE: ");
  display_window(ewnd);
  wprintf(ewnd,s);
}


void pascal _anymsg (char *t,char *s) {

  clear_message();
  ewnd=establish_window(65,(maxy-4),3,max(strlen(s),strlen(t))+2);
  set_border(ewnd,5);
  set_colors(ewnd,ALL,GREEN,BLACK,DIM);
  set_colors(ewnd,TITLE,GREEN,BLACK,BRIGHT);
  set_title(ewnd,t);
  display_window(ewnd);
  wprintf(ewnd,s);
}

void pascal clear_message() {

  if (ewnd) delete_window(ewnd);
  ewnd=NULL;
}


void pascal hide_mouse () {

	union REGS rg;

	if(usemouse) {
	   rg.x.ax=2;  /* Hide mouse cursor */
	   int86(0x33,&rg,&rg);
	   if(oldmousex!=-1)vpoke(VSG,vad(oldmousex,oldmousey),oldmousevid);
	   oldmousex=-1;
	}
}


void pascal show_mouse () {

	union REGS rg;

	if(usemouse) {
        rg.x.ax=1;
        int86(0x33,&rg,&rg);    /* Mouse cursor on */
		rg.x.ax=10;
		rg.x.bx=0;
		rg.x.cx=0xffff;
		rg.x.dx=0x7700;
		int86(0x33,&rg,&rg);    /* Software cursor (not really used) */
	}
}


void pascal pause_msg () {

	union REGS rg;
	int temp=0;

	while(!kbhit()) {
		rg.x.ax=5;
		rg.x.bx=0;
		int86(0x33,&rg,&rg);
		temp+=rg.x.bx;
		rg.x.ax=5;
		rg.x.bx=1;
		int86(0x33,&rg,&rg);
		temp+=rg.x.bx;
		rg.x.ax=5;
		rg.x.bx=2;
		int86(0x33,&rg,&rg);
		temp+=rg.x.bx;
		if(temp) {
			clear_message();
			return;
		}
#ifdef USECLOCK
		print_clock();
#endif
	}
	get_char();
	clear_message();
}


void pascal nopause_msg () {

	union REGS rg;
	int temp=0;

	while(!kbhit()) {
		if(usemouse) {
			rg.x.ax=5;
			rg.x.bx=0;
			int86(0x33,&rg,&rg);
			temp+=rg.x.bx;
			rg.x.ax=5;
			rg.x.bx=1;
			int86(0x33,&rg,&rg);
			temp+=rg.x.bx;
			rg.x.ax=5;
			rg.x.bx=2;
			int86(0x33,&rg,&rg);
			temp+=rg.x.bx;
			if(temp) {
				break;
			}
		}
#ifdef USECLOCK
		print_clock();
#endif
	}
	clear_message();
}


void pascal confine_mouse (WINDOW *wnd) {

	if(usemouse) {          /* Confine mouse to window */

		union REGS rg;

		rg.x.ax=7;
		rg.x.cx=COL*8;
		rg.x.dx=(COL+WIDTH-1)*8;
		int86(0x33,&rg,&rg);
		rg.x.ax=8;
		rg.x.cx=ROW*8;
		rg.x.dx=(ROW+HEIGHT-1)*8;
		int86(0x33,&rg,&rg);
		wasconfinedx1=COL;
		wasconfinedy1=ROW;
		wasconfinedx2=COL+WIDTH-1;
		wasconfinedy2=ROW+HEIGHT-1;
	}
}



int pascal get_screen_char (int x,int y) {

    return vpeek(VSG,vad(x,y))&255;
}


int pascal generic_mouse_input (WINDOW *wnd) {

	union REGS rg;
	int c=0;

	SHOWMOUSE;
	if(usemouse) {
		rg.x.ax=7;
		rg.x.cx=COL*8;
		rg.x.dx=(COL+WIDTH-1)*8;
		int86(0x33,&rg,&rg);
		rg.x.ax=8;
		rg.x.cx=ROW*8;
		rg.x.dx=(ROW+HEIGHT-1)*8;
		int86(0x33,&rg,&rg);
		if(wnd)vpoke(VSG,vad(COL,ROW),254+((WBORDER & 255)<<8));
	}
	while(!kbhit()) {
		c=0;
		if(usemouse) {
			rg.x.ax=3;
			int86(0x33,&rg,&rg);
			move_mouse(rg.x.cx/8,rg.x.dx/8);
			rg.x.ax=5;
			rg.x.bx=0;
			int86(0x33,&rg,&rg);
			if(rg.x.bx) {
				rg.x.cx/=8;
				rg.x.dx/=8;
				if(rg.x.cx==COL && rg.x.dx==ROW) c=ESC;
				else if(rg.x.cx==COL+WIDTH-1 && rg.x.dx==ROW) c=PGUP;
				else if(rg.x.cx==COL && rg.x.dx==ROW+HEIGHT-1) c=PGDN;
				else if(rg.x.cx==COL+WIDTH-1 && rg.x.dx==ROW+HEIGHT-1) c='\r';
				else c=get_screen_char(rg.x.cx,rg.x.dx);
				if(c!=' ' && c)break;
			}
			rg.x.ax=3;
			int86(0x33,&rg,&rg);
			move_mouse(rg.x.cx/8,rg.x.dx/8);
			rg.x.ax=5;
			rg.x.bx=1;
			int86(0x33,&rg,&rg);
			if(rg.x.bx) {
				c=ESC;
				break;
			}
			rg.x.ax=5;
			rg.x.bx=2;
			int86(0x33,&rg,&rg);
			if(rg.x.bx) {
				c='\r';
				break;
			}
		}
	}
	HIDEMOUSE;
	reconfine_mouse();
	if(!c) c=get_char();
	return c;
}




void pascal move_mouse (int x,int y) {

	if(usemouse) {
		if(oldmousex==x && oldmousey==y) return;	/* No change */
		if(oldmousex!=-1) {
			vpoke(VSG,vad(oldmousex,oldmousey),oldmousevid);
		}
		oldmousevid=vpeek(VSG,vad(x,y));
		vpoke(VSG,vad(x,y),oldmousevid ^ 0x7700);
		oldmousex=x;
		oldmousey=y;
	}
}


void pascal reconfine_mouse (void) {

	union REGS rg;

	if(!usemouse || wasconfinedx1==-1) return;

	rg.x.ax=7;
	rg.x.cx=wasconfinedx1;
	rg.x.dx=wasconfinedy1;
	int86(0x33,&rg,&rg);
	rg.x.ax=8;
	rg.x.cx=wasconfinedx2;
	rg.x.dx=(wasconfinedy2)*8;
	int86(0x33,&rg,&rg);
}