/* SHelp.C File -- uses SHARE i/o */

#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include "twindow.h"
#include "keys.h"

extern char * pascal fgetsx(char *,int,int);
extern long tell(int);
extern unsigned char usemouse;

#define MAXHELPS 150
#define HBG WHITE
#define HFG BLACK
#define HINT DIM

#define TRUE  1
#define FALSE 0

static struct helps {
  char hname[9];
  int h,w;
  long hptr;
} hps [MAXHELPS+1];

static int hp=0;
static int ch=0;
static int hx,hy;
int helpfp=-1;
void help();
char helpname[132];
void pascal getline(char *lineh);

/* Load the HELP! definition file */

void pascal load_help (char *hn) {

  extern void (*helpfunc)();
  extern int helpkey;
  char lineh[80];

  if (strcmp(helpname,hn)==0)
    return;
  helpfunc=help;
  helpkey=F1;
  hp=0;
  strcpy(helpname,hn);
  if((helpfp=_open(helpname,O_RDONLY | O_TEXT | O_DENYNONE))==-1)
    return;
  getline(lineh);
  while(1) {
    if(hp==MAXHELPS)
      break;
    if (strncmp(lineh,"<end>",5)==0)
      break;
    if (*lineh != '<')
      continue;
    hps[hp].h=3;
    hps[hp].w=18;
    strncpy(hps[hp].hname,lineh+1,8);
	hps[hp].hptr=tell(helpfp);
    getline(lineh);
    while (*lineh!='<') {
      hps[hp].h++;
      hps[hp].w=max(hps[hp].w,strlen(lineh)+2);
      getline(lineh);
    }
	hp++;
  }
  _close(helpfp);
}

/* Get a line of text from the help file */

static void pascal getline(char *lineh)
{
  if(fgetsx(lineh,80,helpfp)==NULL)
    strcpy(lineh,"<end>");
}

/* Set the current active help screen */

void pascal set_help(char *s,int x,int y)
{
  for (ch=0;ch<hp;ch++)
    if (strncmp(s,hps[ch].hname,8)==0)
      break;
  hx=x;
  hy=y;
}

/* Display the current help window */

void help() {

  char ln[80];
  int i,xx,yy;
  WINDOW *wnd;
  extern int helpkey;

  if((helpfp=_open(helpname,O_RDONLY | O_TEXT | O_DENYNONE))==-1)
    return;
  if (hp && ch !=hp) {
    curr_cursor(&xx,&yy);
    cursor(0,25);
    wnd=establish_window(hx,hy,hps[ch].h,hps[ch].w);
    set_title(wnd," Help! ");
    set_colors(wnd,ALL,HBG,HFG,HINT);
	set_border(wnd,5);
	display_window(wnd);
	lseek(helpfp,hps[ch].hptr,0);
    for(i=0;i<hps[ch].h-3;i++) {
      getline(ln);
      wprintf(wnd,ln);
    }
	wprintf(wnd," <<Continue>>");
	while (!kbhit()) {
		if(usemouse) {

			union REGS rg;

			rg.x.ax=5;
			rg.x.bx=0;
			int86(0x33,&rg,&rg);
			if(rg.x.bx) break;
			rg.x.ax=5;
			rg.x.bx=1;
			int86(0x33,&rg,&rg);
			if(rg.x.bx) break;
			rg.x.ax=5;
			rg.x.bx=2;
			int86(0x33,&rg,&rg);
			if(rg.x.bx) break;

		}
	}
    delete_window(wnd);
    cursor(xx,yy);
  }
  _close(helpfp);
}

