/**************************************************************
    lzhuf.c
    written by Haruyasu Yoshizaki 1988/11/20
    some minor changes 1989/04/06
	comments translated by Haruhiko Okumura 1989/04/07
	This stuff is pretty much the original article, but
	M. Kimes hacked on it in June of 1990
	Screwed with everything to work with XBBS msg bases
**************************************************************/

#include "msgg.h"
#include "twindow.h"
#include "keys.h"
#include "headedit.h"

static int  pascal Encode (void);
static int  pascal Decode (void);
static int  pascal GetBit (void);
static int  pascal GetByte (void);
static void pascal InitTree (void);            /* initialize trees */
static void pascal InsertNode (int r);	       /* insert to tree */
static void pascal DeleteNode (int p);         /* remove from tree */
static void pascal StartHuff (void);           /* init tree */
static void pascal EncodeChar (unsigned c);
static void pascal EncodePosition (unsigned c);
static void pascal EncodeEnd (void);
static int  pascal DecodeChar (void);
static int  pascal DecodePosition (void);
static void pascal Putcode (int l, unsigned c);
static void pascal Lupdate (int c);
static int  pascal alloc_stuff (void);
static void pascal free_stuff (void);

/********** LZSS compression **********/

#define N           4096	    /* buffer size */
#define F           60 			/* lookahead buffer size */
#define THRESHOLD   2
#define NIL         N  			/* leaf of tree */

typedef unsigned char uchar;

static unsigned getbuf;
static uchar getlen;
static unsigned putbuf;
static uchar putlen;
static unsigned int bytesdone, bytestodo;
static int           match_position, match_length;
static unsigned char *text_buf;
static int           *lson;
static int           *rson;
static int           *dad;
static char *inbuf;
static char *outbuf;

/************ Miscellaneous *************/

#define EXIT_FAILURE 1
#define EXIT_SUCCESS 0

extern unsigned int textsize, codesize;
extern struct _xmsg   msg;


int pascal Encode ()  { /* compression */

    int  i, c, len, r, s, last_match_length;
	unsigned int printcount=0;

	if(!alloc_stuff()) {
		printf("\n\x1b[1CCouldn't allocate encode buffers!\n");
		return 0;
	}
	codesize = bytesdone = textsize = 0;
	printf("\x1b[1CCompressing...\n");
	StartHuff();
    InitTree();
    s = 0;
    r = N - F;
	for (i = s; i < r; i++) {
		text_buf[i]=0x20;
	}
	for (len = 0; len < F; len++) {
		c=(int) *inbuf;
		if(!c) break;
		inbuf++;
		bytesdone++;
		if(bytesdone>bytestodo) break;
		text_buf[r+len]=c;
	}
    textsize = len;
	for (i = 1; i <= F; i++) InsertNode(r - i);
    InsertNode(r);
    do {
        if (match_length > len)
            match_length = len;
        if (match_length <= THRESHOLD) {
            match_length = 1;
			EncodeChar(text_buf[r]);
		} else {
			EncodeChar(255 - THRESHOLD + match_length);
			EncodePosition(match_position);
		}
        last_match_length = match_length;
		for (i = 0; i < last_match_length; i++) {
			c=(int)*inbuf;
			if(!c) break;
			inbuf++;
			bytesdone++;
			if(bytesdone>bytestodo) break;
			DeleteNode(s);
			text_buf[s] = c;
            if (s < F - 1)
                text_buf[s + N] = c;
            s = (s + 1) & (N - 1);
            r = (r + 1) & (N - 1);
            InsertNode(r);
		}
		if ((textsize += i) > printcount) {
			printf("\r\x1b[1C%u",textsize);
			printcount += 1024;
        }
		while (i++ < last_match_length) {
            DeleteNode(s);
            s = (s + 1) & (N - 1);
            r = (r + 1) & (N - 1);
            if (--len) InsertNode(r);
		}
	} while (len > 0);
EndIt:
	EncodeEnd();
	printf("\r\x1b[1C%u bytes -> %u bytes",textsize,codesize);
	free_stuff();
	return 1;
}


int pascal Decode ()  { /* recover */

    int  i, j, k, r, c;
	unsigned int count;
	unsigned int printcount=0;

	codesize=0;
	if (textsize<1024) {
		printf("\n\x1b[1CTextsize=%u!\n",textsize);
		return 0;
	}

	if(!alloc_stuff()) {
		printf("\n\x1b[1CCouldn't allocate decode buffers!\n");
		return 0;
	}

	printf("\x1b[13;2H");
	StartHuff();
    for (i = 0; i < N - F; i++) text_buf[i]=0x20;
    r = N - F;
    for (count = 0; count < textsize; ) {
		c = DecodeChar();
        if (c < 256) {
			*outbuf=(char)c;
			outbuf++;
            text_buf[r++] = c;
            r &= (N - 1);
            count++;
		}
		else {
			i = (r - DecodePosition() - 1) & (N - 1);
            j = c - 255 + THRESHOLD;
            for (k = 0; k < j; k++) {
                c = text_buf[(i + k) & (N - 1)];
				*outbuf=(char)c;
				outbuf++;
                text_buf[r++] = c;
                r &= (N - 1);
                count++;
			}
		}
        if (count > printcount) {
			printf("\r\x1b[1C%u  ", count);
			printcount += 1023;
        }
    }
	free_stuff();
	printf("\x1b[13;2H                            ");
/*
if(count>textsize) {
	printf("\x1b[1COVERFLOW: count=%u  textsize=%u\n",count,textsize);
	pause();
}
*/
	return 1;
}


static void pascal InitTree (void) { /* initialize trees */

    int  i;

    for (i = N + 1; i <= N + 256; i++) rson[i] = NIL;    /* root */
    for (i = 0; i < N; i++) dad[i] = NIL;                /* node */
}


static void pascal InsertNode (int r) { /* insert to tree */

    int  i, p, cmp;
    unsigned char  *key;
    unsigned c;

    cmp = 1;
    key = &text_buf[r];
    p = N + 1 + key[0];
    rson[r] = lson[r] = NIL;
    match_length = 0;
    for ( ; ; ) {
        if (cmp >= 0) {
            if (rson[p] != NIL)
                p = rson[p];
            else {
                rson[p] = r;
                dad[r] = p;
                return;
            }
        } else {
            if (lson[p] != NIL)
                p = lson[p];
            else {
                lson[p] = r;
                dad[r] = p;
                return;
            }
        }
        for (i = 1; i < F; i++)
            if ((cmp = key[i] - text_buf[p + i]) != 0)
                break;
        if (i > THRESHOLD) {
            if (i > match_length) {
                match_position = ((r - p) & (N - 1)) - 1;
                if ((match_length = i) >= F)
                    break;
            }
            if (i == match_length) {
                if ((c = ((r - p) & (N - 1)) - 1) < match_position) {
                    match_position = c;
                }
            }
        }
    }
    dad[r] = dad[p];
    lson[r] = lson[p];
    rson[r] = rson[p];
    dad[lson[p]] = r;
    dad[rson[p]] = r;
    if (rson[dad[p]] == p)
        rson[dad[p]] = r;
    else
        lson[dad[p]] = r;
    dad[p] = NIL; /* remove p */
}

static void pascal DeleteNode (int p)  /* remove from tree */
{
    int  q;

    if (dad[p] == NIL)
        return;         /* not registered */
    if (rson[p] == NIL)
        q = lson[p];
    else
    if (lson[p] == NIL)
        q = rson[p];
    else {
        q = lson[p];
        if (rson[q] != NIL) {
            do {
                q = rson[q];
            } while (rson[q] != NIL);
            rson[dad[q]] = lson[q];
            dad[lson[q]] = dad[q];
            lson[q] = lson[p];
            dad[lson[p]] = q;
        }
        rson[q] = rson[p];
        dad[rson[p]] = q;
    }
    dad[q] = dad[p];
    if (rson[dad[p]] == p)
        rson[dad[p]] = q;
    else
        lson[dad[p]] = q;
    dad[p] = NIL;
}

/* Huffman coding */

#define N_CHAR   (256 - THRESHOLD + F)
				 /* kinds of characters (character code = 0..N_CHAR-1) */
#define T        (N_CHAR * 2 - 1)    /* size of table */
#define R        (T - 1)         /* position of root */
#define MAX_FREQ 0x8000      /* updates tree when the */
				 /* root frequency comes to this value. */


/* table for encoding and decoding the upper 6 bits of position */

/* for encoding */
uchar p_len[64] = {
    0x03, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08
};

uchar p_code[64] = {
    0x00, 0x20, 0x30, 0x40, 0x50, 0x58, 0x60, 0x68,
    0x70, 0x78, 0x80, 0x88, 0x90, 0x94, 0x98, 0x9C,
    0xA0, 0xA4, 0xA8, 0xAC, 0xB0, 0xB4, 0xB8, 0xBC,
    0xC0, 0xC2, 0xC4, 0xC6, 0xC8, 0xCA, 0xCC, 0xCE,
    0xD0, 0xD2, 0xD4, 0xD6, 0xD8, 0xDA, 0xDC, 0xDE,
    0xE0, 0xE2, 0xE4, 0xE6, 0xE8, 0xEA, 0xEC, 0xEE,
    0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
    0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF
};

/* for decoding */
uchar d_code[256] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
    0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
    0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
    0x0C, 0x0C, 0x0C, 0x0C, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x0F, 0x0F, 0x0F,
    0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x11,
    0x12, 0x12, 0x12, 0x12, 0x13, 0x13, 0x13, 0x13,
    0x14, 0x14, 0x14, 0x14, 0x15, 0x15, 0x15, 0x15,
    0x16, 0x16, 0x16, 0x16, 0x17, 0x17, 0x17, 0x17,
    0x18, 0x18, 0x19, 0x19, 0x1A, 0x1A, 0x1B, 0x1B,
    0x1C, 0x1C, 0x1D, 0x1D, 0x1E, 0x1E, 0x1F, 0x1F,
    0x20, 0x20, 0x21, 0x21, 0x22, 0x22, 0x23, 0x23,
    0x24, 0x24, 0x25, 0x25, 0x26, 0x26, 0x27, 0x27,
    0x28, 0x28, 0x29, 0x29, 0x2A, 0x2A, 0x2B, 0x2B,
    0x2C, 0x2C, 0x2D, 0x2D, 0x2E, 0x2E, 0x2F, 0x2F,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
};

uchar d_len[256] = {
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
};

unsigned freq[T + 1]; /* frequency table */

int prnt[T + N_CHAR]; /* pointers to parent nodes, except for the */
            /* elements [T..T + N_CHAR - 1] which are used to get */
            /* the positions of leaves corresponding to the codes. */

int son[T]; /* pointers to child nodes (son[], son[] + 1) */


static int pascal GetBit () {    /* get one bit */

	unsigned i;

    while (getlen <= 8) {
		if ((int)(i = (int)*inbuf) < 0) i = 0;
		inbuf++;
		bytesdone++;
        getbuf |= i << (8 - getlen);
        getlen += 8;
    }
    i = getbuf;
    getbuf <<= 1;
    getlen--;
    return (int)((i & 0x8000) >> 15);
}

static int pascal GetByte () {   /* get one byte */

	unsigned i;

    while (getlen <= 8) {
		if ((int)(i = (int)*inbuf) < 0) i = 0;
		inbuf++;
		bytesdone++;
        getbuf |= i << (8 - getlen);
        getlen += 8;
    }
    i = getbuf;
    getbuf <<= 8;
    getlen -= 8;
    return (int)((i & 0xff00) >> 8);
}



static void pascal Putcode (int l, unsigned c) {    /* output c bits of code */

	putbuf |= c >> putlen;
    if ((putlen += l) >= 8) {
		*outbuf=(char)(putbuf >> 8);
		outbuf++;
        if ((putlen -= 8) >= 8) {
			*outbuf=(char)putbuf;
			outbuf++;
            codesize += 2;
            putlen -= 8;
            putbuf = c << (l - putlen);
        } else {
            putbuf <<= 8;
            codesize++;
        }
    }
}


/* initialization of tree */

static void pascal StartHuff (void) {

	int i, j;

    for (i = 0; i < N_CHAR; i++) {
        freq[i] = 1;
        son[i] = i + T;
        prnt[i + T] = i;
    }
    i = 0; j = N_CHAR;
    while (j <= R) {
        freq[j] = freq[i] + freq[i + 1];
        son[j] = i;
        prnt[i] = prnt[i + 1] = j;
        i += 2; j++;
    }
    freq[T] = 0xffff;
	prnt[R] = 0;
	putbuf=getbuf=0;
	putlen=getlen=0;
}


/* reconstruction of tree */

static void pascal reconst (void) {

    int i, j, k;
    unsigned f, l;

    /* collect leaf nodes in the first half of the table */
    /* and replace the freq by (freq + 1) / 2. */
    j = 0;
    for (i = 0; i < T; i++) {
        if (son[i] >= T) {
            freq[j] = (freq[i] + 1) / 2;
            son[j] = son[i];
            j++;
        }
    }
    /* begin constructing tree by connecting sons */
    for (i = 0, j = N_CHAR; j < T; i += 2, j++) {
        k = i + 1;
        f = freq[j] = freq[i] + freq[k];
        for (k = j - 1; f < freq[k]; k--);
        k++;
        l = (j - k) * 2;
        memmove(&freq[k + 1], &freq[k], l);
        freq[k] = f;
        memmove(&son[k + 1], &son[k], l);
        son[k] = i;
    }
    /* connect prnt */
    for (i = 0; i < T; i++) {
        if ((k = son[i]) >= T) {
            prnt[k] = i;
        } else {
            prnt[k] = prnt[k + 1] = i;
        }
    }
}


/* increment frequency of given code by one, and update tree */

static void pascal Lupdate (int c) {

	int i, j, k, l;

    if (freq[R] == MAX_FREQ) {
        reconst();
    }
    c = prnt[c + T];
    do {
        k = ++freq[c];

        /* if the order is disturbed, exchange nodes */
        if (k > freq[l = c + 1]) {
            while (k > freq[++l]);
            l--;
            freq[c] = freq[l];
            freq[l] = k;

            i = son[c];
            prnt[i] = l;
            if (i < T) prnt[i + 1] = l;

            j = son[l];
            son[l] = i;

            prnt[j] = c;
            if (j < T) prnt[j + 1] = c;
            son[c] = j;

            c = l;
        }
    } while ((c = prnt[c]) != 0); /* repeat up to root */
}

unsigned code, len;

static void pascal EncodeChar (unsigned c) {

	unsigned i;
    int j, k;

    i = 0;
    j = 0;
    k = prnt[c + T];

    /* travel from leaf to root */
    do {
        i >>= 1;

        /* if node's address is odd-numbered, choose bigger brother node */
        if (k & 1) i += 0x8000;

        j++;
    } while ((k = prnt[k]) != R);
	Putcode(j, i);
    code = i;
    len = j;
	Lupdate(c);
}

static void pascal EncodePosition (unsigned c) {

	unsigned i;

    /* output upper 6 bits by table lookup */
    i = c >> 6;
	Putcode(p_len[i], (unsigned)p_code[i] << 8);

    /* output lower 6 bits verbatim */
	Putcode(6, (c & 0x3f) << 10);
}

static void pascal EncodeEnd () {

	if (putlen) {
		*outbuf=(char)(putbuf >> 8);
		outbuf++;
        codesize++;
    }
}

static int pascal DecodeChar () {

	unsigned c;

    c = son[R];

    /* travel from root to leaf, */
    /* choosing the smaller child node (son[]) if the read bit is 0, */
    /* the bigger (son[]+1} if 1 */
    while (c < T) {
		c += GetBit();
        c = son[c];

    }
    c -= T;
    Lupdate(c);
    return (int)c;
}

static int pascal DecodePosition () {

	unsigned i, j, c;

    /* recover upper 6 bits from table */
	i = GetByte();
    c = (unsigned)d_code[i] << 6;
    j = d_len[i];

    /* read lower 6 bits verbatim */
    j -= 2;
    while (j--) {
		i = (i << 1) + GetBit();
    }
    return (int)(c | (i & 0x3f));
}


char * pascal unpack_msg (char **hold) {

	char *pp;
	static char *tempbuf;

	pp=*hold;
    *hold=NULL;
	textsize=(word)atol(pp);
/* printf("\x1b[13;1H\x1b[KTextsize=%u\n",textsize); */
	if(textsize<1024) {
		printf("\n\x1b[1CError in textsize\n");
		if(pp)free(pp);
		return NULL;
	}
	tempbuf=pp;
	while(*tempbuf && *tempbuf!='\r') tempbuf++;
	if(*tempbuf=='\r') tempbuf++;
	else goto Grunged;
	while(*tempbuf && *tempbuf!='\r') tempbuf++;
	if(*tempbuf=='\r') tempbuf++;
	else goto Grunged;
	while(*tempbuf && *tempbuf!='\r') tempbuf++;
	if(*tempbuf=='\r') tempbuf++;
	else {
Grunged:
		error_message(" Grunged msg ");
        if(pp)free(pp);
        pause();
		return NULL;
	}
	inbuf=tempbuf;
	outbuf=(char *)malloc((unsigned)(sizeof(char) * textsize)+256);
	if(!outbuf) {
		error_message(" Can't allocate memory to uncompress ");
        if(pp)free(pp);
        pause();
        return NULL;
	}
	tempbuf=outbuf;
    if(!Decode()){
        if(tempbuf)free(tempbuf);
        tempbuf=NULL;
    }
    else tempbuf[textsize]=0;
	if(pp)free(pp);
	*hold=tempbuf;
	return tempbuf;
}


char * pascal pack_msg (char *hold) {

	char *tempo;
	char lastmsgid[80]="";
	char lastreply[80]="";
	unsigned int temp;
	static char *tempbuf;
	char textlen[18];

  if(strlen(hold)<1024) return NULL;	/* Too small to jack with */
  if(tempo=strstr(hold,"\01MSGID:")) {
	strncpy(lastmsgid,&tempo[7],80);
	lastmsgid[79]=0;
	tempo=strchr(lastmsgid,'\r');
	if(tempo)*tempo=0;
	lstrip(lastmsgid);
	rstrip(lastmsgid);
  }
  else *lastmsgid=0;
  if(tempo=strstr(hold,"\01REPLY:")) {
	strncpy(lastreply,&tempo[7],80);
	lastreply[79]=0;
	tempo=strchr(lastreply,'\r');
	if(tempo)*tempo=0;
	lstrip(lastreply);
	rstrip(lastreply);
  }
  else *lastreply=0;
  textsize=strlen(hold);
  bytestodo=textsize;
  outbuf=(char *)malloc((sizeof(char)*textsize)+256);
  if(!outbuf) {
	error_message(" Can't allocate memory to compress ");
	pause();
	free(hold);
	return NULL;
  }
  tempbuf=outbuf;
  inbuf=hold;
  if(!Encode()) {
	free(tempbuf);
	free(hold);
	return NULL;
  }
  sprintf(textlen,"%01u",bytestodo);
  if(hold)free(hold);
  hold=(char *)malloc(((sizeof(char)*codesize)+2)+(strlen(lastmsgid)+1)+
	(strlen(lastmsgid)+1)+(strlen(textlen)+1));
  if(!hold) {
	error_message(" Can't allocate memory to compress ");
	pause();
	free(tempbuf);
	return NULL;
  }
  sprintf(hold,"%s\r%s\r%s\r",textlen,lastmsgid,lastreply);
  temp=strlen(hold);
  tempo=&hold[temp];
  memcpy(tempo,tempbuf,codesize);
  if(tempbuf)free(tempbuf);
  msg.length=temp+codesize+1;
  return hold;
}


static int pascal alloc_stuff (void) {

	text_buf=(unsigned char *)malloc(sizeof(char)*(N+F-1));
    if(!text_buf) return 0;
	lson=(int *)malloc(sizeof(int)*(N+1));
    if(!lson) {
        free(text_buf);
        return 0;
    }
	rson=(int *)malloc(sizeof(int)*(N+257));
    if(!rson) {
        free(text_buf);
        free(lson);
        return 0;
    }
	dad=(int *)malloc(sizeof(int)*(N+1));
    if(!dad) {
        free(text_buf);
        free(lson);
        free(rson);
        return 0;
    }
    return 1;
}

void pascal free_stuff (void) {

    free(text_buf);
    free(lson);
    free(rson);
    free(dad);
}
