#  Turbo C make file for CKIT
#
#  You will need to set some paths below for TLINK and
# set you memory model below to MODEL=s or MODEL=m for
# whichever memory model you are using. (small or medium)
#

# Must have this MACRO defined for CKITDEMO to compile correctly
# This is only necassary when compiling the CKITDEMO.C program
# since it was designed to be compiled with MSC or TURBO C.
# (the -DCOMPILER switch in ckitdemo.mak)
-DCOMPILER=TURBOC

# Memory model to use
MODEL=m


# compiler flags, MUST use the -a flag for WORD alignment!
# These flags are set for NO stack checking, WORD alignment, compile only,
# standard stack frame. Macro COMPILER is used CKITDEMO.C

CFLAGS=-m$(MODEL) -N- -a -r- -c -k -v -M- -y- -DCOMPILER=TURBOC
TCC=TCC $(CFLAGS)

# Library locations
LIB=E:\TC\LIB


#General inference rules
#Rule to make .OBJ from .C files

.C.OBJ:
      $(TCC) $*.C

# Rule to make executable
OBJLIST=ckitdemo.obj

ckitdemo.exe:  $(OBJLIST)

# I could not get TLINK to look in the enviroment for LIB paths
# or get TCC to include the info. for TLINK to use the LIB files
# needed.  I had to include the paths\filenames on the cmd line
# below so you will need to modify them for you paths etc.

 TLINK /l /m $(LIB)\c0$(MODEL) $(OBJLIST), ckitdemo.exe,, \
  $(LIB)\c$(MODEL).lib ckit_t$(MODEL).lib

# Dependencies for obj files

ckitdemo.obj:  ckitdemo.c  ckitdemo.h ckit.h
