;Ŀ
;   ASK was compiled with MASM v5.10 and has been placed into  
;   the public domain.                                         
;   Direct any questions to Michael Stangel                    
;                           (217)367-1095                      
;                           stangel@uiuc.edu  (Internet)       
;                           September 19, 1991                 
;
STKSEG  SEGMENT STACK                   ;Stack segment
        DB      128 DUP(?)              ;(128 bytes ought to do)
STKSEG  ENDS

CSEG    SEGMENT                         ;Code segment
        ASSUME  CS:CSEG, DS:CSEG, SS:STKSEG, ES:NOTHING

CR      EQU     0Dh
LF      EQU     0Ah

QUERY	DB	128 DUP(?)		;Query string
TESTR   DB      'Enter character to get ASCII value:',CR,LF,'$'
TESTFL  DB      0
ANSWER  DB      CR,LF,'The corresponding ASCII value is '
ANSVAL  DB      '***.',CR,LF,'$'
HELPFL  DB      0
HELP1   DB      'ASK.EXE will allow you to obtain simple interactive input',CR,LF
        DB      'in a batch file.  The response to the question may only be',CR,LF
        DB      'a single character.  The utility will set the DOS errorlevel',CR,LF
        DB      'equal to the ASCII value of the character typed.  You should',CR,LF
        DB      'use the errorlevel as follows:',CR,LF,CR,LF
        DB      '         ask Do you want to run the word processor?',CR,LF
        DB      '         if errorlevel==89 wp.exe',CR,LF
        DB      '         if errorlevel==121 wp.exe',CR,LF,CR,LF
        DB      'Note that you should test for both the capital Y and',CR,LF
        DB      'the small y.  You can also test whether or not the',CR,LF
        DB      'errorlevel is less than or equal to a number, such as:',CR,LF,CR,LF
        DB      '        ask Enter 1, 2 or 3 for instructions:',CR,LF
        DB      '        if errorlevel 51 help.com',CR,LF,CR,LF
        DB      '(Recall the the ASCII value for the digit 3 is 51)',CR,LF,CR,LF
        DB      'If you like a space between the end of your query string',CR,LF
        DB      'and the cursor that waits for the input, you may put a',CR,LF
        DB      'NULL character there by typing ALT+255.',CR,LF,CR,LF
        DB      '***PRESS ANY KEY***$'
HELP2   DB      CR,LF,'Some common ASCII values you may wish to test for:',CR,LF
        DB      '        Y = 089',CR,LF
        DB      '        y = 121',CR,LF
        DB      '        N = 078',CR,LF
        DB      '        n = 110',CR,LF
        DB      '        0 = 048',CR,LF
        DB      '        1 = 049',CR,LF
        DB      '        9 = 057',CR,LF
        DB      '  [Enter] = 013',CR,LF
        DB      '    [Esc] = 027',CR,LF,CR,LF
        DB      'Furthermore, you can find the ASCII value of a character',CR,LF
        DB      'by typing ask -q and entering the character when asked.',CR,LF,CR,LF
        DB      'ASK was compiled with MASM v5.10 and has been placed into',CR,LF
        DB      'the public domain.',CR,LF,CR,LF
        DB      'Direct any questions to Michael Stangel',CR,LF
        DB      '                        (217)367-1095',CR,LF
        DB      '                        stangel@uiuc.edu  (Internet)',CR,LF,CR,LF
        DB      'September 19, 1991',CR,LF,CR,LF,'$'


MAIN    PROC    FAR
        MOV     AX, CSEG                ;Initialize DS register
        MOV     DS, AX
	CALL	ARG			;get argument into QUERY
	LEA	DX,QUERY
	MOV	AH,9
	INT	21h			;print query
	MOV	AH,1
        CMP     HELPFL,1                ;was this a help screen?
        JE      QUIT
        INT     21h                     ;wait for key (put into AL)
        CMP     TESTFL,1                ;was this a test?
        JNE     QUIT
        MOV     AH,0                    ;clear out word
        MOV     BL,100                  ;first divide by 100
        DIV     BL                      ;get 100s digit
        ADD     AL,30h                  ;make it an ASCII digit
        MOV     ANSVAL,AL
        MOV     AL,AH
        MOV     AH,0                    ;clear out word
        MOV     BL,10                   ;now divide by 10
        DIV     BL
        ADD     AL,30h                  ;make them ASCII
        ADD     AH,30h
        MOV     ANSVAL+1,AL
        MOV     ANSVAL+2,AH
        LEA     DX,ANSWER
        MOV     AH,9
        INT     21h
QUIT:   MOV     AH,4Ch                  ;DOS code to exit
        INT     21h                     ;(exit)
MAIN    ENDP

;ARG will get the command-line argument and store it in QUERY
;unless it detects a switch char ('-') at the beginning
ARG     PROC    NEAR
	PUSH	AX
	PUSH	BX
	PUSH	DX
	PUSH	DS
	PUSH	ES			;transfer ES to data seg
	POP	DS
	LEA	BX,QUERY		;get location of QUERY
	MOV	SI,80h			;get length of parameter string
	CMP	BYTE PTR [SI],0		;nul parameter?
	JZ	DONE
	INC	SI			;move into text
	INC	SI
        CMP     BYTE PTR [SI],'-'       ;switch char?
        JE      SWITCH
PRM:	LODSB				;get next char
	CMP	AL,0Dh			;end of line?
	JZ	DONE			;yes--done
	MOV	CS:[BX],AL		;store char in QUERY
	INC	BX
	LOOP	PRM
        JMP     DONE
SWITCH: INC     SI                      ;move past '-'
        CMP     BYTE PTR [SI],'q'       ;querying a character?
        JNE     NOQ1
        POP     DS                      ;restore data segment
        PUSH    DS
        LEA     SI,TESTR
        MOV     CS:TESTFL,1
        JMP     PRM
NOQ1:   CMP     BYTE PTR [SI],'Q'
        JNE     NOQ2
        POP     DS
        PUSH    DS
        LEA     SI,TESTR
        MOV     CS:TESTFL,1
        JMP     PRM
NOQ2:   CMP     BYTE PTR [SI],'?'       ;help request?
        POP     DS
        PUSH    DS
        LEA     DX,HELP1
        MOV     AH,9
        INT     21h
        MOV     AH,1
        INT     21h
        LEA     DX,HELP2
        MOV     AH,9
        INT     21h
        MOV     HELPFL,1
DONE:	MOV	BYTE PTR CS:[BX],'$'	;End-Of-String
	POP	DS
	POP	DX
	POP	BX
	POP	AX
	RET
ARG	ENDP

CSEG    ENDS                            ;End of code segment
        END     MAIN                    ;Start execution at "MAIN".
