/****************************************************************

	ui_dial.c       Dialog-box and alarm-box routines for
			The Bywater Graphical User Interface

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

****************************************************************/

#include "stdio.h"
#include "gr.h"
#include "ui.h"

ui_dial( x1, y1, x2, y2, background, foreground, marker_color, shadow,
   title, text, prompt, buffer, i_window )
   int x1, y1, x2, y2, background, foreground, shadow, marker_color;
   char *title, *text, *prompt, *buffer;
   struct uiwindow **i_window;
   {
   static struct uiwindow *window;
   register int x, y;

   /* Draw the box */

   if ( *i_window == NULL )
      {
      window = *i_window = ui_window( x1, y1, x2, y2, TRUE, background,
	 foreground, title, TRUE, BLACK,
	 shadow, BLACK, background, SOLID, BUT_CLOSE );
      }
   else
      {
      window = *i_window;
      ui_rewindow( window, title );
      }

   /* Write the text string to the box */

   ui_text( window->u_x1 + gr_strlen( "   " ),
      window->u_y1 + ( ui_grwind->fysize * 3 ),
      window->u_x2, window->u_y2, 20, background, foreground, 
      text );

   /* Set array coordinates for prompt and entry string */

   x = window->u_x1 + gr_strlen( "======" );
   y = window->u_y1 + ( ui_grwind->fysize * 2 );

   /* Display a marker */ 

   gr_circle( ui_screen, x,
      y + ui_grwind->fysize / 2,
      ui_grwind->fysize / 4, marker_color, SOLID );
   x += ui_grwind->fysize * 2;

   /* Display the prompt string */

   ui_str( x, y, window->u_x2,
      background, foreground, prompt );
   x += gr_strlen( prompt );

   /* Get the string from the box */

   ui_gets( window, x, y, 64, buffer,
      TRUE, foreground, background );

   }

ui_yn( x1, y1, x2, y2, background, foreground, marker_color, shadow,
   text, mes0, mes1, i_window )
   int x1, y1, x2, y2, background, foreground, shadow, marker_color;
   char *text, *mes0, *mes1;
   struct uiwindow **i_window;
   {
   static struct uiwindow *window;
   register int x, y;
   int y_x1, y_y1, y_x2, y_y2;
   int n_x1, n_y1, n_x2, n_y2;
   int carry_on, mo_xsrc, mo_ysrc, test, key;
   static int x_pos, y_pos, b_stat;
   
   /* Draw the box */

   if ( *i_window == NULL )
      {
      window = *i_window = ui_window( x1, y1, x2, y2, FALSE, background,
         foreground, "", 1, 0, 
	 shadow, 0, background, 1, 0 );
      }
   else
      {
      window = *i_window;
      ui_rewindow( window, "" );
      }

   /* Write the text string to the box */

   ui_text( window->u_x1 + gr_strlen( "   " ),
      window->u_y1 + ( ui_grwind->fysize * 3 ),
      window->u_x2, window->u_y2, 20, background, foreground, 
      text );

   /* Set array coordinates for capsules */

   x = window->u_x1 + (( window->u_x2 - window->u_x1 ) / 3 );
   y = window->u_y1 + ( ui_grwind->fysize * 2 );

   y_x1 = x - ( gr_strlen( mes1 ) / 2 );
   y_x2 = x + ( gr_strlen( mes1 ) / 2 );

   n_y1 = y_y1 = y;
   n_y2 = y_y2 = y + (( ui_grwind->fysize * 3 ) / 2 );

   x = x + (( window->u_x2 - window->u_x1 ) / 3 );
   n_x1 = x - ( gr_strlen( mes0 ) / 2 );
   n_x2 = x + ( gr_strlen( mes0 ) / 2 );

   /* show capsules and their text */

   uid_capsule( y_x1, y_y1, y_x2, y_y2, BLACK, SOLID );
   uid_capsule( n_x1, n_y1, n_x2, n_y2, BLACK, SOLID );

   gr_text( ui_screen, y_x1,
      y_y1 + (( ui_grwind->fysize * 10 ) / 40 ),
      mes1, background, foreground );

   gr_text( ui_screen, n_x1,
      n_y1 + (( ui_grwind->fysize * 10 ) / 40 ),
      mes0, background, foreground );

   /* loop for response */

   carry_on = TRUE;
   while ( carry_on == TRUE )
      {
      if ( kb_rxstat() == TRUE )
         {
         key = kb_rx();

         switch( key )
            {
            case 'Y':
            case 'y':
               return TRUE;
               break;
            case 'N':
            case 'n':
               return FALSE;
               break;
            default:
               break;
            }
         }

      else if ( gr_ismouse == TRUE )
         {

         if ( gr_mouse( SAMPLE, &x_pos, &y_pos, &b_stat )
            == TRUE )
            {
            key = 0;
            test = TRUE;
            gr_mouse( WAIT, &x_pos, &y_pos, &b_stat );
            mo_xsrc = x_pos;
            mo_ysrc = y_pos;
            gr_mouse( WAIT, &x_pos, &y_pos, &b_stat );
            }
         
         if ( test == TRUE )
            {
	    if ( uil_bounds( x_pos, y_pos, y_x1, y_y1, y_x2, y_y2 ) == TRUE )
               {
               return TRUE;
               }
	    else if ( uil_bounds( x_pos, y_pos, n_x1, n_y1, n_x2, n_y2 ) == TRUE )
               {
               return FALSE;
               }
            }

         test = FALSE;
         }

      else
         {
	 ui_poll();
         }
      }

   }

ui_alarm( x1, y1, x2, y2, background, foreground, marker_color, shadow,
   text, prompt, i_window )
   int x1, y1, x2, y2, background, foreground, shadow, marker_color;
   char *text, *prompt;
   struct uiwindow **i_window;
   {
   static struct uiwindow *window;
   int y_x1, y_y1, y_x2, y_y2;
   register int x, y;
   int carry_on, mo_xsrc, mo_ysrc, test, key;
   static int x_pos, y_pos, b_stat;

   /* Draw the box */

   if ( *i_window == NULL )
      {
      *i_window = window = ui_window( x1, y1, x2, y2, FALSE, background,
         foreground, "", 1, 0, 
	 shadow, 0, background, 1, 0 );
      }
   else
      {
      window = *i_window;
      ui_rewindow( window, "" );
      }

   /* Write the text string to the box */

   ui_text( window->u_x1 + gr_strlen( "   " ),
      window->u_y1 + ( ui_grwind->fysize * 3 ),
      window->u_x2, window->u_y2, 20, background, foreground, 
      text );

   /* Set array coordinates for capsules */

   x = window->u_x1 + ((( window->u_x2 - window->u_x1 ) / 3 ) * 2 );
   y = window->u_y1 + ( ui_grwind->fysize * 2 );

   y_x1 = x - ( gr_strlen( prompt ) / 2 );
   y_x2 = x + ( gr_strlen( prompt ) / 2 );

   y_y1 = y;
   y_y2 = y + (( ui_grwind->fysize * 3 ) / 2 );

   /* show capsule and text */

   uid_capsule( y_x1, y_y1, y_x2, y_y2, BLACK, SOLID );

   gr_text( ui_screen, y_x1,
      y_y1 + (( ui_grwind->fysize * 10 ) / 40 ),
      prompt, background, foreground );

   /* loop for response */

   carry_on = TRUE;
   while ( carry_on == TRUE )
      {
      if ( kb_rxstat() == TRUE )
         {
         key = kb_rx();
         return key;
         }

      else if ( gr_ismouse == TRUE )
         {

         if ( gr_mouse( SAMPLE, &x_pos, &y_pos, &b_stat )
            == TRUE )
            {
            key = 0;
            test = TRUE;
            gr_mouse( WAIT, &x_pos, &y_pos, &b_stat );
            mo_xsrc = x_pos;
            mo_ysrc = y_pos;
            gr_mouse( WAIT, &x_pos, &y_pos, &b_stat );
            }
         
         if ( test == TRUE )
            {
	    if ( uil_bounds( x_pos, y_pos, y_x1, y_y1, y_x2, y_y2 ) == TRUE )
               {
               return TRUE;
               }
            }

         test = FALSE;
         }

      else
         {
	 ui_poll();
         }
      }

   }

ui_disp( x1, y1, x2, y2, background, foreground, shadow, title, text,
   i_window )
   int x1, y1, x2, y2, background, foreground, shadow;
   char *title, *text;
   struct uiwindow **i_window;
   {
   static struct uiwindow *window;

   /* Draw the box */

   if ( *i_window == 0 )
      {
      *i_window = window = ui_window( x1, y1, x2, y2, TRUE, background,
         foreground, title, 1, 0, 
	 shadow, 0, background, 1, BUT_CLOSE );
      }
   else
      {
      window = *i_window;
      ui_rewindow( window, title );
      }

   /* Write the text string to the box */

   ui_text( window->u_x1 + gr_strlen( "   " ),
      window->u_y1 + ui_grwind->fysize,
      window->u_x2, window->u_y2, 20, background, foreground, 
      text );

   }

uid_capsule( x1, y1, x2, y2, color, style )
   int x1, y1, x2, y2, color, style;
   {
   int r, x, y;

   x = x1;
   r = ((( y2 - y1 ) * 30 ) / 60 );
   y = y1 + r;
   gr_circle( ui_screen, x, y, r, color, style );
   x = x2;
   gr_circle( ui_screen, x, y, r, color, style );
   ui_fbox( x1, y1, x2, y2, color, style );
   
   }
