 Title 'Wolfware Assembler Sample', 'Pascal Printer Function'

;===============================================;
;  Turbo Pascal Printer Function Version 1.00   ;
;                                               ;
; This program is a machine language printer    ;
; routine for Turbo Pascal.  This routine       ;
; creates a function that returns true if the   ;
; first parallel printer does not exist or is   ;
; not ready.                                    ;
;                                               ;
; Assuming that the file is assembled to        ;
; PRINT.COM, the routine should be declared in  ;
; a Pascal program in the following manner:     ;
;                                               ;
;   FUNCTION PRINTER_ERROR:BOOLEAN;             ;
;     EXTERNAL 'PRINT.COM';                     ;
;                                               ;
; Having done so, PRINTER may be used as a      ;
; normal Pascal function.  Example:             ;
;                                               ;
;   IF PRINTER_ERROR THEN                       ;
;     WRITELN ('Printer is not ready');         ;
;                                               ;
; Uses the printer BIOS routine.  Assumes that  ;
; all relevant registers will be saved (as they ;
; should be with an IBM or truly compatible     ;
; BIOS).                                        ;
;===============================================;

 Proc Near

;----- equates

Prn_Number Equ 0         ;parallel printer number
Error_Bits Equ 00101001b ;printer error bits (must not be set)
Ready_Bits Equ 10010000b ;printer ready bits (must be set)

;----- get printer status

 Mov Ah, 2              ;function number
 Mov Dx, Prn_Number     ;printer number
 Int 17h                ;execute

;----- test printer status

 Mov Al, Ah
 And Al, Error_Bits     ;mask out error bits
 And Ah, Ready_Bits     ;mask out ready bits
 Xor Ah, Ready_Bits     ;set missing ready bits
 Or Al, Ah              ;combine all error bits and set ZF flag
 Ret
 Endp                   ;main program

