RMCALL_VECT     =       34h     ; vector of RM int caller routine ( >=32h )
N_DSC           =       8       ; number of free descriptors
N_INT           =       8       ; number of free interrupt gates

seg_descriptor  struc
  limit0_15     dw      0       ; g=granularity bit; x=default bit for a code
  base0_15      dw      0       ;  seg, x=big bit for a data seg: if data seg
  base16_23     db      0       ;  expands down: b=0 -> upper bound is 64K-1
  access        db      0       ;  b=1 -> upper bound is 4G-1, x=big bit for
  gx00limit16_19 db     0       ;  a stack seg too -> determines stack
  base24_31     db      0       ;  address-size attribute (sp <-> esp)
seg_descriptor  ends

TSS             struc
backlink        dw      0, 0            ; selector of the outgoing task's TSS
esp0            dd      0               ; privilege level 0 stack pointers
ss0             dd      0
esp1            dd      0               ; privilege level 1 stack pointers
ss1             dd      0
esp2            dd      0               ; privilege level 2 stack pointers
ss2             dd      0
@cr3            dd      0
eip             dd      0
eflags          dd      0
@eax            dd      0
@ecx            dd      0
@edx            dd      0
@ebx            dd      0
@esp            dd      0
@ebp            dd      0
@esi            dd      0
@edi            dd      0
@es             dd      0
@cs             dd      0
@ss             dd      0
@ds             dd      0
@fs             dd      0
@gs             dd      0
ldtr            dw      0, 0,0
io_map_base     dw      104             ; offset I/O map from the start of
TSS             ends                    ;  the Task State Segment

ifndef  NO_EXTERN

public  main

extrn   v86r_al:byte, v86r_ah:byte, v86r_bl:byte, v86r_bh:byte
extrn   v86r_cl:byte, v86r_ch:byte, v86r_dl:byte, v86r_dh:byte
extrn   v86r_ax:word, v86r_bx:word, v86r_cx:word, v86r_dx:word
extrn   v86r_si:word, v86r_di:word, v86r_bp:word, v86r_sp:word
extrn   v86r_flags:word
extrn   v86r_eax:dword, v86r_ebx:dword, v86r_ecx:dword, v86r_edx:dword
extrn   v86r_esi:dword, v86r_edi:dword, v86r_ebp:dword
extrn   v86r_ds:word, v86r_es:word, v86r_fs:word, v86r_gs:word, v86r_ss:word
extrn   totalextmem:dword, systemtype:byte, code16a:dword, code32a:dword
extrn   lomembase:dword, lomemtop:dword, himembase:dword, himemtop:dword
extrn   code32sel:word, data32sel:word, zerosel:word
extrn   code16sel:word, data16sel:word, pspsel:word, envsel:word
extrn   IRQ0_vect:byte, IRQ8_vect:byte
extrn   hextbl:byte, windows:byte, returncode:byte

extrn   exit:near, getmem:near, getlomem:near, gethimem:near
extrn   lomemsize:near, himemsize:near
extrn   getdsc:near, setdsc:near, getvect:near, setvect:near
extrn   map_phys_addr:near, dosshell:near, dosprint:near, putstr:near

else

stackseg segment para stack
stackseg ends
code16  segment para public use16
code16  ends
code32  segment para public use32
code32  ends

; Declare any additional segments here
v86code segment para public use16
v86code ends
RMseg   segment para public use16
RMseg   ends

; All additional segments have to be declared before codeend
codeend segment para public
codeend ends

public  v86r_al, v86r_ah, v86r_bl, v86r_bh, v86r_cl, v86r_ch, v86r_dl, v86r_dh
public  v86r_ax, v86r_bx, v86r_cx, v86r_dx, v86r_si, v86r_di, v86r_bp, v86r_sp
public  v86r_flags
public  v86r_eax, v86r_ebx, v86r_ecx, v86r_edx, v86r_esi, v86r_edi, v86r_ebp
public  v86r_ds, v86r_es, v86r_fs, v86r_gs, v86r_ss
public  code16a, code32a, lomembase, lomemtop, himembase, himemtop
public  totalextmem, systemtype
public  code32sel, data32sel, zerosel, code16sel, data16sel, pspsel, envsel
public  IRQ0_vect, IRQ8_vect
public  hextbl, windows, returncode

public  exit, getmem, getlomem, gethimem, lomemsize, himemsize
public  getdsc, setdsc, getvect, setvect, map_phys_addr
public  dosshell, dosprint, putstr

endif

; Move relatively adjusted pointer to register
@rlp    macro reg, ptr
        mov reg,ptr
        sub reg,code32a
endm
