ifndef LOADER
RMCALL_VECT     =       RMCALL_VECT+1
N_DSC           =       N_DSC-2         ; Loader allocates 2 descriptors
N_INT           =       N_INT-1         ; Loader sets 1 interrupt gate

code32sel       dw      0
data32sel       dw      0
zerosel         dw      0
code16sel       dw      0
data16sel       dw      0
pspsel          dw      0
envsel          dw      0

IRQ0_vect       db      0
IRQ8_vect       db      0

v86r_edi        label   dword
v86r_di         dw      0
                dw      0
v86r_esi        label   dword
v86r_si         dw      0
                dw      0
v86r_ebp        label   dword
v86r_bp         dw      0
                dw      0
                dd      0
v86r_ebx        label   dword
v86r_bx         label   word
v86r_bl         db      0
v86r_bh         db      0
                dw      0
v86r_edx        label   dword
v86r_dx         label   word
v86r_dl         db      0
v86r_dh         db      0
                dw      0
v86r_ecx        label   dword
v86r_cx         label   word
v86r_cl         db      0
v86r_ch         db      0
                dw      0
v86r_eax        label   dword
v86r_ax         label   word
v86r_al         db      0
v86r_ah         db      0
                dw      0
v86r_flags      dw      0
v86r_es         dw      0
v86r_ds         dw      0
v86r_fs         dw      0
v86r_gs         dw      0
v86r_ip         dw      0
v86r_cs         dw      0
v86r_sp         dw      0
v86r_ss         dw      0

code16a         dd      0
code32a         dd      0
lomembase       dd      0
lomemtop        dd      0
himembase       dd      0
himemtop        dd      0
totalextmem     dd      0
hextbl          db      '0123456789ABCDEF'
systemtype      db      0
windows         db      0
returncode      db      0
                db      0,0,0           ; 3 bytes extra to align on dword

exit            label   fword
                dd      0
                dd      0               ; 1 word extra to align on dword
getmem          label   fword
                dd      0
                dd      0
getlomem        label   fword
                dd      0
                dd      0
gethimem        label   fword
                dd      0
                dd      0
lomemsize       label   fword
                dd      0
                dd      0
himemsize       label   fword
                dd      0
                dd      0
getdsc          label   fword
                dd      0
                dd      0
setdsc          label   fword
                dd      0
                dd      0
getvect         label   fword
                dd      0
                dd      0
setvect         label   fword
                dd      0
                dd      0
map_phys_addr   label   fword
                dd      0
                dd      0
dosshell        label   fword
                dd      0
                dd      0
dosprint        label   fword
                dd      0
                dd      0
putstr          label   fword
                dd      0
                dd      0

else

SELSTART        =       0
code32selOFF    =       SELSTART
data32selOFF    =       SELSTART+2
zeroselOFF      =       SELSTART+4
code16selOFF    =       SELSTART+6
data16selOFF    =       SELSTART+8
pspselOFF       =       SELSTART+10
envselOFF       =       SELSTART+12

IRQSTART        =       14
IRQ0_vectOFF    =       IRQSTART
IRQ8_vectOFF    =       IRQSTART+1

REGSTRUCOFF     =       16

MISCSTART       =       66
code16aOFF      =       MISCSTART
code32aOFF      =       MISCSTART+4
lomembaseOFF    =       MISCSTART+8
lomemtopOFF     =       MISCSTART+12
himembaseOFF    =       MISCSTART+16
himemtopOFF     =       MISCSTART+20
totalextmemOFF  =       MISCSTART+24
hextblOFF       =       MISCSTART+28
systemtypeOFF   =       MISCSTART+44
windowsOFF      =       MISCSTART+45
returncodeOFF   =       MISCSTART+46
; 3 bytes extra to align on dword

FUNCSTART       =       116
exitOFF         =       FUNCSTART
getmemOFF       =       FUNCSTART+8
getlomemOFF     =       FUNCSTART+16
gethimemOFF     =       FUNCSTART+24
lomemsizeOFF    =       FUNCSTART+32
himemsizeOFF    =       FUNCSTART+40
getdscOFF       =       FUNCSTART+48
setdscOFF       =       FUNCSTART+56
getvectOFF      =       FUNCSTART+64
setvectOFF      =       FUNCSTART+72
map_phys_addrOFF=       FUNCSTART+80
dosshellOFF     =       FUNCSTART+88
dosprintOFF     =       FUNCSTART+96
putstrOFF       =       FUNCSTART+104

endif
