.MODEL	SMALL

;-----------------------------------------------------------------------;
; This file contains procedures that are used for editing the SECTOR:	;
;									;
; WRITE_TO_MEMORY		Write a byte into SECTOR		;
; EDIT_BYTE			Change byte in memory and on screen	;
;-----------------------------------------------------------------------;

.CODE

.DATA
	EXTRN	SECTOR:BYTE
	EXTRN	SECTOR_OFFSET:WORD
	EXTRN	PHANTOM_CURSOR_X:BYTE
	EXTRN	PHANTOM_CURSOR_Y:BYTE
.CODE
;-----------------------------------------------------------------------;
; This procedure writes one byte to SECTOR, at the memory location	;
; pointed to by the phantom cursor.					;
;									;
; On entry:	DL	Byte to write to SECTOR				;
;									;
; The offset is calculated by						;
;   OFFSET = SECTOR_OFFSET + (16 * PHANTOM_CURSOR_Y) + PHANTOM_CURSOR_X	;
;									;
; Reads:	PHANTOM_CURSOR_X, PHANTOM_CURSOR_Y, SECTOR_OFFSET	;
; Writes:	SECTOR							;
;-----------------------------------------------------------------------;
WRITE_TO_MEMORY	PROC
	PUSH	AX
	PUSH	BX
	PUSH	CX
	MOV	BX,SECTOR_OFFSET
	MOV	AL,PHANTOM_CURSOR_Y
	XOR	AH,AH
	MOV	CL,4			;Multiply PHANTOM_CURSOR_Y by 16
	SHL	AX,CL
	ADD	BX,AX			;BX = SECTOR_OFFSET + (16 * Y)
	MOV	AL,PHANTOM_CURSOR_X
	XOR	AH,AH
	ADD	BX,AX			;That's the address!
	MOV	SECTOR[BX],DL		;Now, store the byte
	POP	CX
	POP	BX
	POP	AX
	RET
WRITE_TO_MEMORY		ENDP

	PUBLIC	EDIT_BYTE
	EXTRN	SAVE_REAL_CURSOR:PROC, RESTORE_REAL_CURSOR:PROC
	EXTRN	MOV_TO_HEX_POSITION:PROC, MOV_TO_ASCII_POSITION:PROC
	EXTRN	WRITE_PHANTOM:PROC, WRITE_EDITOR_PROMPT:PROC
	EXTRN	CURSOR_RIGHT:PROC, WRITE_HEX:PROC, WRITE_CHAR:PROC
;-----------------------------------------------------------------------;
; This procedure changes a byte in memory and on the screen.		;
;									;
;	DL	Byte to write into SECTOR, and change on screen		;
;									;
; Uses:		SAVE_REAL_CURSOR, RESTORE_REAL_CURSOR			;
;		MOV_TO_HEX_POSITION, MOV_TO_ASCII_POSITION		;
;		WRITE_PHANTOM, WRITE_PROMPT_LINE, CURSOR_RIGHT		;
;		WRITE_HEX, WRITE_CHAR, WRITE_TO_MEMORY			;
; Reads:	EDITOR_PROMPT						;
;-----------------------------------------------------------------------;
EDIT_BYTE	PROC
	PUSH	DX
	CALL	SAVE_REAL_CURSOR
	CALL	MOV_TO_HEX_POSITION	;Move to the hex number in the
	CALL	CURSOR_RIGHT		; hex window
	CALL	WRITE_HEX		;Write the new number
	CALL	MOV_TO_ASCII_POSITION	;Move to the char. in the ASCII window
	CALL	WRITE_CHAR		;Write the new character
	CALL	RESTORE_REAL_CURSOR	;Move cursor back where it belongs
	CALL	WRITE_PHANTOM		;Rewrite the phantom cursor
	CALL	WRITE_TO_MEMORY		;Save this new byte in SECTOR
	CALL	WRITE_EDITOR_PROMPT	;Display the Edit prompt
	POP	DX
	RET
EDIT_BYTE	ENDP


	END
