.MODEL	SMALL

.CODE
	EXTRN	NEXT_SECTOR:PROC			;In DISK_IO.ASM
	EXTRN	PREVIOUS_SECTOR:PROC			;In DISK_IO.ASM
	EXTRN	PHANTOM_UP:PROC, PHANTOM_DOWN:PROC	;In PHANTOM.ASM
	EXTRN	PHANTOM_LEFT:PROC, PHANTOM_RIGHT:PROC
	EXTRN	PAGE_UP:PROC, PAGE_DOWN:PROC
	EXTRN	HOME_KEY:PROC, END_KEY:PROC
	EXTRN	WRITE_SECTOR:PROC			;In DISK_IO.ASM
	EXTRN	CHANGE_DISK_DRIVE:PROC
	EXTRN	READ_SECTOR_NUMBER:PROC
	EXTRN	OPEN_NEW_FILE:PROC
	EXTRN	READ_OFFSET_NUMBER:PROC
.DATA
;-----------------------------------------------------------------------;
; This table contains the legal extended ASCII keys and the addresses	;
; of the procedures that should be called when each key is pressed.	;
;									;
; The format of the table is						;
;		DB	72		;Extended code for cursor up	;
;		DW	OFFSET PHANTOM_UP				;
;-----------------------------------------------------------------------;
DISPATCH_TABLE	LABEL	BYTE
	DB	85				;Shift F2
	DW	OFFSET _TEXT:WRITE_SECTOR
	DB	61				;F3
	DW	OFFSET _TEXT:PREVIOUS_SECTOR
	DB	62				;F4
	DW	OFFSET _TEXT:NEXT_SECTOR
	DB	63				;F5
	DW	OFFSET _TEXT:CHANGE_DISK_DRIVE
	DB	64				;F6
	DW	OFFSET _TEXT:READ_SECTOR_NUMBER
	DB	65				;F7
	DW	OFFSET _TEXT:OPEN_NEW_FILE
	DB	66				;F8
	DW	OFFSET _TEXT:READ_OFFSET_NUMBER
	DB	72				;Cursor up
	DW	OFFSET _TEXT:PHANTOM_UP
	DB	80				;Cursor down
	DW	OFFSET _TEXT:PHANTOM_DOWN
	DB	75				;Cursor left
	DW	OFFSET _TEXT:PHANTOM_LEFT
	DB	77				;Cursor right
	DW	OFFSET _TEXT:PHANTOM_RIGHT
	DB	73				;Page Up
	DW	OFFSET _TEXT:PAGE_UP
	DB	81				;Page Down
	DW	OFFSET _TEXT:PAGE_DOWN
	DB	71				;Home
	DW	OFFSET _TEXT:HOME_KEY
	DB	79				;End
	DW	OFFSET _TEXT:END_KEY
	DB	0				;End of the table

.CODE

	PUBLIC	DISPATCHER
	EXTRN	READ_BYTE:PROC, EDIT_BYTE:PROC
	EXTRN	WRITE_PROMPT_LINE:PROC
.DATA
	EXTRN	EDITOR_PROMPT:BYTE
.CODE
;-----------------------------------------------------------------------;
; This is the central dispatcher. During normal editing and viewing,	;
; this procedure reads characters from the keyboard and, if the char	;
; is a command key (such as a cursor key), DISPATCHER calls the		;
; procedures that do the actual work.  This dispatching is done for	;
; special keys listed in the table DISPATCH_TABLE, where the procedure	;
; addresses are stored just after the key names.			;
;									;
; If the character is not a special key, then it should be placed	;
; directly into the sector buffer--this is the editing mode.		;
;									;
; Uses:		READ_BYTE, EDIT_BYTE, WRITE_PROMPT_LINE			;
; Reads:	EDITOR_PROMPT						;
;-----------------------------------------------------------------------;
DISPATCHER	PROC
	PUSH	AX
	PUSH	BX
	PUSH	DX
DISPATCH_LOOP:
	CALL	READ_BYTE		;Read character into AX
	OR	AH,AH			;AX = -1 if no character read, 1
					; for an extended code.
	JS	NO_CHARS_READ		;No character read, try again
	JNZ	SPECIAL_KEY		;Read extended code
	MOV	DL,AL
	CALL	EDIT_BYTE		;Was normal character, edit byte
	JMP	DISPATCH_LOOP		;Read another character

SPECIAL_KEY:
	CMP	AL,68			;F10--exit?
	JE	END_DISPATCH		;Yes, leave
					;Use BX to look through table
	LEA	BX,DISPATCH_TABLE
SPECIAL_LOOP:
	CMP	BYTE PTR [BX],0		;End of table?
	JE	NOT_IN_TABLE		;Yes, key was not in the table
	CMP	AL,[BX]			;Is it this table entry?
	JE	DISPATCH		;Yes, then dispatch
	ADD	BX,3			;No, try next entry
	JMP	SPECIAL_LOOP		;Check next table entry

DISPATCH:
	INC	BX			;Point to address of procedure
	CALL	WORD PTR [BX]		;Call procedure
	JMP	DISPATCH_LOOP		;Wait for another key

NOT_IN_TABLE:				;Do nothing, just read next character
	JMP	DISPATCH_LOOP

NO_CHARS_READ:
	LEA	DX,EDITOR_PROMPT
	CALL	WRITE_PROMPT_LINE	;Erase any invalid characters typed
	JMP	DISPATCH_LOOP		;Try again

END_DISPATCH:
	POP	DX
	POP	BX
	POP	AX
	RET
DISPATCHER	ENDP


	END
