; Chad Wallace - no reboot


code_seg        segment
BEGSEG  EQU     $
        assume  cs:code_seg, ds:code_seg, es:code_seg, ss:code_seg
        org     100h

begin:
        jmp     init            ; Install in memory and exit to DOS

int9:
        sti                     ; Enable interrupts
        push    ax
        in      al, 60h         ; Get key from keyboard controller
        cmp     al, 53h         ; Is it Del?
        jnz     not_del         ; Nope, let it through

        push    bx
        push    es
        xor     bx, bx          ; Segment 0
        mov     es, bx
        mov     bx, 417h        ; Offset 417 - key flags
        test    byte ptr es:[bx], 08h   ; Test for Alt press
        jz      not_ours        ; Nope
        test    byte ptr es:[bx], 04h   ; Test for Ctrl press
        jz      not_ours        ; Nope
        jmp     del_press       ; Yep, absorb this keystroke

not_ours:
        pop     es
        pop     bx
not_del:
        pop     ax

        db      0eah            ; Call old INT 9 handler
int9off         dw      0000    ; offset and
int9seg         dw      0000    ; segment stored here

del_press:
        in      al, 61h         ; This stuff is to tell the
        mov     ah, al          ; key controller that we
        or      al, 80h         ; have gotten the key.
        out     61h, al
        mov     al, ah
        out     61h, al

        pop     es
        pop     bx
        pop     ax
        iret                    ; Return to foreground task

RESSIZ  EQU     (($ - BEGSEG) / 16) + 1 ; Number of para. to keep

init:
        mov     ax, 3509h       ; Get interrupt vector for key press
        int     21h             ; Call DOS
        mov     [int9off], bx   ; Store offset
        mov     [int9seg], es   ; and segment

        mov     ax, 2509h       ; Set interrupt vector for key press
        mov     dx, offset int9 ; to our interrupt handler
        int     21h             ; Call DOS

        mov     ax, 3100h       ; Terminate and Stay Resident
        mov     dx, RESSIZ      ; Number of paragraphs needed
        int     21h             ; Call DOS

code_seg        ends

        end     begin
