;From  Max Maischein                                       2:244/1106.17

COMMENT %

Mandelbrot set, game, and match !
   - Variations on a theme -

This one is quite large compared with the 67 bytes featured by those
small mandel programs - but it features its own palette. Just watch
this fractal compressed 64K image !

OK, as you will see, this is only a 64 color image (ie 5-bit), so it's
not 64000 bytes, but rather 40000 bytes - but still the compression rate
is fascinating, wouldn't you think ;)

-max

26.03.95 MM     First release with 114 bytes
%

; To change the line offset, change this value
;ViewOffset      equ -240
;ViewOffset      equ -300
ViewOffset      equ 0FF00h
;BPValue         equ -251
;BPValue         equ -256-80
BPValue         equ 0FE80h

DEBUG           equ     0

                        .286

InitPalette     macro
; Initialize palette at the end of the program
; Note that TD fills the memory with zeroes, but DOS dosen't
; ax = 0
; cx = 0
; es = ds
; di = offset Palette
                        pusha

                        ; init background to black
                        stosw
                        stosb

                        ; fade from light blue to light green
                        ; bl = red component
                        ; al = green component
                        ; ah = blue component
                        mov     al, 32          ;  50% green
;                       mov     ah, 64          ; 100% blue
                        ; can be left out, as 64 mod 64 = 0
                        mov     cl, 32          ; in 32 easy steps
NextBlue:
                        dec     ah
                        inc     al

                        mov     [di], bl
                        inc     di
                        stosw
                        loop    NextBlue

                        ; now we have
                        ;   0% green (40h -> 0h)
                        ;  50% blue
                        ; Fade from 100% red, 50% blue to 50% blue
                        mov     cl, 3Fh
NextRed:
                        mov     [di], cl
                        inc     di
                        stosw
                        loop    NextRed

                        popa
                endm


_code segment para public 'code'
  assume cs:_code, ds:_code, ss:_code
  org 100h
main proc near

                        mov     di, offset Palette
                        mov     dx, di

                        InitPalette
                        ; ax is still 0, as InitPalette preserves all registers
                        mov     al,13h
                        int     10h

                        ; bx = 0
                        mov     cl, 64
                        mov     ax, 1012h               ; BIOS load palette
                        int     10h

                        mov     bh,0a0h                 ; bx = 0A000h
                        mov     es,bx

                        mov     si, ViewOffset
@loop1:
                        mov     bp, BPValue
@loop2:
                        xor     cx, cx
                        xor     bx, bx
                        xor     di, di
@loop3:
                        push    bx
                        lea     ax,[bx+di]
                        sub     bx,di
                        imul    bx

                        mov     bh, dl
                        mov     bl, ah
                        add     bx, bp

                        pop     ax
                        cmp     bh, 04h
                        jg      @draw
                        imul    di

                        mov     al,ah
                        mov     ah,dl
                        shl     ax,1
                        add     ax,si
                        xchg    ax,di

                        inc     cl
                        jnz     @loop3
@draw:
                        pop     di
                        xchg    ax,cx
                        stosb
                        push    di

                        inc     bp
                        cmp     bp, BPValue + 0140h
                        jne     @loop2

                        inc     si
                        cmp     si, ViewOffset + 0C8h
                        jne     @loop1

                        ; ax = 0000h
IF Debug
KeyWait:
                        int     16h
                        mov     ax, 3
ELSE
                        mov     al, 3
ENDIF
                        int     10h
                        int     20h

; The size of this part is not important, since it is declared with ?,
; which results in this part not being included in the disk image.
Palette                 db 256 * 3 dup (?)

main endp
_code ends
end  main

