;---------------------------
;         Example 2
;---------------------------
.386

code    segment public use32

	assume  cs:code

	include d32.inc

ComSpec         db 'COMSPEC='
ParmBlock       dw ?, 80h, ?, 5ch, ?, 6ch, ?

main    proc    far

	mov     ah,9                    ; Write 1st message
	mov     dx,offset mes1
	int16   21h

	mov     ax,psp_sel              ; Build Parameter Block
	mov     es,ax
	mov     cx,es:[2ch]
	mov     ds:ParmBlock[0],cx
	mov     ax,ds:psp_segment
	mov     ds:ParmBlock[4],ax
	mov     ds:ParmBlock[8],ax
	mov     ds:ParmBlock[12],ax
	mov     ds:V86_es,ax
	mov     bx,ds:base_segment
	sub     bx,ax
	mov     ah,4ah
	int16   21h
	jc      short exit

	mov     ax,env_sel              ; Get COMSPEC environment variable
	mov     es,ax
	xor     eax,eax
	xor     edi,edi
m0:
	mov     esi,offset ComSpec
	cmpsd
	jne     short m1
	cmpsd
	je      short m2
m1:
	scasb
	jne     short m1
	jmp     short m0
m2:
	
	mov     ax,4b00h                ; Execute 'COMSPEC'
	mov     bx,offset ParmBlock
	mov     dx,di
	mov     ds:V86_ds,cx
	mov     ds:V86_es,code
	int16   21h

	mov     ah,9                    ; Write 2nd message
	mov     dx,offset mes2
	mov     ds:V86_ds,code
	int16   21h
exit:
	ret                             ; End program

mes1            db 'Now in V86 mode',10,36
mes2            db 'Back in Real mode',10,36

main    endp

irq0:   inc     dword ptr fs:0A0000h    ; fs = value before INT16 call,
	inc     dword ptr fs:0B0000h    ; and is flat_sel at startup
	inc     dword ptr fs:0B8000h
	int16   08h
	iretd
irq1:   int16   09h
	iretd
irq2:   int16   0ah
	iretd
irq3:   int16   0bh
	iretd   
irq4:   int16   0ch
	iretd
irq5:   int16   0dh
	iretd
irq6:   int16   0eh
	iretd
irq7:   int16   0fh
	iretd

irq8:   int16   70h
	iretd
irq9:   int16   71h
	iretd
irq10:  int16   72h
	iretd
irq11:  int16   73h
	iretd
irq12:  int16   74h
	iretd
irq13:  int16   75h
	iretd
irq14:  int16   76h
	iretd
irq15:  int16   77h
	iretd

align   4
	db      200h dup(0)
stack0          label

code    ends
	end
