;--------------------------------------
; Trident VGA from  Byron Ellacott
; The globals are just a raw image and a palette converted to .OBJ files with
; BINOBJ.EXE (modified to para align).

.model          small
.286

                global  Picture: proc   ; The picture to scroll
                global  Palette: proc   ; The palette of said piccy

.stack          1024

.code

;---------------------------------------------------------------------------
; SetAddress - Sets the start address for screen data.
; Assumes that BX contains the address to set...
; Modifies ax,dx and uses stack
;---------------------------------------------------------------------------

SetAddress      proc    near
                mov     dx,3d4h         ; CRTC address
                mov     ax,bx           ; Copy offset
                mov     al,0ch          ; Output msb first
                out     dx,ax           ; Send it
                mov     ah,bl
                mov     al,0dh          ; Register to change...
                out     dx,ax           ; Send it
                ret
SetAddress      endp

;---------------------------------------------------------------------------
; SetPalette - Sets the VGA color palette.
; In:
;   ES:SI - Palette segment address.
;---------------------------------------------------------------------------

SetPalette      proc near

                push    ds
                mov     ax,es
                mov     ds,ax
                mov     dx,3C8h
                xor     al,al
                out     dx,al
                inc     dx
                mov     cx,768
                cld
                rep     outsb
                pop     ds
                ret

SetPalette      endp

;---------------------------------------------------------------------------
; WaitVRT - Waits for VGA retrace
;---------------------------------------------------------------------------

WaitVRT         proc    near

                mov     dx,3DAh
WaitVR1:
                in      al,dx
                test    al,8
                jne     WaitVR1
WaitVR2:
                in      al,dx
                test    al,8
                je      WaitVR2
                ret

WaitVRT         endp

;===========================================================================
; ScrollUp:
; Scroll an image up the screen in 320x200x256 mode 13h
; Input: DX=segment of picture to scroll
; Output: None
; Notes:
;   Modifies the start address on the VGA chip to speed things up, and needs
;   the 128k mode on (use Set128k for this).
;===========================================================================

ScrollUp        proc near

                push    ds              ; Save data segment

                mov     ds,dx
                xor     si,si
                mov     ax,0afa0h
                mov     es,ax
                xor     di,di
                xor     ax,ax
                mov     cx,32000
                rep     movsw
                xor     bx,bx
                mov     cx,199
ScrollUpLoop:
                add     bx,80           ; Only add 80...not 320...

                call    WaitVRT         ; Wait for vertical retrace
                call    SetAddress      ; Set the new address
                dec     cx              ; That's one line done...
                jnz     ScrollUpLoop    ; If there's more, go back

                mov     ax,0a000h       ; Now copy the picture to the normal
                mov     es,ax           ; page for later work...
                xor     di,di
                xor     si,si           ; DS should still be the piccy...
                mov     cx,32000        ; Copy screenful
                rep     movsw

                xor     bx,bx           ; Set to screen start
                call    WaitVRT         ; Prevent flicker
                call    SetAddress      ; Now set to normal screen

                pop     ds              ; We're done!
                ret
ScrollUp        endp

;===========================================================================
; ScrollOff:
; Scroll an image up off the screen in 320x200x256 mode 13h
; Input: None
; Output: None
; Notes:
;   Modifies the start address on the VGA chip to speed things up, and needs
;   the 128k mode on (use Set128k for this).
;===========================================================================

ScrollOff       proc near
                mov     ax,0afa0h
                mov     es,ax
                xor     di,di
                xor     ax,ax
                mov     cx,32000
                xor     ax,ax
                rep     stosw
                xor     bx,bx
                mov     cx,199
ScrollOffLoop:
                add     bx,80           ; Only add 80...not 320...

                call    WaitVRT         ; Wait for vertical retrace
                call    SetAddress      ; Set the new address
                dec     cx              ; That's one line done...
                jnz     ScrollOffLoop   ; If there's more, go back

                mov     ax,0a000h       ; Now copy the picture to the normal
                mov     es,ax           ; page for later work...
                xor     di,di
                mov     cx,32000        ; Copy screenful
                xor     ax,ax           ; Blank out screen
                rep     stosw

                xor     bx,bx           ; Set to screen start
                call    WaitVRT         ; Prevent flicker
                call    SetAddress      ; Now set to normal screen

                ret
ScrollOff       endp

Set128k         proc    near
                mov     dx,3ceh
                mov     al,6
                out     dx,al
                inc     dx
                in      al,dx
                and     al,0f3h
                mov     ah,al
                mov     al,6
                dec     dx
                out     dx,ax
                ret
Set128k         endp

Startup         proc    near            ; Main proc
                .startup
                mov     ax,13h          ; Set MCGA/VGA mode 13h
                int     10h             ; 320x200x256 linear pixel access
                call    Set128k         ; set 128k video memory
                mov     ax,seg Palette
                mov     es,ax
                mov     si,offset Palette
                call    SetPalette      ; Set the palette
                mov     dx,seg Picture
                call    ScrollUp
                mov     ah,0
                int     16h             ; Wait for a keystroke
                call    ScrollOff
                mov     ax,3            ; Set video mode
                int     10h             ; 80x25x16 text
                .exit
Startup         endp

end             Startup
