;---------------------
; From: Elad Nachman
; How to set up a GDT and switch to protected mode

; Run without a memory manager - only from real mode (not V86).

.386P
code segment USE16
assume cs:code,ds:code,es:code,ss:code
org 100h

begin:
jmp start


desc struc
Limit dw ? ; Segment Limit, 286/386
Base1 dw ?
base2 db ? ; 24 linear Pointer to start of segment
rights db ? ; Access Rights
dat386 db ? ; limit+other flags
base3 db ? ; 386 Addition
ENDS

GDTR1 dw 018h  ; GDT limit (1 null selectors+2 for 386p+2 for real mode)
GDTR2 dd ?  ; Linear 32 bit pointer to GDT
nope dw 0 ; For compatibility ??!?!?!?
data1 dq 0 ; null descriptor
data2 desc <0ffffh,000h,0h,10010010b,11001111b,0> ; 4GB DATA segment, DPL0
data3 desc <0ffffh,0,0,10010010b,0,0> ; Real Mode style 64KB data segment

stck db 100h dup (0) ; stack

start:
mov bx,cs
movzx eax,bx
mov cl,04h
shl eax,cl ; Segment -> linear
mov ebx,eax
mov dx,offset data1
movzx ecx,dx
add eax,ecx
mov [GDTR2],eax ; Store linear GDT address
mov si,offset data3.base1
mov eax,dword ptr [si]
or eax,ebx
mov dword ptr [si],eax
Cli
mov dx,offset gdtr1
movzx ebx,dx
LGDT [bx]
mov eax,cr0
or al,1
mov cr0,eax ; Were in, guys!
jmp $+2
mov ax,08h
mov es,ax
mov edi,0b8000h ; Video Screen - What else ?
mov ecx,100h ; That'll be enough
mov eax,08c418c41h ; 2 Flashing A's
cld
rep
db 067h
stosd
mov eax,cr0
and al,0FEh ; we had enough!
mov cr0,eax ; Ahh... Back to Real mode...
jmp $+2
mov ax,10h ; Real mode style selector
mov es,ax
sti
mov ah,4ch
int 21h
code ends
end begin

