;----------------------
;     From: Tom Marshall
;  Subject: Original Vectors

comment |

I wrote this using TASM 2.0, natch, so you may have to change it around if you
are using MASM.  The header, abbreviation macros, and hex conversion subroutine
will have to be redone .. but hey, you should know what you're doing to play
around with this stuff anyway, eh?  The code is modelled around a similar
routine from Tom Swan's "Mastering Turbo Assembler".

You may have a question about my obfuscated INT 10h call.  Whenever the CPU
executes an INT, it clears the trap flag.  Therefore, it is necessary to do a
PUSHF/CALL FAR in order to keep the TF set inside the INT 10h code.

The 5 lines that are commented out could be used to see if the code is being
executed in _real_ ROM, but with the advent of shadow RAM, you're unlikely to
find any of those critters in use after boot.

Lastly, a good "real world" check for ROM is to see if the old CS is on an even
32k boundary (ie. C000, C800, etc.).  All those feelthy UMB programs should
have arbitrary segment numbers. Even if a TSR is loaded exactly at the C000
boundary, the environment will get the C000 segment, while the code will get
something higher (C0xx).
|

                INCLUDE exehead.inc

Trapping        EQU     0
TrapOn          EQU     1
TrapOff         EQU     2

                DATASEG
TrapSwitch      DB      0
RomEntrySeg     DW      0
RomEntryOfs     DW      0
OutBuf          DB      'xxxx:xxxx$'

Old01Seg        DW      ?
Old01Ofs        DW      ?

                CODESEG

                EXTRN   Word2Hex:PROC

Start:          mov     ax,@data
                mov     ds,ax

;*** Save and reassign INT 01 vector
                mov     ax,3501h
                int     21h
                mov     [Old01Seg],es
                mov     [Old01Ofs],bx
                push    ds
                push    cs
                pop     ds
                mov     dx,O Stepper
                mov     ax,2501h
                int     21h
                pop     ds

;*** Enter trap mode
                mov     [TrapSwitch],TrapOn
                int     01h

;*** Perform interrupt
                xor     ax,ax                   ;Point ES to INT table
                mov     es,ax

                mov     ah,3                    ;Get Cursor Pos
                pushf
                call    [DWORD es:10h*4]        ;Fake INT 10h

;*** Ensure trap mode off
                mov     [TrapSwitch],TrapOff
                int     01h

;*** Display result
                mov     ax,[RomEntrySeg]
                mov     si,O OutBuf
                call    Word2Hex
                mov     ax,[RomEntryOfs]
                mov     si,O OutBuf + 5
                call    Word2Hex
                mov     dx,O OutBuf
                mov     ah,9
                int     21h

;*** Reset INT 01
                push    ds
                mov     ds,[Old01Seg]
                mov     dx,[Old01Ofs]
                mov     ax,2501h
                int     21h
                pop     ds

;*** Exit to DOS
                mov     ax,4C00h
                int     21h

;***************************************
;* Stepper - Trap mode controller.
;*   Invoked by CPU via INT 01h.
;*   Stack frame:
;*     [bp+6] Old FLAGS
;*     [bp+4] Old CS
;*     [bp+2] Old IP
;***************************************
PROC            Stepper
                push    bp
                mov     bp,sp
                pusha
                push    ds
                push    es
                mov     ax,@data
                mov     ds,ax

                cmp     [TrapSwitch],TrapOn
                jne     @@10
                or      [WORD bp+6],0100h       ;Set TF in saved FLAGS
                mov     [TrapSwitch],Trapping   ;Set trapping flag
                jmp     @@99

@@10:           cmp     [TrapSwitch],TrapOff
                jne     @@90

@@20:           and     [WORD bp+6],NOT 0100h   ;Reset TF in saved FLAGS
                jmp     @@99

@@90:           cmp     [WORD bp+4],0A000h      ;In high mem?
                jb      @@99

                mov     es,[bp+4]               ;Get trap address
                mov     bx,[bp+2]

;                mov     al,[es:bx]              ;In ROM?
;                inc     [BYTE es:bx]
;                cmp     [es:bx],al
;                mov     [es:bx],al
;                jne     @@99

                mov     [RomEntrySeg],es        ;Save entry addr.
                mov     [RomEntryOfs],bx
                jmp     @@20                    ;Reset trap

@@99:           pop     es
                pop     ds
                popa
                pop     bp
                iret
ENDP

                END     Start

