TITLE           Load but do not execute immediately (Int 21,AX = 4B01)

  comment       |

                written and released into the public domain by
                Knut Petersen, 35274 Kirchhain, Germany
                Fidonet#2:244/4351.0

                You might use this template to write loaders for
                programs that need some sort of fixing before they
                are executed. The DOS function used (4B01) was never
                widely documented, but Microsoft included it in the
                function 4B _flowcharts_ of: MS-DOS (versions 1.0-3.2)
                Technical Reference Encylopedia, ISBN 0-914845-69-1.

                |

 .radix         16

  STACKPARAS    equ     20

text            segment para public 'code'
  assume        ds:text, es:text, cs:text

  fcb           db      0, 0bh dup (20),0,0,0,0 ; dummy file control block
  parablk       dw      0                       ; |> use default EnvSeg
                dw      80                      ; |\ dd ptr to comtail
  pspseg        dw      ?                       ; |/
                dd      fcb                     ; |> 1st fcb ptr
                dd      fcb                     ; |> 2nd fcb ptr
  spchild       dw      ?                       ; |\ ss:sp of child,filled
  sschild       dw      ?                       ; |/ in by DOS
  ipchild       dw      ?                       ; |\ cs:ip of child, filled
  cschild       dw      ?                       ; |/ in by DOS
  program       db      'FOOBAR.EXE',0

  stckofs       dw      ?
  stckseg       dw      ?

  err_child     db      0d,0a,7,'ERROR: Unknown FOOBAR.EXE',0d,0a,'$'

  old_i1b_o     dw      ?                       ; will be used to store the
  old_i1b_s     dw      ?                       ; original int 1b vector

  i1b           proc    far                     ; <ctrl-break> handler
                iret                            ; ... ignore it
  i1b           endp

  i23           proc    far                     ; <ctrl-c> handler
                iret                            ; ... ignore it
  i23           endp

  i24           proc    far                     ; critical error handler
                mov     al,3                    ; ... always return "fail"
                iret
  i24           endp

  start:        mov     ah,4a                   ; release unused memory
                mov     bx,REQPARAS
                int     21

                push    cs                      ; ds = seg text
                pop     ds
                mov     [pspseg],es             ; store pspseg in parablk

                mov     ax,351bh                ; get original int 1b vector
                int     21                      ; and save it for later use
                mov     [old_i1b_o],bx
                mov     [old_i1b_s],es
                mov     ax,251Bh                ; install <ctrl-break>
                mov     dx,offset i1b           ; handler
                int     21
                mov     ax,2523                 ; install <ctrl-c>
                mov     dx,offset i23           ; handler
                int     21
                mov     ax,2524                 ; install critical error
                mov     dx,offset i24           ; handler
                int     21

                push    cs                      ; es = seg text
                pop     es
                mov     [stckofs],sp
                mov     [stckseg],ss
                mov     ax,4b01                 ; load but do _not_ execute
                mov     bx,offset parablk       ; child process
                mov     dx,offset program
                int     21
                jc      eoexec                  ; error loading file?
                cli
                mov     ss,cs:[sschild]
                mov     sp,cs:[spchild]
                sti
                mov     ah,51                   ; get child PID, store it to
                int     21                      ; ES & DS
                mov     ds,bx
                mov     es,bx                   ;-------; correct the DOS
                mov     word ptr ds:[0a], offset eoexec ; terminate vector in
                ;                                       ; childs psp
                ; test if this is the correct child. No? jmp to badchild.
                ; DOS THINKS THAT THE CHILD IS ALREADY RUNNING!
                ;
                ; jnz   badchild
                ;
                ; Here you may patch the child process FOOBAR.EXE
                ; if you like ... then you have to ...
                ;                               ;
                pop     ax                      ; ..pop fcb validation codes
                jmp     dword ptr cs:[ipchild]  ; pushed by DOS, jmp 2 child

  badchild:     push    cs                      ; WE ARE THE CHILD AT THIS
                pop     ds                      ; POINT OF THE CODE!
                mov     ah,9
                mov     dx,offset err_child
                int     21
                mov     ax,4cff                 ; abort child, execution will
                int     21                      ; resume at eoexec (!!!)

  eoexec:       cli                             ; remember: old 8088 cpu bug
                mov     ss,cs:[stckseg]         ; remember: old dos 2.x bug
                mov     sp,cs:[stckofs]         ; only cs:ip is valid after
                sti                             ; function 4b00 :-(

                mov     ah,4dh                  ; get return code of child
                int     21                      ; process ...
                push    ax                      ; ... save it
                mov     ax,251Bh                ; restore int 1b handler
                lds     dx,dword ptr [old_i1b_o]; (DOS will restore the int
                int     21                      ; 23&24 vectors)
                pop     ax                      ; restore return code
                mov     ah,4c                   ; and terminate this little
                int     21                      ; demo.

  REQPARAS      equ     ((($-offset[text:0])+10f) shr 4) + STACKPARAS
text            ends

stack           segment para stack
                db      (STACKPARAS shl 4) dup  (?)
stack           ends

end             start

