;------------------------------------------------------------------;
; From: danw@jacobs.cs.orst.edu (Dan Whitaker)
; Subject: CODE that can tell a 386DX from a 386SX
; For all of you that have been looking for a fool proof way to
; tell a 386DX from a 386SX, here it is.
;
; Dan Whitaker   wk (503) 757-0934  FAX (503) 757-7350
;
; [NB: The program works only if it gets complete control of the 386
;      to examine the control register CR0. This means it won't work
;      within either DESQview or Turbo Debugger 386. Nonetheless, it
;      does give the right answer on my NEC SX. GAT, 05-Nov-90 ]
;------------------------------------------------------------------;

   DOSSEG
   .MODEL MEDIUM
   .386P
   .STACK 100h
   .DATA
have386dx DB 'You have a 386DX',13,10,'$'
have386sx DB 'You have a 386sx',13,10,'$'
   .CODE
   mov  eax,CR0            ;Read in the CR0 register
   and  eax,0ffefh         ;set the 5th bit to 0
   mov CR0,eax             ;write out modified register to reset CR0
   mov eax,CR0             ;Read it back in to see if it changed
   and eax,00010h          ;set register to 0 if 5th bit was zero
   jnz sxchip              ;see if it is sx
   mov ax,@DATA            ;lets display the dx message
   mov ds,ax               ;set DS to point to the data segment
   mov ah,9                ;DOS print string function
   mov dx,OFFSET have386dx ;point to dx message
   int 21h                 ;display the message
   jmp exit
sxchip:
   mov ax,@DATA
   mov ds,ax               ;set DS to point to the data segment
   mov ah,9                ;DOS print string function
   mov dx,OFFSET have386sx ;point to sx message
   int 21h                 ;display message
exit:
   mov ax,04C00h           ;DOS terminate program function
   int 21h                 ;terminate the program
   END
