(7042)  Wed 14 Jul 93 10:41p
By: Emil Gilliam
To: Graham Allen
Re: Re: assembler
St:                                                                       <5850
---------------------------------------------------------------------------
@MSGID: 1:147/3006 2c44cd4f
@PID: TeleMail 1.51
 -=> Quoting Graham Allen to Andrew Gayton <=-

 GA> Is there any way to solve this WITHOUT having to redirect int9 to
 GA> a subroutine ?

 AG> Give this a bash :
 AG>                     in    al,  61h
 AG>                     mov   ah,  al
 AG>                     or    al,  80h
 AG>                     out   61h, al
 AG>                     xchg  ah,  al
 AG>                     out   61h, al
 AG>                     mov   al,  20h    ; left of these two lines
 AG>                     out   20h, al

 GA> Sorry...I tried it, it doesn't work... :(

 GA> Reseting the interrupt controller wouldn't make any difference unless
 GA> I had redirected Int 9h I think.

 GA> Using Int16h works but it is way too slow.

 GA> thanx anyway

   Since this is the first message in this thread I have read, I'm not
sure, but I would guess that you're trying to temporarily disable the
keyboard.  The code given up there should work.  I think what you're doing
wrong is: You don't just execute the code like that, that's supposed to be
an actual interrupt 9 handler!  (Of course, you need to PUSH AX, and POP AX
and IRET at the end.)

   However, this is the easiest way to completely disable the keyboard (by
messing with the interrupt controller):

in al,21h
or al,00000010b
out 21h,al

   This is not an interrupt handler; you just execute those three lines
just like that in your program and it will disable the keyboard!  This is a
lot easier than any other method because you don't have to install your own
interrupt handler or anything!  How it works is: I/O port 21h controls
which IRQs (from 0 to 7 corresponding to interrupt vectors 8h through 0Fh)
are masked.  The code above gets its value, masks IRQ1 (interrupt 9, the
keyboard), and writes it back!  You could also do it by using the processor
instruction CLI to disable interrupts but then no other interrupts (clock
interrupts, etc.) can get through.

   When you want to enable the keyboard again, just do these three lines:

in al,21h
and al,11111101b
out 21h,al

   This sets the bit back to 0 meaning that interrupt 9 can happen again!

   I have to admit that there is a problem with this method: If keys are
pressed while the keyboard is disabled, the keyboard controller might keep
a few keys meaning that when the keys are pressed when the keyboard is re-
enabled, the keyboard controller might return the scan codes of the keys
pressed while the keyboard was disabled!

   So perhaps the method given by Andrew Gayton is better.  The complete
interrupt 9 handler (be sure to set the old interrupt 9 handler back when
you want to re-enable the keyboard) will look like this...  (It's slightly
modified from the code that Andrew Gayton gave.  I can tell that came from
the IBM ROM BIOS code because of the fact that an unnecessary XCHG is used
when MOV could have been used although it doesn't really matter since the
code size is the same)...

push    ax                      ;Save AX

in      al,61h                  ;Set the high bit of port 61h to 1 and then
mov     ah,al                   ; back to 0.  This will tell the keyboard
or      al,80h                  ; controller that the scan code has been
out     61h,al                  ; read (when it really hasn't) so that
mov     ah,al                   ; the keyboard controller will take the key
out     61h,al                  ; off of its buffer.

mov     al,20h                  ;Tell the interrupt controller that we've
out     20h,al                  ; reached the end of the interrupt 9
                                ; handler.  That way, the interrupt
                                ; controller will allow further interrupt
                                ; 9's to occur.

pop     ax                      ;Restore AX
iret                            ;Interrupt return

   Hope this helps!  (Of course, I'm not sure whether or not you were
trying to disable the keyboard in the first place, but I hope this helps
anyway...)

                                                           Emil Gilliam


... Life after death?  Is it like terminate and stay resident?
--- GEcho 1.00
 * Origin: Doesn't run? Execute the data segment (405)6725644 (1:147/3006.0)

@PATH: 147/3006 19/150 147/20 7 209/209 396/1 13/13 260/1
