
122/128 10 Nov 91 11:43:55
From:   Jon Guthrie
To:     All
Subj:   CRC-16 code.
Attr:   
------------------------------------------------
I had the occasion to write some CRC code in assembly language.  I
like it so much, that I'm going to post it here.

;
; A generic CRC-16 routine in 8086 assembly language.
;
; Written by Jonathan Guthrie and placed in the public domain.
;
; Entry conditions:
;   AX contains the original CRC value
;   DL contains the character to take the CRC of
;
; Exit conditions:
;   AX contains the new CRC value
;   all other registers are unchanged
;
poly    set     0a001h
crc16   proc    far             ; Could be near, no reason
        push    cx
;
        xor     al, dl
        mov     cl, 8
crcloop:
        shr     ax, 1
        jnc     crcskip
        xor     ax, poly
crcskip:
        loop    crcloop
        pop     cx
        ret
crc16   endp


--- QM v1.00
 * Origin: The Wandering Programmer Gets Wise (1:106/2000.25)

