


; 1 nudget     = 4  pixel (plane aligned, one pixel for every plane)
; 1 big nudget = 16 pixel (plane aligned, four nudgets)

; PIC format:
;            offset     size       name   description
;              0          2        WX     Width  of picture in BIG NUDGETS
;              2          2        WY     Height of picture in PIXELS
;              4       WX*WY*4     ----   pixel data

        extrn _GetPic:near

;_GetPic  fills a PIC structure with the bitmap rectangle
;         located in the display page ESI
;         at position (EAX,EDX)
;         with width ECX and height EBX
        ; in:
        ; edi = pic dest
        ; esi = scr source
        ; eax = x in pixels
        ; edx = y in pixels
        ; ecx = x width in big-nudgets
        ; ebx = y height in pixels
        ; out:
        ; edi = ptr to end of picture

        extrn _PutPic:near

; _PutPic  blits a picture to screen
        ; edi = scr dest
        ; esi = pic ptr
        ; eax =  x in pixels
        ; edx =  y in pixels
        ; bl  =  blit mode flag    1= left-rigth reversed blit

; An Spt (encoded SPriTe)
; has a 4 byte header
; offset size  meaning
;      0    2  width in nudgets
;      2    2  height in pixels
; then "packeted" pixel data follows

; RLE packet:   [..] == .. is optional
; RLE_HEADER, [INCR 1byte ], [DATA_HEAD 0..3 byte ],[DATA_DWORD 0..n dwords]


; RLE_HEADER  bit 0..1 = data_head lenght (0..3 BYTES)
;             bit    2 = dword data present
;             bit    3 = new line after this blit
;             bit 4..7 = dword counter n  (0..15 DWORDS)

        extrn _PutSpt:near
        
;_PutSpt blits a TRLE encoded SPT data struct
        ; edi = scr dest
        ; esi = encoded sprite pic ptr
        ; eax =  x in pixels
        ; edx =  y in pixels
        ; bl  =  drawing flags (1 = reverse left-right)
        
        extrn _Pic2Spt:near
;_Pic2Spt  translates from PIC bitmap format to SPT bitmap format        
        ; 
        ; ESI = pointer to PIC data max. 63 pixels wide
        ; EDI = pointer to buffer for SPT data
        ; returns:
        ;  ESI = end of PIC data
        ;  EDI = pointer to end of SPT bitmap data
        ;        If PIC data is too big, EDI is equal to its initial value

