# Turbo-Make / UNIX Makefile for PVRAY Quantizer by F van der Hulst

# Turbo C stuff

# CC     =c:\tc\tcc
# OBJ    =obj
# LINK   =c:\tc\tlink
# CFLAGS =-mc -1 -a -K -G -O -Z -d -c -k- -N- -v- -p -C -Ic:\tc\include -w -DHECKBERT
# LFLAGS = @link.hec

# Following are for SCO Unix:
# CC     = cc
# LINK   = cc
# OBJ    = o
# CFLAGS = -c -M3 -J -DHECKBERT -Ox
# LFLAGS = -o ../bin/heckbert -Ox -lm

# Following are for GNU:
CC     = gcc
LINK   = gcc
OBJ    = o
CFLAGS = -ansi -c -O -I/usr/lib/gcc-include -Dsparc -DHECKBERT
LFLAGS = -o ../bin/heckbert /usr/lib/libm.a

# Implicit rules for making an object file from a .C file...
#
.c.$(OBJ) :
	$(CC) $(CFLAGS) $*.c

OBJS = quant.$(OBJ) files.$(OBJ) egif_lib.$(OBJ) gif_hash.$(OBJ) heckbert.$(OBJ) virt_mem.$(OBJ)

heckbert.exe : $(OBJS)
	$(LINK) $(OBJS) $(LFLAGS)

quant.$(OBJ)    : quant.c quant.h heckbert.h

egif_lib.$(OBJ) : egif_lib.c quant.h gif_hash.h

gif_hash.$(OBJ) : gif_hash.c gif_hash.h

files.$(OBJ)    : files.c quant.h

heckbert.$(OBJ) : heckbert.c quant.h heckbert.h

virt_mem.$(OBJ) : virt_mem.c quant.h heckbert.h
