/**************************** FUZYTEST.C **************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <string.h>
#include <malloc.h>

struct	fzsys
	{
	int	no_in1, no_in2, no_out;
	float	*memin1, *memin2, *memout;
	int	**mat;
	};

typedef struct	fzsys	fuzzy;

void main()
	{
	fuzzy	*fz1, *fz2;
	int	load_fuzzy(char fname[], fuzzy *fz);
	float	run_fuzzy(float in1, float in2, fuzzy *fz);
	float	in1, in2, in3, output1, output2;
	char	fname[80];

	if((fz1=(fuzzy *)malloc(sizeof(fuzzy)))==NULL)
		exit(1);
	if((fz2=(fuzzy *)malloc(sizeof(fuzzy)))==NULL)
		exit(1);
	printf("\nA 3-input single-output fuzzy system made from\n"
		"two 2-input single-output fuzzy systems:\n\n"
"               __________________      _________________\n"
"1st input --->| 1st fuzzy system |--->|                 |\n"
"2nd input --->|                  |    | 2nd fuzzy system|---> output\n"
"               ~~~~~~~~~~~~~~~~~~     |                 |\n"
"3rd input --------------------------->|                 |\n"
"                                       ~~~~~~~~~~~~~~~~~\n\n");

	printf("Enter name of the rule-base for the 1st fuzzy system = ");
	scanf("%s",fname);
	if(! load_fuzzy(fname,fz1))
		exit(1);
	printf("Enter name of the rule-base for the 2nd fuzzy system = ");
	scanf("%s",fname);
	if(! load_fuzzy(fname,fz2))
		exit(1);

	printf("Enter 1st input = ");
	scanf("%f",&in1);
	printf("Enter 2nd input = ");
	scanf("%f",&in2);
	printf("Enter 3rd input = ");
	scanf("%f",&in3);
	output1=run_fuzzy(in1,in2,fz1);
	output2=run_fuzzy(output1,in3,fz2);
	printf("Output from 1st system = %g\n",output1);
	printf("Output from 2nd system = %g\n",output2);
	}

/****************************************************************/
int	load_fuzzy(char fname[], fuzzy *fz)
	{
	FILE    *fdat;
	int	i, j;

	if((fdat=fopen(fname,"r"))==NULL)
		{
		printf("Can't open rule-base\n\a");
		return 0;
		}
	if(fscanf(fdat,"%d",&fz->no_in1)==EOF)
		{
		printf("Error in rule-base\n\a");
		fclose(fdat);
		return 0;
		}
	if((fz->memin1=(float *)malloc(4*fz->no_in1*sizeof(float)))==NULL)
		exit(1);
	for(i=0; i<fz->no_in1; ++i)
	    for(j=0; j<4; ++j)
		if(fscanf(fdat,"%f",fz->memin1+(i*4)+j)==EOF)
			{
			printf("Error in rule-base\n\a");
			fclose(fdat);
			return 0;
			}
	if(fscanf(fdat,"%d",&fz->no_in2)==EOF)
		{
		printf("Error in rule-base\n\a");
		fclose(fdat);
		return 0;
		}
	if((fz->memin2=(float *)malloc(4*fz->no_in2*sizeof(float)))==NULL)
		exit(1);
	for(i=0; i<fz->no_in2; ++i)
	    for(j=0; j<4; ++j)
		if(fscanf(fdat,"%f",fz->memin2+(i*4)+j)==EOF)
			{
			printf("Error in rule-base\n\a");
			fclose(fdat);
			return 0;
			}
	if(fscanf(fdat,"%d",&fz->no_out)==EOF)
		{
		printf("Error in rule-base\n\a");
		fclose(fdat);
		return 0;
		}
	if((fz->memout=(float *)malloc(4*fz->no_out*sizeof(float)))==NULL)
		exit(1);
	for(i=0; i<fz->no_out; ++i)
	    for(j=0; j<4; ++j)
		if(fscanf(fdat,"%f",fz->memout+(i*4)+j)==EOF)
			{
			printf("Error in rule-base\n\a");
			fclose(fdat);
			return 0;
			}

	if((fz->mat=(int **)malloc(fz->no_in1*sizeof(int *)))==NULL)
		exit(1);
	for(i=0; i<fz->no_in1; ++i)
		if((*(fz->mat+i)=(int *)malloc(fz->no_in2*sizeof(int)))==NULL)
			exit(1);
	for(i=0; i<fz->no_in1; ++i)
		for(j=0; j<fz->no_in2; ++j)
			if(fscanf(fdat,"%d",*(fz->mat+i)+j)==EOF)
				{
				printf("Error in rule-base\n\a");
				fclose(fdat);
				return 0;
				}
	return 1;					//success
	}

/****************************************************************/
float	run_fuzzy(float in1, float in2, fuzzy *fz)
	{
	float	trapezium(float val, float p1, float p2, float p3, float p4);
	float	output, m1, m2, nsum=0.0, dsum=0.0;
	int	i, j, k;

	for(i=0; i<fz->no_in1; ++i)
		for(j=0; j<fz->no_in2; ++j)
			if(*(*(fz->mat+i)+j)>0)
				{
	m1=trapezium(in1,*(fz->memin1+(i*4)),*(fz->memin1+(i*4)+1),
		*(fz->memin1+(i*4)+2),*(fz->memin1+(i*4)+3));
	m2=trapezium(in2,*(fz->memin2+(j*4)),*(fz->memin2+(j*4)+1),
		*(fz->memin2+(j*4)+2),*(fz->memin2+(j*4)+3));
	m1=(float)min(m1,m2);
	for(k=0; k<4; ++k)
	  {
	  nsum=nsum+m1*fz->memout[(*(*(fz->mat+i)+j)-1)*4+k];
	  dsum=dsum+m1;
	  }
				}
	if(dsum==0.0)
		output=0.0;
	else
		output=nsum/dsum;
	return (output);
	}

/****************************************************************/
float	trapezium(float val, float p1, float p2, float p3, float p4)
	{
	if(p2 <= val && val <= p3)
		return 1.0;
	if(val <= p1 || p4 <= val)
		return 0.0;
	if(p1 == p2)
		if(p1 < val && val < p3)
			return 1.0;
	if(p1 != p2)
		if(p1 < val && val < p2)
			return (val - p1)/(p2 - p1);
	if(p3 == p4)
		if(p2 < val && val < p3)
			return 1.0;
	if(p3 != p4)
		if(p3 < val && val < p4)
			return (p4 - val)/(p4 - p3);
	return 0.0;
	}

/****************************************************************/
